/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import com.google.common.base.CaseFormat;
import java.util.Collection;

public final class StringHelper {
    private StringHelper() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static String before(String text, String before) {
        if (!text.contains(before)) {
            return null;
        }
        return text.substring(0, text.indexOf(before));
    }

    public static String between(String text, String after, String before) {
        if ((text = StringHelper.after(text, after)) == null) {
            return null;
        }
        return StringHelper.before(text, before);
    }

    public static String indentCollection(String indent, Collection<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String text : list) {
            sb.append(indent).append(text);
        }
        return sb.toString();
    }

    public static String camelDashToTitle(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        boolean dash = false;
        for (char c : value.toCharArray()) {
            if ('-' == c) {
                dash = true;
                continue;
            }
            if (dash) {
                sb.append(' ');
                sb.append(Character.toUpperCase(c));
            } else if (sb.length() == 0) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            dash = false;
        }
        return sb.toString();
    }

    public static String cutLastZeroDigit(String version) {
        String answer = version;
        String[] parts = version.split("\\.");
        if (parts.length == 3 && parts[2].equals("0")) {
            answer = parts[0] + "." + parts[1];
        }
        return answer;
    }

    public static String wrapCamelCaseWords(String option, int watermark, String newLine) {
        String text = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, option);
        text = text.replace('-', ' ');
        text = StringHelper.wrapWords(text, "\n", watermark, false);
        text = text.replace(' ', '-');
        text = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, text);
        String[] lines = text.split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            line = Character.toUpperCase(line.charAt(0)) + line.substring(1);
            sb.append(line);
            if (i >= lines.length - 1) continue;
            sb.append(newLine);
        }
        return sb.toString();
    }

    private static String wrapWords(String line, String newLine, int watermark, boolean wrapLongWords) {
        if (line == null) {
            return null;
        }
        if (newLine == null) {
            newLine = System.lineSeparator();
        }
        if (watermark < 1) {
            watermark = 1;
        }
        int inputLineLength = line.length();
        int offset = 0;
        StringBuilder sb = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > watermark) {
            if (line.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = line.lastIndexOf(32, watermark + offset);
            if (spaceToWrapAt >= offset) {
                sb.append(line.substring(offset, spaceToWrapAt));
                sb.append(newLine);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                sb.append(line.substring(offset, watermark + offset));
                sb.append(newLine);
                offset += watermark;
                continue;
            }
            spaceToWrapAt = line.indexOf(32, watermark + offset);
            if (spaceToWrapAt >= 0) {
                sb.append(line.substring(offset, spaceToWrapAt));
                sb.append(newLine);
                offset = spaceToWrapAt + 1;
                continue;
            }
            sb.append(line.substring(offset));
            offset = inputLineLength;
        }
        sb.append(line.substring(offset));
        return sb.toString();
    }

    public static String getClassShortName(String className) {
        if (className != null) {
            return className.replaceAll("<.*>", "").replaceAll(".*[.]([^.]+)", "$1");
        }
        return className;
    }
}

