/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.srcgen;

import org.apache.camel.maven.packaging.srcgen.Annotation;
import org.apache.camel.maven.packaging.srcgen.Field;
import org.apache.camel.maven.packaging.srcgen.GenericType;
import org.apache.camel.maven.packaging.srcgen.Method;

public class Property {
    GenericType type;
    String name;
    Field field;
    Method accessor;
    Method mutator;

    public Property(GenericType type, String name) {
        this.type = type;
        this.name = name;
        this.field = new Field().setPrivate().setType(type).setName(name);
        this.accessor = new Method().setPublic().setName("get" + name.substring(0, 1).toUpperCase() + name.substring(1)).setReturnType(type).setBody("return " + name + ";\n");
        this.mutator = new Method().setPublic().setName("set" + name.substring(0, 1).toUpperCase() + name.substring(1)).addParameter(type, name).setReturnType(Void.TYPE).setBody("this." + name + " = " + name + ";\n");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GenericType getType() {
        return this.type;
    }

    public void setType(GenericType type) {
        this.type = type;
    }

    public Field getField() {
        return this.field;
    }

    public Method getAccessor() {
        return this.accessor;
    }

    public Method getMutator() {
        return this.mutator;
    }

    public void removeAccessor() {
        this.accessor = null;
    }

    public void removeMutator() {
        this.mutator = null;
    }

    public void removeField() {
        this.field = null;
    }

    public boolean isMutable() {
        return this.mutator != null;
    }

    public boolean hasField() {
        return this.field != null;
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.field != null && this.field.hasAnnotation(clazz) || this.accessor != null && this.accessor.hasAnnotation(clazz) || this.mutator != null && this.mutator.hasAnnotation(clazz);
    }

    public Annotation getAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (this.field != null && this.field.hasAnnotation(clazz)) {
            return this.field.getAnnotation(clazz);
        }
        if (this.accessor != null && this.accessor.hasAnnotation(clazz)) {
            return this.accessor.getAnnotation(clazz);
        }
        if (this.mutator != null && this.mutator.hasAnnotation(clazz)) {
            return this.mutator.getAnnotation(clazz);
        }
        return null;
    }
}

