/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.DynamicClassLoader;
import org.apache.camel.maven.packaging.dsl.component.ComponentDslBuilderFactoryGenerator;
import org.apache.camel.maven.packaging.dsl.component.ComponentsBuilderFactoryGenerator;
import org.apache.camel.maven.packaging.dsl.component.ComponentsDslMetadataRegistry;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-component-dsl", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ComponentDslMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}")
    protected File baseDir;
    @Parameter
    protected File sourcesOutputDir;
    @Parameter
    protected File componentsMetadata;
    @Parameter
    protected File outputResourcesDir;
    @Parameter(defaultValue="org.apache.camel.builder.component")
    protected String componentsDslPackageName;
    @Parameter(defaultValue="org.apache.camel.builder.component.dsl")
    protected String componentsDslFactoriesPackageName;
    DynamicClassLoader projectClassLoader;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.buildDir = new File(project.getBuild().getDirectory());
        this.baseDir = project.getBasedir();
        this.componentsDslPackageName = "org.apache.camel.builder.component";
        this.componentsDslFactoriesPackageName = "org.apache.camel.builder.component.dsl";
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<File, Supplier<String>> files;
        try {
            this.projectClassLoader = DynamicClassLoader.createDynamicClassLoader(this.project.getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        File camelDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"core/camel-componentdsl");
        if (camelDir == null) {
            this.getLog().debug((CharSequence)"No core/camel-componentdsl folder found, skipping execution");
            return;
        }
        Path root = camelDir.toPath();
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = root.resolve("src/generated/java").toFile();
        }
        if (this.outputResourcesDir == null) {
            this.outputResourcesDir = root.resolve("src/generated/resources").toFile();
        }
        if (this.componentsMetadata == null) {
            this.componentsMetadata = this.outputResourcesDir.toPath().resolve("metadata.json").toFile();
        }
        try {
            files = Files.find(this.buildDir.toPath(), Integer.MAX_VALUE, (p, a) -> a.isRegularFile() && p.toFile().getName().endsWith(".json"), new FileVisitOption[0]).collect(Collectors.toMap(Path::toFile, s -> ComponentDslMojo.cache(() -> ComponentDslMojo.loadJson(s.toFile()))));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.executeComponent(files);
    }

    private void executeComponent(Map<File, Supplier<String>> jsonFiles) throws MojoExecutionException, MojoFailureException {
        TreeSet<String> componentNames = new TreeSet<String>();
        this.findComponentNames(this.buildDir, componentNames);
        if (!componentNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            LinkedList<ComponentModel> allModels = new LinkedList<ComponentModel>();
            for (String componentName : componentNames) {
                String json = ComponentDslMojo.loadComponentJson(jsonFiles, componentName);
                if (json == null) continue;
                ComponentModel model = JsonMapper.generateComponentModel((String)json);
                allModels.add(model);
            }
            Map<String, List<ComponentModel>> grModels = allModels.stream().collect(Collectors.groupingBy(BaseModel::getJavaType));
            for (String componentClass : grModels.keySet()) {
                List<ComponentModel> compModels = grModels.get(componentClass);
                for (ComponentModel model : compModels) {
                    this.createComponentDsl(model);
                }
            }
        }
    }

    private void createComponentDsl(ComponentModel model) throws MojoExecutionException, MojoFailureException {
        ComponentDslBuilderFactoryGenerator componentDslBuilderFactoryGenerator = this.syncAndGenerateSpecificComponentsBuilderFactories(model);
        ComponentsDslMetadataRegistry componentsDslMetadataRegistry = this.syncAndUpdateComponentsMetadataRegistry(model, componentDslBuilderFactoryGenerator.getGeneratedClassName());
        TreeSet<ComponentModel> componentCachedModels = new TreeSet<ComponentModel>(Comparator.comparing(ComponentModel::getScheme));
        componentCachedModels.addAll(componentsDslMetadataRegistry.getComponentCacheFromMemory().values());
        this.syncAndGenerateComponentsBuilderFactories(componentCachedModels);
    }

    private ComponentDslBuilderFactoryGenerator syncAndGenerateSpecificComponentsBuilderFactories(ComponentModel componentModel) throws MojoFailureException {
        ComponentDslBuilderFactoryGenerator componentDslBuilderFactoryGenerator = ComponentDslBuilderFactoryGenerator.generateClass(componentModel, this.projectClassLoader, this.componentsDslPackageName);
        boolean updated = this.writeSourceIfChanged(componentDslBuilderFactoryGenerator.printClassAsString(), this.componentsDslFactoriesPackageName.replace('.', '/'), componentDslBuilderFactoryGenerator.getGeneratedClassName() + ".java", this.sourcesOutputDir);
        if (updated) {
            this.getLog().info((CharSequence)("Updated ComponentDsl: " + componentModel.getScheme()));
        }
        return componentDslBuilderFactoryGenerator;
    }

    private ComponentsDslMetadataRegistry syncAndUpdateComponentsMetadataRegistry(ComponentModel componentModel, String className) {
        ComponentsDslMetadataRegistry componentsDslMetadataRegistry = new ComponentsDslMetadataRegistry(this.sourcesOutputDir.toPath().resolve(this.componentsDslFactoriesPackageName.replace('.', '/')).toFile(), this.componentsMetadata);
        boolean updated = componentsDslMetadataRegistry.addComponentToMetadataAndSyncMetadataFile(componentModel, className);
        if (updated) {
            this.getLog().info((CharSequence)("Updated ComponentDsl metadata: " + componentModel.getScheme()));
        }
        return componentsDslMetadataRegistry;
    }

    private void syncAndGenerateComponentsBuilderFactories(Set<ComponentModel> componentCachedModels) throws MojoFailureException {
        ComponentsBuilderFactoryGenerator componentsBuilderFactoryGenerator = ComponentsBuilderFactoryGenerator.generateClass(componentCachedModels, this.projectClassLoader, this.componentsDslPackageName);
        boolean updated = this.writeSourceIfChanged(componentsBuilderFactoryGenerator.printClassAsString(), this.componentsDslPackageName.replace('.', '/'), componentsBuilderFactoryGenerator.getGeneratedClassName() + ".java", this.sourcesOutputDir);
        if (updated) {
            this.getLog().info((CharSequence)("Updated " + componentCachedModels.size() + " ComponentDsl factories"));
        }
    }

    protected static String loadJson(File file) {
        try {
            return PackageHelper.loadText((File)file);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected static String loadComponentJson(Map<File, Supplier<String>> jsonFiles, String componentName) {
        return ComponentDslMojo.loadJsonOfType(jsonFiles, componentName, "component");
    }

    protected static String loadJsonOfType(Map<File, Supplier<String>> jsonFiles, String modelName, String type) {
        for (Map.Entry<File, Supplier<String>> entry : jsonFiles.entrySet()) {
            String json;
            if (!entry.getKey().getName().equals(modelName + ".json") || !(json = entry.getValue().get()).contains("\"kind\": \"" + type + "\"")) continue;
            return json;
        }
        return null;
    }

    protected void findComponentNames(File dir, Set<String> componentNames) {
        File[] files;
        File f = new File(dir, "classes/META-INF/services/org/apache/camel/component");
        if (f.exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                componentNames.add(name);
            }
        }
    }

    protected boolean writeSourceIfChanged(String source, String filePath, String fileName, File outputDir) throws MojoFailureException {
        Path target = outputDir.toPath().resolve(filePath).resolve(fileName);
        try {
            String header;
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");){
                header = PackageHelper.loadText((InputStream)is);
            }
            String code = header + source;
            this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            return ComponentDslMojo.updateResource(this.buildContext, target, code);
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + target, (Throwable)e);
        }
    }
}

