/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="jandex", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true)
public class PackageJandexMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/classes/META-INF/jandex.idx")
    private File index;
    @Parameter(defaultValue="${showStaleFiles}")
    private boolean showStaleFiles;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.classesDirectory = new File(project.getBuild().getOutputDirectory());
        this.index = new File(project.getBuild().getOutputDirectory(), "META-INF/jandex.idx");
        this.showStaleFiles = Boolean.parseBoolean(project.getProperties().getProperty("showStaleFiles", "false"));
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException {
        if (!this.classesDirectory.isDirectory()) {
            return;
        }
        try {
            List inputs = Files.walk(this.classesDirectory.toPath(), new FileVisitOption[0]).filter(f -> f.getFileName().toString().endsWith(".class")).collect(Collectors.toList());
            if (this.index.exists()) {
                long lastmod = this.lastmod(this.index.toPath());
                String stale = inputs.stream().filter(p -> this.lastmod((Path)p) > lastmod).map(Path::toString).collect(Collectors.joining(", "));
                if (!stale.isEmpty()) {
                    this.getLog().info((CharSequence)"Stale files detected, re-generating index.");
                    if (this.showStaleFiles) {
                        this.getLog().info((CharSequence)("Stale files: " + stale));
                    } else if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Stale files: " + stale));
                    }
                } else {
                    this.getLog().info((CharSequence)"Skipping index generation, everything is up to date.");
                    return;
                }
            }
            this.getLog().info((CharSequence)"Building index...");
            Indexer indexer = new Indexer();
            for (Path file : inputs) {
                InputStream fis = Files.newInputStream(file, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    indexer.index(fis);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fis.close();
                }
            }
            Index idx = indexer.complete();
            this.index.getParentFile().mkdirs();
            try (FileOutputStream os = new FileOutputStream(this.index);){
                new IndexWriter((OutputStream)os).write(idx);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private long lastmod(Path p) {
        try {
            return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

