/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.PackageComponentMojo;
import org.apache.camel.maven.packaging.PackageDataFormatMojo;
import org.apache.camel.maven.packaging.PackageLanguageMojo;
import org.apache.camel.maven.packaging.PackageOtherMojo;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="prepare-components", threadSafe=true)
public class PrepareComponentMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File configurerSourceOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File configurerResourceOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File componentOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File dataFormatOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File languageOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File otherOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File schemaOutDir;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${camel-prepare-component}")
    protected boolean prepareComponent;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.configurerSourceOutDir = new File(project.getBasedir(), "src/generated/java");
        this.otherOutDir = this.schemaOutDir = new File(project.getBasedir(), "src/generated/resources");
        this.languageOutDir = this.schemaOutDir;
        this.dataFormatOutDir = this.schemaOutDir;
        this.componentOutDir = this.schemaOutDir;
        this.configurerResourceOutDir = this.schemaOutDir;
        this.buildDir = new File(project.getBuild().getDirectory());
        this.prepareComponent = Boolean.parseBoolean(project.getProperties().getProperty("camel-prepare-component", "false"));
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean core;
        File components;
        File parent;
        Object val;
        if (!this.prepareComponent) {
            return;
        }
        int count = 0;
        count += new PackageComponentMojo(this.getLog(), this.project, this.projectHelper, this.buildDir, this.componentOutDir, this.buildContext).prepareComponent();
        count += new PackageDataFormatMojo(this.getLog(), this.project, this.projectHelper, this.dataFormatOutDir, this.configurerSourceOutDir, this.configurerResourceOutDir, this.schemaOutDir, this.buildContext).prepareDataFormat();
        if ((count += new PackageLanguageMojo(this.getLog(), this.project, this.projectHelper, this.buildDir, this.languageOutDir, this.schemaOutDir, this.buildContext).prepareLanguage()) == 0 && new File(this.project.getBasedir(), "src/main/java").isDirectory()) {
            new PackageOtherMojo(this.getLog(), this.project, this.projectHelper, this.otherOutDir, this.schemaOutDir, this.buildContext).prepareOthers();
            boolean skip = this.project.getArtifactId().endsWith("-maven-plugin");
            if (!skip) {
                count = 1;
            }
        }
        if ((val = this.project.getContextValue("syncPomFile")) != null && Objects.equals(parent = this.project.getBasedir().getParentFile(), components = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"components"))) {
            val = false;
        }
        boolean bl = core = this.project.getParentArtifact() != null && this.project.getParentArtifact().getArtifactId().equals("core");
        if (!core && count > 0 && (val == null || val.equals("true"))) {
            this.syncParentPomFile();
            this.syncAllComponentsPomFile();
        }
    }

    private void syncParentPomFile() throws MojoExecutionException {
        Path root = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"parent").toPath();
        Path pomFile = root.resolve("pom.xml");
        String startDependenciesMarker = "<!-- camel components: START -->";
        String endDependenciesMarker = "<!-- camel components: END -->";
        if (!Files.isRegularFile(pomFile, new LinkOption[0])) {
            throw new MojoExecutionException("Pom file " + pomFile + " does not exist");
        }
        try {
            String pomText = PackageHelper.loadText((Path)pomFile);
            String before = Strings.before((String)pomText, (String)"<!-- camel components: START -->");
            String after = Strings.after((String)pomText, (String)"<!-- camel components: END -->");
            String between = pomText.substring(before.length(), pomText.length() - after.length());
            Pattern pattern = Pattern.compile("<dependency>\\s*<groupId>(?<groupId>.*)</groupId>\\s*<artifactId>(?<artifactId>.*)</artifactId>\\s*<version>\\$\\{project\\.version}</version>\\s*</dependency>");
            Matcher matcher = pattern.matcher(between);
            TreeSet<String> dependencies = new TreeSet<String>();
            while (matcher.find()) {
                dependencies.add(matcher.group());
            }
            dependencies.add("<dependency>\n\t\t\t\t<groupId>" + this.project.getGroupId() + "</groupId>\n\t\t\t\t<artifactId>" + this.project.getArtifactId() + "</artifactId>\n\t\t\t\t<version>${project.version}</version>\n\t\t\t</dependency>");
            String updatedPom = before + "<!-- camel components: START -->" + "\n\t\t\t" + String.join((CharSequence)"\n\t\t\t", dependencies) + "\n\t\t\t" + "<!-- camel components: END -->" + after;
            PrepareComponentMojo.updateResource(this.buildContext, pomFile, updatedPom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file " + pomFile + " Reason: " + e, (Exception)e);
        }
    }

    private void syncAllComponentsPomFile() throws MojoExecutionException {
        Path root = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"core/camel-allcomponents").toPath();
        Path pomFile = root.resolve("pom.xml");
        String startDependenciesMarker = "<dependencies>";
        String endDependenciesMarker = "</dependencies>";
        if (!Files.isRegularFile(pomFile, new LinkOption[0])) {
            throw new MojoExecutionException("Pom file " + pomFile + " does not exist");
        }
        try {
            String pomText = PackageHelper.loadText((Path)pomFile);
            String before = Strings.before((String)pomText, (String)"<dependencies>");
            String after = Strings.after((String)pomText, (String)"</dependencies>");
            String between = pomText.substring(before.length(), pomText.length() - after.length());
            Pattern pattern = Pattern.compile("<dependency>\\s*<groupId>(?<groupId>.*)</groupId>\\s*<artifactId>(?<artifactId>.*)</artifactId>\\s*</dependency>");
            Matcher matcher = pattern.matcher(between);
            TreeSet<String> dependencies = new TreeSet<String>();
            while (matcher.find()) {
                dependencies.add(matcher.group());
            }
            dependencies.add("<dependency>\n\t\t\t<groupId>" + this.project.getGroupId() + "</groupId>\n\t\t\t<artifactId>" + this.project.getArtifactId() + "</artifactId>\n\t\t</dependency>");
            String updatedPom = before + "<dependencies>" + "\n\t\t" + String.join((CharSequence)"\n\t\t", dependencies) + "\n\t" + "</dependencies>" + after;
            PrepareComponentMojo.updateResource(this.buildContext, pomFile, updatedPom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file " + pomFile + " Reason: " + e, (Exception)e);
        }
    }
}

