/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="generate-and-attach-archetype-catalog", threadSafe=true)
public class PackageArchetypeCatalogMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/classes/")
    protected File outDir;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getModel().getPackaging())) {
            try {
                PackageArchetypeCatalogMojo.generateArchetypeCatalog(this.getLog(), this.project, this.projectHelper, this.outDir);
            }
            catch (IOException e) {
                throw new MojoFailureException("Error generating archetype catalog due " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void generateArchetypeCatalog(Log log, MavenProject project, MavenProjectHelper projectHelper, File outDir) throws MojoExecutionException, IOException {
        File archetypes = PackageHelper.findCamelDirectory((File)project.getBasedir(), (String)"archetypes");
        if (archetypes == null || !archetypes.exists()) {
            throw new MojoExecutionException("Cannot find directory: archetypes");
        }
        log.info((CharSequence)("Scanning for Camel Maven Archetypes from directory: " + archetypes));
        File[] dirs = archetypes.listFiles(pathname -> pathname.getName().startsWith("camel-archetype") && pathname.isDirectory());
        ArrayList<ArchetypeModel> models = new ArrayList<ArchetypeModel>();
        for (File dir : dirs) {
            File pom = new File(dir, "pom.xml");
            if (!pom.exists() && !pom.isFile()) continue;
            boolean parent = false;
            ArchetypeModel model = new ArchetypeModel();
            for (Object o : FileUtils.readLines((File)pom, (Charset)StandardCharsets.UTF_8)) {
                String line = o.toString();
                if (line.contains("<parent>")) {
                    parent = true;
                    continue;
                }
                if (line.contains("</parent>")) {
                    parent = false;
                    continue;
                }
                if (parent) {
                    String version = Strings.between((String)line, (String)"<version>", (String)"</version>");
                    if (version == null) continue;
                    model.setVersion(version);
                    continue;
                }
                String groupId = Strings.between((String)line, (String)"<groupId>", (String)"</groupId>");
                String artifactId = Strings.between((String)line, (String)"<artifactId>", (String)"</artifactId>");
                String description = Strings.between((String)line, (String)"<description>", (String)"</description>");
                if (groupId != null && model.getGroupId() == null) {
                    model.setGroupId(groupId);
                }
                if (artifactId != null && model.getArtifactId() == null) {
                    model.setArtifactId(artifactId);
                }
                if (description == null || model.getDescription() != null) continue;
                model.setDescription(description);
            }
            if (model.getGroupId() == null || model.getArtifactId() == null || model.getVersion() == null) continue;
            models.add(model);
        }
        models.sort((o1, o2) -> o1.getArtifactId().compareToIgnoreCase(o2.getArtifactId()));
        log.info((CharSequence)("Found " + models.size() + " archetypes"));
        if (!models.isEmpty()) {
            outDir.mkdirs();
            File out = new File(outDir, "archetype-catalog.xml");
            try (FileOutputStream fos = new FileOutputStream(out, false);){
                PackageArchetypeCatalogMojo.writeTop(fos);
                PackageArchetypeCatalogMojo.writeArchetypes(models, fos);
                PackageArchetypeCatalogMojo.writeBottom(fos);
            }
            log.info((CharSequence)("Saved archetype catalog to file " + out));
            try {
                if (projectHelper != null) {
                    log.info((CharSequence)("Attaching archetype catalog to Maven project: " + project.getArtifactId()));
                    ArrayList<String> includes = new ArrayList<String>();
                    includes.add("archetype-catalog.xml");
                    projectHelper.addResource(project, outDir.getPath(), includes, new ArrayList());
                    projectHelper.attachArtifact(project, "xml", "archetype-catalog", out);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to attach artifact to Maven project. Reason: " + e, e);
            }
        }
    }

    private static void writeBottom(FileOutputStream fos) throws IOException {
        String bottom = "\n  </archetypes>\n</archetype-catalog>\n";
        fos.write(bottom.getBytes());
    }

    private static void writeArchetypes(List<ArchetypeModel> models, FileOutputStream fos) throws IOException {
        for (ArchetypeModel model : models) {
            fos.write("\n    <archetype>".getBytes());
            fos.write(("\n      <groupId>" + model.getGroupId() + "</groupId>").getBytes());
            fos.write(("\n      <artifactId>" + model.getArtifactId() + "</artifactId>").getBytes());
            fos.write(("\n      <version>" + model.getVersion() + "</version>").getBytes());
            if (model.getDescription() != null) {
                fos.write(("\n      <description>" + model.getDescription() + "</description>").getBytes());
            }
            fos.write("\n    </archetype>".getBytes());
        }
    }

    private static void writeTop(FileOutputStream fos) throws IOException {
        String top = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<archetype-catalog>\n  <archetypes>";
        fos.write(top.getBytes());
    }

    private static class ArchetypeModel {
        private String groupId;
        private String artifactId;
        private String version;
        private String description;

        private ArchetypeModel() {
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

