/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.MojoHelper;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.DevConsoleModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.model.PojoBeanModel;
import org.apache.camel.tooling.model.TransformerModel;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="prepare-catalog", threadSafe=true)
public class PrepareCatalogMojo
extends AbstractMojo {
    private static final int UNUSED_LABELS_WARN = 15;
    public static final String SEPARATOR = "================================================================================";
    public static final String ADOC = ".adoc";
    public static final String SRC_GENERATED_RESOURCES = "src/generated/resources";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="true")
    protected Boolean validate;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/components")
    protected File componentsOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/dataformats")
    protected File dataFormatsOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/languages")
    protected File languagesOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/transformers")
    protected File transformersOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/beans")
    protected File beansOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/dev-consoles")
    protected File consolesOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/others")
    protected File othersOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/models")
    protected File modelsOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/models-app")
    protected File modelsAppOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/schemas")
    protected File schemasOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/main")
    protected File mainOutDir;
    @Parameter(defaultValue="${project.basedir}/../../components")
    protected File componentsDir;
    @Parameter(defaultValue="${project.basedir}/../../core/")
    protected File coreDir;
    @Parameter(defaultValue="${project.basedir}/../../core/camel-core-model")
    protected File modelDir;
    @Parameter(defaultValue="${project.basedir}/../../dsl")
    protected File dslDir;
    @Parameter(defaultValue="${project.basedir}/../../core/camel-core-languages")
    protected File languagesDir;
    @Parameter(defaultValue="${project.basedir}/../../components/camel-spring-xml")
    protected File springDir;
    @Parameter(defaultValue="${project.basedir}/../../components/camel-spring-xml/target/schema")
    protected File springSchemaDir;
    @Parameter(defaultValue="${project.basedir}/../../core/camel-main/target/classes/META-INF")
    protected File mainDir;
    @Parameter(defaultValue="false", property="camel.prepare-catalog.skip")
    protected boolean skip;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    private Collection<Path> allJsonFiles;
    private Collection<Path> allPropertiesFiles;
    private final Map<Path, BaseModel<?>> allModels = new HashMap();

    private static String asComponentName(Path file) {
        String name = file.getFileName().toString();
        if (name.endsWith(".json")) {
            return name.substring(0, name.length() - ".json".length());
        }
        if (name.endsWith(ADOC)) {
            return name.substring(0, name.length() - ADOC.length());
        }
        return name;
    }

    private Path getComponentClassesDirectory(Path componentRootDirectory) {
        Path result = componentRootDirectory.resolve("target/classes");
        if (Files.exists(result, new LinkOption[0])) {
            return result;
        }
        String artifactId = componentRootDirectory.getFileName().toString();
        ArtifactRequest req = new ArtifactRequest().setRepositories(this.repositories).setArtifact((Artifact)new DefaultArtifact("org.apache.camel", artifactId, "jar", this.project.getVersion()));
        try {
            ArtifactResult resolutionResult = this.repoSystem.resolveArtifact(this.repoSession, req);
            File file = resolutionResult.getArtifact().getFile();
            if (file != null && file.exists()) {
                this.unzipArtifact(result, file);
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Artifact %s could not be resolved.".formatted(artifactId), (Throwable)e);
        }
        return result;
    }

    private void unzipArtifact(Path targetDirectory, File jarFile) throws IOException {
        Path targetRoot = targetDirectory.normalize();
        try (FileSystem fs = FileSystems.newFileSystem(URI.create("jar:%s".formatted(jarFile.toURI())), Map.of());){
            for (Path root : fs.getRootDirectories()) {
                Stream<Path> walk = Files.walk(root, new FileVisitOption[0]);
                try {
                    walk.forEach(source -> {
                        Path target = targetRoot.resolve(root.relativize((Path)source).toString()).normalize();
                        if (target.startsWith(targetRoot)) {
                            try {
                                if (Files.isDirectory(source, new LinkOption[0])) {
                                    Files.createDirectories(target, new FileAttribute[0]);
                                } else {
                                    Files.copy(source, target, new CopyOption[0]);
                                }
                            }
                            catch (IOException e) {
                                this.getLog().warn((CharSequence)"Could not copy %s to %s.".formatted(source, target), (Throwable)e);
                            }
                        }
                    });
                }
                finally {
                    if (walk == null) continue;
                    walk.close();
                }
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.allJsonFiles = new TreeSet<Path>();
            this.allPropertiesFiles = new TreeSet<Path>();
            try (Stream paths = Stream.of(this.list(this.coreDir.toPath()), this.list(this.componentsDir.toPath())).flatMap(s -> s);
                 Stream<Path> stream = Stream.concat(paths, Stream.of(this.languagesDir.toPath(), this.springDir.toPath())).filter(dir -> !"target".equals(dir.getFileName().toString())).flatMap(p -> MojoHelper.getComponentPath(p).stream()).filter(dir -> Files.isDirectory(dir.resolve("src"), new LinkOption[0])).map(this::getComponentClassesDirectory).flatMap(PackageHelper::walk).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                stream.forEach(p -> {
                    String f = p.getFileName().toString();
                    if (f.endsWith(".json")) {
                        this.allJsonFiles.add((Path)p);
                    } else if (f.equals("component.properties") || f.equals("dataformat.properties") || f.equals("language.properties") || f.equals("other.properties") || f.equals("transformer.properties") || f.equals("bean.properties")) {
                        this.allPropertiesFiles.add((Path)p);
                    }
                });
            }
            for (Path p2 : this.allJsonFiles) {
                BaseModel m = JsonMapper.generateModel((Path)p2);
                if (m == null) continue;
                this.allModels.put(p2, m);
            }
            try (Stream<Path> stream = Stream.of(this.list(this.dslDir.toPath())).flatMap(s -> s).flatMap(p -> MojoHelper.getComponentPath(p).stream()).filter(dir -> Files.isDirectory(dir.resolve(SRC_GENERATED_RESOURCES), new LinkOption[0])).map(p -> p.resolve(SRC_GENERATED_RESOURCES)).flatMap(PackageHelper::walk).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                stream.forEach(p -> {
                    String f = p.getFileName().toString();
                    if (f.endsWith(".json")) {
                        this.allJsonFiles.add((Path)p);
                        BaseModel m = JsonMapper.generateModel((Path)p);
                        if (m instanceof OtherModel) {
                            OtherModel om = (OtherModel)m;
                            if (!this.project.getVersion().equals(om.getVersion())) {
                                try {
                                    String s = Files.readString(p);
                                    s = s.replaceAll(om.getVersion(), this.project.getVersion());
                                    FileUtil.updateFile((Path)p, (String)s);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                om.setVersion(this.project.getVersion());
                            }
                            this.allModels.put((Path)p, (BaseModel<?>)m);
                        }
                    }
                });
            }
            this.executeModel();
            this.executeModelApps();
            Set<String> components = this.executeComponents();
            Set<String> dataformats = this.executeDataFormats();
            Set<String> languages = this.executeLanguages();
            Set<String> transformers = this.executeTransformers();
            Set<String> beans = this.executeBeans();
            Set<String> consoles = this.executeDevConsoles();
            Set<String> others = this.executeOthers();
            this.executeDocuments(components, dataformats, languages, others);
            this.executeXmlSchemas();
            this.executeMain();
        }
        catch (Exception e) {
            throw new MojoFailureException("Error preparing catalog", (Throwable)e);
        }
    }

    protected void executeModel() throws Exception {
        Path modelDir = this.modelDir.toPath();
        this.springDir.toPath();
        Path modelsOutDir = this.modelsOutDir.toPath();
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"Copying all Camel model json descriptors");
        TreeSet<Path> missingLabels = new TreeSet<Path>();
        TreeSet<Path> missingJavaDoc = new TreeSet<Path>();
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        Path coreDirTarget = modelDir.resolve("target/classes/META-INF/org/apache/camel/model");
        Path coreModelAppDirTarget = modelDir.resolve("target/classes/META-INF/org/apache/camel/model/app");
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> p.startsWith(coreDirTarget)).filter(p -> !p.startsWith(coreModelAppDirTarget)).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " model json files"));
        Files.createDirectories(modelsOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> modelsOutDir.resolve(p.getFileName()));
        try (Stream<Path> stream = this.list(modelsOutDir).filter(p -> !newJsons.containsValue(p));){
            stream.forEach(this::delete);
        }
        newJsons.forEach(this::copy);
        for (Path file : jsonFiles) {
            EipModel model = (EipModel)this.allModels.get(file);
            String name = PrepareCatalogMojo.asComponentName(file);
            String label = model.getLabel();
            if (Strings.isNullOrEmpty((String)label)) {
                missingLabels.add(file);
            } else {
                String[] labels;
                for (String s : labels = label.split(",")) {
                    usedLabels.computeIfAbsent(s, k -> new TreeSet()).add(name);
                }
            }
            if (!model.getOptions().stream().filter(option -> !"outputs".equals(option.getName()) && !"transforms".equals(option.getName())).map(BaseOptionModel::getDescription).anyMatch(Strings::isNullOrEmpty)) continue;
            missingJavaDoc.add(file);
        }
        Path all = modelsOutDir.resolve("../models.properties");
        Set modelNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", modelNames) + "\n"));
        this.printModelsReport(jsonFiles, duplicateJsonFiles, missingLabels, usedLabels, missingJavaDoc);
    }

    protected void executeModelApps() throws Exception {
        Path modelDir = this.modelDir.toPath();
        Path modelsOutDir = this.modelsAppOutDir.toPath();
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"Copying all Camel model-app json descriptors");
        Path coreDirTarget = modelDir.resolve("target/classes/META-INF/org/apache/camel/model/app");
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> p.startsWith(coreDirTarget)).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " model-app json files"));
        Files.createDirectories(modelsOutDir, new FileAttribute[0]);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> modelsOutDir.resolve(p.getFileName()));
        try (Stream<Path> stream = this.list(modelsOutDir).filter(p -> !newJsons.containsValue(p));){
            stream.forEach(this::delete);
        }
        newJsons.forEach(this::copy);
        Path all = modelsOutDir.resolve("../models-app.properties");
        Set modelNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", modelNames) + "\n"));
    }

    protected Set<String> executeComponents() throws Exception {
        Path componentsOutDir = this.componentsOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel component json descriptors");
        TreeSet<Path> missingComponents = new TreeSet<Path>();
        TreeMap<String, Set<String>> usedComponentLabels = new TreeMap<String, Set<String>>();
        TreeSet<String> usedOptionLabels = new TreeSet<String>();
        TreeSet<String> unlabeledOptions = new TreeSet<String>();
        TreeSet<Path> missingFirstVersions = new TreeSet<Path>();
        Set componentFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("component.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> this.allModels.get(p) instanceof ComponentModel).collect(Collectors.toCollection(TreeSet::new));
        componentFiles.stream().filter(p -> p.endsWith("component.properties")).forEach(p -> {
            Path parent = this.getModule((Path)p);
            List<Path> jsons = jsonFiles.stream().filter(f -> f.startsWith(parent)).toList();
            if (jsons.isEmpty()) {
                missingComponents.add(parent);
            }
        });
        this.getLog().info((CharSequence)("Found " + componentFiles.size() + " component.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " component json files"));
        Files.createDirectories(componentsOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> componentsOutDir.resolve(p.getFileName()));
        try (Stream<Path> stream = this.list(componentsOutDir).filter(p -> !newJsons.containsValue(p));){
            stream.forEach(this::delete);
        }
        newJsons.forEach(this::copy);
        HashSet<String> alternativeSchemes = new HashSet<String>();
        for (Path file : jsonFiles) {
            try {
                String firstVersion;
                String alternativeScheme;
                String[] labels;
                String text = PackageHelper.loadText((Path)file);
                ComponentModel model = JsonMapper.generateComponentModel((String)text);
                String name = PrepareCatalogMojo.asComponentName(file);
                String label = model.getLabel();
                for (String s : labels = label.split(",")) {
                    Set components = usedComponentLabels.computeIfAbsent(s, k -> new TreeSet());
                    components.add(name);
                }
                model.getComponentOptions().stream().map(BaseOptionModel::getLabel).filter(l -> !Strings.isNullOrEmpty((String)l)).flatMap(l -> Stream.of(label.split(","))).forEach(usedOptionLabels::add);
                model.getEndpointOptions().stream().map(BaseOptionModel::getLabel).filter(l -> !Strings.isNullOrEmpty((String)l)).flatMap(l -> Stream.of(label.split(","))).forEach(usedOptionLabels::add);
                long unused = model.getEndpointOptions().stream().map(BaseOptionModel::getLabel).filter(Strings::isNullOrEmpty).count();
                if (unused >= 15L) {
                    unlabeledOptions.add(name);
                }
                if (!Strings.isNullOrEmpty((String)(alternativeScheme = model.getAlternativeSchemes()))) {
                    String[] parts = alternativeScheme.split(",");
                    alternativeSchemes.addAll(Arrays.asList(parts).subList(1, parts.length));
                }
                if (!Strings.isNullOrEmpty((String)(firstVersion = model.getFirstVersion()))) continue;
                missingFirstVersions.add(file);
            }
            catch (IOException iOException) {}
        }
        Path all = componentsOutDir.resolve("../components.properties");
        Set componentNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", componentNames) + "\n"));
        this.printComponentsReport(jsonFiles, duplicateJsonFiles, missingComponents, usedComponentLabels, usedOptionLabels, unlabeledOptions, missingFirstVersions);
        componentNames.removeAll(alternativeSchemes);
        return componentNames;
    }

    protected Set<String> executeDataFormats() throws Exception {
        Path dataFormatsOutDir = this.dataFormatsOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel dataformat json descriptors");
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        TreeSet<Path> missingFirstVersions = new TreeSet<Path>();
        Set dataFormatFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("dataformat.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> this.allModels.get(p) instanceof DataFormatModel).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + dataFormatFiles.size() + " dataformat.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " dataformat json files"));
        Files.createDirectories(dataFormatsOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> dataFormatsOutDir.resolve(p.getFileName()));
        try (Stream<Path> stream = this.list(dataFormatsOutDir).filter(p -> !newJsons.containsValue(p));){
            stream.forEach(this::delete);
        }
        newJsons.forEach(this::copy);
        for (Path file : jsonFiles) {
            DataFormatModel model = (DataFormatModel)this.allModels.get(file);
            String name = PrepareCatalogMojo.asComponentName(file);
            for (String s : model.getLabel().split(",")) {
                usedLabels.computeIfAbsent(s, k -> new TreeSet()).add(name);
            }
            String firstVersion = model.getFirstVersion();
            if (!Strings.isNullOrEmpty((String)firstVersion)) continue;
            missingFirstVersions.add(file);
        }
        Path all = dataFormatsOutDir.resolve("../dataformats.properties");
        Set dataFormatNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", dataFormatNames) + "\n"));
        this.printDataFormatsReport(jsonFiles, duplicateJsonFiles, usedLabels, missingFirstVersions);
        return dataFormatNames;
    }

    protected Set<String> executeLanguages() throws Exception {
        Path languagesOutDir = this.languagesOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel language json descriptors");
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        TreeSet<Path> missingFirstVersions = new TreeSet<Path>();
        Set languageFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("language.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> this.allModels.get(p) instanceof LanguageModel).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + languageFiles.size() + " language.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " language json files"));
        Files.createDirectories(languagesOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> languagesOutDir.resolve(p.getFileName()));
        try (Stream<Path> stream = this.list(languagesOutDir).filter(p -> !newJsons.containsValue(p));){
            stream.forEach(this::delete);
        }
        newJsons.forEach(this::copy);
        for (Path file : jsonFiles) {
            LanguageModel model = (LanguageModel)this.allModels.get(file);
            String name = PrepareCatalogMojo.asComponentName(file);
            for (String s : model.getLabel().split(",")) {
                usedLabels.computeIfAbsent(s, k -> new TreeSet()).add(name);
            }
            String firstVersion = model.getFirstVersion();
            if (!Strings.isNullOrEmpty((String)firstVersion)) continue;
            missingFirstVersions.add(file);
        }
        Path all = languagesOutDir.resolve("../languages.properties");
        Set languagesNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", languagesNames) + "\n"));
        this.printLanguagesReport(jsonFiles, duplicateJsonFiles, usedLabels, missingFirstVersions);
        return languagesNames;
    }

    protected Set<String> executeTransformers() throws Exception {
        Path transformersOutDir = this.transformersOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel transformer json descriptors");
        Set transformerFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("transformer.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> this.allModels.get(p) instanceof TransformerModel).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + transformerFiles.size() + " transformer.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " transformer json files"));
        Files.createDirectories(transformersOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> transformersOutDir.resolve(p.getFileName()));
        try (Stream<Path> stream = this.list(transformersOutDir).filter(p -> !newJsons.containsValue(p));){
            stream.forEach(this::delete);
        }
        newJsons.forEach(this::copy);
        Path all = transformersOutDir.resolve("../transformers.properties");
        Set transformerNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", transformerNames) + "\n"));
        this.printTransformersReport(jsonFiles, duplicateJsonFiles);
        return transformerNames;
    }

    protected Set<String> executeBeans() throws Exception {
        Path beansOutDir = this.beansOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel pojo bean json descriptors");
        Set beanFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("bean.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> this.allModels.get(p) instanceof PojoBeanModel).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + beanFiles.size() + " bean.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " bean json files"));
        Files.createDirectories(beansOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> beansOutDir.resolve(p.getFileName()));
        try (Stream<Path> stream = this.list(beansOutDir).filter(p -> !newJsons.containsValue(p));){
            stream.forEach(this::delete);
        }
        newJsons.forEach(this::copy);
        Path all = beansOutDir.resolve("../beans.properties");
        Set beanNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", beanNames) + "\n"));
        this.printBeansReport(jsonFiles, duplicateJsonFiles);
        return beanNames;
    }

    protected Set<String> executeDevConsoles() throws Exception {
        Path consolesOutDir = this.consolesOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel dev-consoles json descriptors");
        Set consoleFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("dev-console.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> this.allModels.get(p) instanceof DevConsoleModel).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + consoleFiles.size() + " dev-console.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " dev-console json files"));
        Files.createDirectories(consolesOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> consolesOutDir.resolve(p.getFileName()));
        try (Stream<Path> stream = this.list(consolesOutDir).filter(p -> !newJsons.containsValue(p));){
            stream.forEach(this::delete);
        }
        newJsons.forEach(this::copy);
        Path all = consolesOutDir.resolve("../dev-consoles.properties");
        Set consoleNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", consoleNames) + "\n"));
        this.printConsolesReport(jsonFiles, duplicateJsonFiles);
        return consoleNames;
    }

    private Set<String> executeOthers() throws Exception {
        Path othersOutDir = this.othersOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel other json descriptors");
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        TreeSet<Path> missingFirstVersions = new TreeSet<Path>();
        Set otherFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("other.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> {
            Path m = this.getModule((Path)p);
            switch (m.getFileName().toString()) {
                case "camel-api": 
                case "camel-base": 
                case "camel-base-engine": 
                case "camel-core": 
                case "camel-core-catalog": 
                case "camel-core-engine": 
                case "camel-core-languages": 
                case "camel-core-model": 
                case "camel-core-processor": 
                case "camel-core-reifier": 
                case "camel-core-xml": 
                case "camel-management-api": 
                case "camel-support": 
                case "camel-util": 
                case "camel-xml-io": 
                case "camel-xml-io-util": 
                case "camel-xml-jaxb": 
                case "camel-xml-jaxp": 
                case "dsl-support": 
                case "camel-dsl-support": 
                case "camel-endpointdsl-support": 
                case "camel-ai": 
                case "camel-as2": 
                case "camel-avro-rpc": 
                case "camel-aws": 
                case "camel-azure": 
                case "camel-box": 
                case "camel-cxf": 
                case "camel-debezium": 
                case "camel-debezium-common": 
                case "camel-fhir": 
                case "camel-google": 
                case "camel-http-base": 
                case "camel-http-common": 
                case "camel-huawei": 
                case "camel-infinispan": 
                case "camel-jetty-common": 
                case "camel-kantive": 
                case "camel-microprofile": 
                case "camel-olingo2": 
                case "camel-olingo4": 
                case "camel-salesforce": 
                case "camel-servicenow": 
                case "camel-test": 
                case "camel-vertx": {
                    return false;
                }
            }
            return true;
        }).filter(p -> this.allModels.get(p) instanceof OtherModel).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + otherFiles.size() + " other.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " other json files"));
        Files.createDirectories(othersOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> othersOutDir.resolve(p.getFileName()));
        try (Stream<Path> stream = this.list(othersOutDir).filter(p -> !newJsons.containsValue(p));){
            stream.forEach(this::delete);
        }
        newJsons.forEach(this::copy);
        for (Path file : jsonFiles) {
            String firstVersion;
            OtherModel model = (OtherModel)this.allModels.get(file);
            String name = PrepareCatalogMojo.asComponentName(file);
            String label = model.getLabel();
            if (!Strings.isNullOrEmpty((String)label)) {
                String[] labels;
                for (String s : labels = label.split(",")) {
                    usedLabels.computeIfAbsent(s, k -> new TreeSet()).add(name);
                }
            }
            if (!Strings.isNullOrEmpty((String)(firstVersion = model.getFirstVersion()))) continue;
            missingFirstVersions.add(file);
        }
        Path all = othersOutDir.resolve("../others.properties");
        Set otherNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", otherNames) + "\n"));
        this.printOthersReport(jsonFiles, duplicateJsonFiles, usedLabels, missingFirstVersions);
        return otherNames;
    }

    protected void executeXmlSchemas() throws Exception {
        Path schemasOutDir = this.schemasOutDir.toPath();
        Path springSchemaDir = this.springSchemaDir.toPath();
        this.getLog().info((CharSequence)"Copying Spring XML schema");
        this.copyFile(springSchemaDir.resolve("camel-spring.xsd"), schemasOutDir);
    }

    protected void executeMain() throws Exception {
        this.getLog().info((CharSequence)"Copying camel-main metadata");
        this.copyFile(this.mainDir.toPath().resolve("camel-main-configuration-metadata.json"), this.mainOutDir.toPath());
    }

    protected void executeDocuments(Set<String> components, Set<String> dataformats, Set<String> languages, Set<String> others) {
        TreeSet<Path> adocFiles = new TreeSet<Path>();
        TreeSet<Path> missingAdocFiles = new TreeSet<Path>();
        try (Stream<Path> stream = Stream.concat(this.list(this.componentsDir.toPath()).filter(dir -> !dir.getFileName().startsWith(".") && !"target".equals(dir.getFileName().toString())).flatMap(p -> MojoHelper.getComponentPath(p).stream()), Stream.of(this.coreDir.toPath(), this.languagesDir.toPath()));){
            stream.forEach(dir -> {
                try (Stream<Path> pathStream = PackageHelper.walk((Path)dir.resolve("src/main/docs")).filter(f -> f.getFileName().toString().endsWith(ADOC));){
                    List<Path> l = pathStream.toList();
                    if (l.isEmpty()) {
                        boolean valid;
                        String n = dir.getFileName().toString();
                        boolean isDir = dir.toFile().isDirectory();
                        boolean bl = valid = isDir && !n.startsWith(".") && !n.endsWith("-base") && !n.endsWith("-common") && !n.equals("src");
                        if (valid) {
                            String[] poms = dir.toFile().list((File dir1, String name) -> "pom.xml".equals(name));
                            boolean bl2 = valid = poms != null && poms.length == 1;
                        }
                        if (valid) {
                            missingAdocFiles.add((Path)dir);
                        }
                    } else {
                        adocFiles.addAll(l);
                    }
                }
            });
        }
        this.getLog().info((CharSequence)("Found " + adocFiles.size() + " ascii document files"));
        Set<Path> duplicateAdocFiles = this.getDuplicates(adocFiles);
        Set docNames = adocFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        this.printDocumentsReport(adocFiles, duplicateAdocFiles, missingAdocFiles);
        this.printMissingDocumentsReport(docNames, components, dataformats, languages, others);
    }

    private void printMissingDocumentsReport(Set<String> docs, Set<String> components, Set<String> dataformats, Set<String> languages, Set<String> others) {
        String name;
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel missing documents report");
        this.getLog().info((CharSequence)"");
        ArrayList<String> missing = new ArrayList<String>();
        Iterator<String> iterator = components.iterator();
        while (iterator.hasNext()) {
            String component = switch (component = iterator.next()) {
                case "imap", "imaps", "pop3", "pop3s", "smtp", "smtps" -> "mail";
                case "ftp", "sftp", "ftps" -> "ftp";
            };
            if (docs.contains(name = component + "-component") || component.equalsIgnoreCase("salesforce") || component.equalsIgnoreCase("servicenow")) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc component documentation: " + missing.size()));
            this.printMissingWarning(missing);
        }
        missing.clear();
        for (String dataformat : dataformats) {
            if (dataformat.startsWith("bindy")) {
                dataformat = "bindy";
            }
            if (docs.contains(name = dataformat + "-dataformat")) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc dataformat documentation: " + missing.size()));
            this.printMissingWarning(missing);
        }
        missing.clear();
        for (String language : languages) {
            name = language + "-language";
            if (docs.contains(name)) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc language documentation: " + missing.size()));
            this.printMissingWarning(missing);
        }
        missing.clear();
        for (String other : others) {
            if (docs.contains(other)) continue;
            missing.add(other);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc other documentation: " + missing.size()));
            this.printMissingWarning(missing);
        }
        missing.clear();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SEPARATOR);
    }

    private void printMissingWarning(List<String> missing) {
        for (String name : missing) {
            this.getLog().warn((CharSequence)("\t\t" + name));
        }
    }

    private void printModelsReport(Set<Path> json, Set<Path> duplicate, Set<Path> missingLabels, Map<String, Set<String>> usedLabels, Set<Path> missingJavaDoc) {
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel model catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tModels found: " + json.size()));
        this.printComponentDebug(json);
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate models detected: " + duplicate.size()));
            this.printComponentWarning(duplicate);
        }
        if (!missingLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing labels detected: " + missingLabels.size()));
            this.printComponentWarning(missingLabels);
        }
        this.printUsedLabels(usedLabels);
        if (!missingJavaDoc.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing javadoc on models: " + missingJavaDoc.size()));
            this.printComponentWarning(missingJavaDoc);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SEPARATOR);
    }

    private void printComponentWarning(Set<Path> duplicate) {
        for (Path file : duplicate) {
            this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
    }

    private void printComponentDebug(Set<Path> json) {
        if (this.getLog().isDebugEnabled()) {
            for (Path file : json) {
                this.getLog().debug((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
    }

    private void printUsedLabels(Map<String, Set<String>> usedLabels) {
        if (this.getLog().isDebugEnabled() && !usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry<String, Set<String>> entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + entry.getKey() + ":"));
                for (String name : entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
    }

    private void printComponentsReport(Set<Path> json, Set<Path> duplicate, Set<Path> missing, Map<String, Set<String>> usedComponentLabels, Set<String> usedOptionsLabels, Set<String> unusedLabels, Set<Path> missingFirstVersions) {
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel component catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tComponents found: " + json.size()));
        this.printComponentDebug(json);
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate components detected: " + duplicate.size()));
            this.printComponentWarning(duplicate);
        }
        if (this.getLog().isDebugEnabled()) {
            if (!usedComponentLabels.isEmpty()) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)("\tUsed component labels: " + usedComponentLabels.size()));
                for (Map.Entry entry : usedComponentLabels.entrySet()) {
                    this.getLog().debug((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                    for (String name : (Set)entry.getValue()) {
                        this.getLog().debug((CharSequence)("\t\t\t" + name));
                    }
                }
            }
            if (!usedOptionsLabels.isEmpty()) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)("\tUsed component/endpoint options labels: " + usedOptionsLabels.size()));
                for (String string : usedOptionsLabels) {
                    this.getLog().info((CharSequence)("\t\t\t" + string));
                }
            }
        }
        if (!unusedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tComponent with more than 15 unlabelled options: " + unusedLabels.size()));
            for (String string : unusedLabels) {
                this.getLog().info((CharSequence)("\t\t\t" + string));
            }
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing components detected: " + missing.size()));
            this.printWarnings(missing);
        }
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tComponents without firstVersion defined: " + missingFirstVersions.size()));
            this.printWarnings(missingFirstVersions);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SEPARATOR);
    }

    private void printWarnings(Set<Path> missing) {
        for (Path name : missing) {
            this.getLog().warn((CharSequence)("\t\t" + name.getFileName().toString()));
        }
    }

    private void printDataFormatsReport(Set<Path> json, Set<Path> duplicate, Map<String, Set<String>> usedLabels, Set<Path> missingFirstVersions) {
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel data format catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tDataFormats found: " + json.size()));
        this.printComponentDebug(json);
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate dataformat detected: " + duplicate.size()));
            this.printComponentWarning(duplicate);
        }
        this.printUsedLabels(usedLabels);
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDataFormats without firstVersion defined: " + missingFirstVersions.size()));
            this.printWarnings(missingFirstVersions);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SEPARATOR);
    }

    private void printLanguagesReport(Set<Path> json, Set<Path> duplicate, Map<String, Set<String>> usedLabels, Set<Path> missingFirstVersions) {
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel language catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tLanguages found: " + json.size()));
        this.printComponentDebug(json);
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate language detected: " + duplicate.size()));
            this.printComponentWarning(duplicate);
        }
        this.printUsedLabels(usedLabels);
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tLanguages without firstVersion defined: " + missingFirstVersions.size()));
            this.printWarnings(missingFirstVersions);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SEPARATOR);
    }

    private void printTransformersReport(Set<Path> json, Set<Path> duplicate) {
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel transformer catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tTransformers found: " + json.size()));
        this.printComponentDebug(json);
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate transformer detected: " + duplicate.size()));
            this.printComponentWarning(duplicate);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SEPARATOR);
    }

    private void printBeansReport(Set<Path> json, Set<Path> duplicate) {
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel pojo beans catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tPojo beans found: " + json.size()));
        this.printComponentDebug(json);
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate pojo beans detected: " + duplicate.size()));
            this.printComponentWarning(duplicate);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SEPARATOR);
    }

    private void printConsolesReport(Set<Path> json, Set<Path> duplicate) {
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel dev-console catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tConsoles found: " + json.size()));
        this.printComponentDebug(json);
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate console detected: " + duplicate.size()));
            this.printComponentWarning(duplicate);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SEPARATOR);
    }

    private void printOthersReport(Set<Path> json, Set<Path> duplicate, Map<String, Set<String>> usedLabels, Set<Path> missingFirstVersions) {
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel other catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tOthers found: " + json.size()));
        this.printComponentDebug(json);
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate other detected: " + duplicate.size()));
            this.printComponentWarning(duplicate);
        }
        this.printUsedLabels(usedLabels);
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tOthers without firstVersion defined: " + missingFirstVersions.size()));
            this.printWarnings(missingFirstVersions);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SEPARATOR);
    }

    private void printDocumentsReport(Set<Path> docs, Set<Path> duplicate, Set<Path> missing) {
        this.getLog().info((CharSequence)SEPARATOR);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel document catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tDocuments found: " + docs.size()));
        this.printComponentDebug(docs);
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate document detected: " + duplicate.size()));
            this.printComponentWarning(duplicate);
        }
        this.getLog().info((CharSequence)"");
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing document detected: " + missing.size()));
            this.printWarnings(missing);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SEPARATOR);
    }

    private void copyFile(Path file, Path toDir) throws IOException, MojoFailureException {
        if (Files.isRegularFile(file, new LinkOption[0])) {
            Files.createDirectories(toDir, new FileAttribute[0]);
            Path to = toDir.resolve(file.getFileName());
            try {
                FileUtil.updateFile((Path)file, (Path)to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
        }
    }

    private List<Path> concat(List<Path> l1, List<Path> l2) {
        return Stream.concat(l1.stream(), l2.stream()).collect(Collectors.toList());
    }

    private Stream<Path> list(Path dir) {
        try {
            if (Files.isDirectory(dir, new LinkOption[0])) {
                return Files.list(dir);
            }
            return Stream.empty();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list files in directory: " + dir, e);
        }
    }

    private void delete(Path dir) {
        try {
            Files.delete(dir);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete file: " + dir, e);
        }
    }

    private void copy(Path file, Path to) {
        try {
            try {
                BasicFileAttributes af = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                BasicFileAttributes at = Files.readAttributes(to, BasicFileAttributes.class, new LinkOption[0]);
                if (af.isRegularFile() && at.isRegularFile() && af.size() == at.size() && af.lastModifiedTime().compareTo(at.lastAccessTime()) < 0) {
                    return;
                }
            }
            catch (IOException af) {
                // empty catch block
            }
            FileUtil.updateFile((Path)file, (Path)to);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot copy file from " + file + " -> " + to, e);
        }
    }

    private <U, K, V> Map<K, V> map(Collection<U> col, Function<U, K> key, Function<U, V> value) {
        return col.stream().collect(Collectors.toMap(key, value));
    }

    private <U, K, V> Map<K, V> map(Collection<U> col, Function<U, K> key, Function<U, V> value, BinaryOperator<V> merger) {
        return col.stream().collect(Collectors.toMap(key, value, merger));
    }

    private Path getModule(Path p) {
        Path parent = p;
        while (!parent.endsWith("target") && !parent.endsWith("src")) {
            parent = parent.getParent();
        }
        return parent.getParent();
    }

    private Set<Path> getDuplicates(Set<Path> jsonFiles) {
        Map<String, List> byName = this.map(jsonFiles, PrepareCatalogMojo::asComponentName, Collections::singletonList, this::concat);
        return byName.values().stream().flatMap(l -> l.stream().skip(1L)).collect(Collectors.toCollection(TreeSet::new));
    }
}

