/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="prepare-kamelet-main", threadSafe=true)
public class PrepareKameletMainMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected BuildContext buildContext;
    @Parameter(defaultValue="${project.directory}/../../../catalog/camel-catalog")
    protected File catalogDir;
    @Parameter(defaultValue="src/generated/")
    protected File genDir;
    private final Map<Path, BaseModel<?>> allModels = new HashMap();
    private transient String licenseHeader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.updateKnownDependencies();
        }
        catch (Exception e) {
            throw new MojoFailureException("Error updating camel-component-known-dependencies.properties", (Throwable)e);
        }
    }

    protected void updateKnownDependencies() throws Exception {
        TreeSet<Path> allJsonFiles = new TreeSet<Path>();
        File path = new File(this.catalogDir, "src/generated/resources/org/apache/camel/catalog/components");
        for (File p : path.listFiles()) {
            String f = p.getName();
            if (!f.endsWith(".json")) continue;
            allJsonFiles.add(p.toPath());
        }
        for (Path p : allJsonFiles) {
            BaseModel m = JsonMapper.generateModel((Path)p);
            if (m == null) continue;
            this.allModels.put(p, m);
        }
        List<Object> lines = new ArrayList();
        for (BaseModel<?> model : this.allModels.values()) {
            String fqn = model.getJavaType();
            if (!(model instanceof ArtifactModel)) continue;
            String aid = ((ArtifactModel)model).getArtifactId();
            if (aid.startsWith("camel-")) {
                aid = aid.substring(6);
            }
            String line = fqn + "=camel:" + aid;
            lines.add(line);
        }
        lines = lines.stream().distinct().collect(Collectors.toList());
        Collections.sort(lines);
        try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header.txt");){
            this.licenseHeader = PackageHelper.loadText((InputStream)is);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error loading license-header.txt file", (Throwable)e);
        }
        String source = String.join((CharSequence)"\n", lines) + "\n";
        this.writeSourceIfChanged(source, "resources", "camel-component-known-dependencies.properties", this.genDir);
    }

    protected boolean writeSourceIfChanged(String source, String filePath, String fileName, File outputDir) throws MojoFailureException {
        Path target = outputDir.toPath().resolve(filePath).resolve(fileName);
        try {
            String code = PackagePluginUtils.joinHeaderAndSource(this.licenseHeader, source);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            }
            return PrepareKameletMainMojo.updateResource(this.buildContext, target, code);
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + target, (Throwable)e);
        }
    }

    public static boolean updateResource(BuildContext buildContext, Path out, String data) {
        try {
            if (FileUtil.updateFile((Path)out, (String)data)) {
                PrepareKameletMainMojo.refresh(buildContext, out);
                return true;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return false;
    }

    public static void refresh(BuildContext buildContext, Path file) {
        if (buildContext != null) {
            buildContext.refresh(file.toFile());
        }
    }
}

