/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class QuartzEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":groupName/triggerName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "quartz".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "groupName", "Camel", false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "triggerName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(19);
        props.add("autoStartScheduler");
        props.add("bridgeErrorHandler");
        props.add("cron");
        props.add("customCalendar");
        props.add("deleteJob");
        props.add("durableJob");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("groupName");
        props.add("ignoreExpiredNextFireTime");
        props.add("jobParameters");
        props.add("pauseJob");
        props.add("prefixJobNameWithEndpointId");
        props.add("recoverableJob");
        props.add("stateful");
        props.add("triggerName");
        props.add("triggerParameters");
        props.add("triggerStartDelay");
        props.add("usingFixedCamelContextName");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashSet<String> prefixes = new HashSet<String>(2);
        prefixes.add("job.");
        prefixes.add("trigger.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

