/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.StartupListener;
import org.apache.camel.component.quartz2.QuartzEndpoint;
import org.apache.camel.component.quartz2.QuartzHelper;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzComponent
extends UriEndpointComponent
implements StartupListener {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzComponent.class);
    private SchedulerFactory schedulerFactory;
    private Scheduler scheduler;
    private Properties properties;
    private String propertiesFile;
    private int startDelayedSeconds;
    private boolean autoStartScheduler = true;
    private boolean prefixJobNameWithEndpointId;
    private boolean enableJmx = true;
    private boolean prefixInstanceName = true;

    public QuartzComponent() {
        super(QuartzEndpoint.class);
    }

    public QuartzComponent(CamelContext camelContext) {
        super(camelContext, QuartzEndpoint.class);
    }

    public boolean isAutoStartScheduler() {
        return this.autoStartScheduler;
    }

    public void setAutoStartScheduler(boolean autoStartScheduler) {
        this.autoStartScheduler = autoStartScheduler;
    }

    public int getStartDelayedSeconds() {
        return this.startDelayedSeconds;
    }

    public void setStartDelayedSeconds(int startDelayedSeconds) {
        this.startDelayedSeconds = startDelayedSeconds;
    }

    public boolean isPrefixJobNameWithEndpointId() {
        return this.prefixJobNameWithEndpointId;
    }

    public void setPrefixJobNameWithEndpointId(boolean prefixJobNameWithEndpointId) {
        this.prefixJobNameWithEndpointId = prefixJobNameWithEndpointId;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public boolean isPrefixInstanceName() {
        return this.prefixInstanceName;
    }

    public void setPrefixInstanceName(boolean prefixInstanceName) {
        this.prefixInstanceName = prefixInstanceName;
    }

    public SchedulerFactory getSchedulerFactory() throws SchedulerException {
        if (this.schedulerFactory == null) {
            this.schedulerFactory = this.createSchedulerFactory();
        }
        return this.schedulerFactory;
    }

    private SchedulerFactory createSchedulerFactory() throws SchedulerException {
        StdSchedulerFactory answer;
        Properties prop = this.loadProperties();
        if (prop != null) {
            prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
            prop.put("org.terracotta.quartz.skipUpdateCheck", "true");
            if (this.isPrefixInstanceName()) {
                String instName = this.createInstanceName(prop);
                prop.setProperty("org.quartz.scheduler.instanceName", instName);
            }
            if (this.enableJmx && !prop.containsKey("org.quartz.scheduler.jmx.export")) {
                prop.put("org.quartz.scheduler.jmx.export", "true");
                LOG.info("Setting org.quartz.scheduler.jmx.export=true to ensure QuartzScheduler(s) will be enlisted in JMX.");
            }
            answer = new StdSchedulerFactory(prop);
        } else {
            InputStream is = StdSchedulerFactory.class.getClassLoader().getResourceAsStream("org/quartz/quartz.properties");
            if (is == null) {
                throw new SchedulerException("Quartz properties file not found in classpath: org/quartz/quartz.properties");
            }
            prop = new Properties();
            try {
                prop.load(is);
            }
            catch (IOException e) {
                throw new SchedulerException("Error loading Quartz properties file from classpath: org/quartz/quartz.properties", (Throwable)e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
            if (this.isPrefixInstanceName()) {
                String instName = this.createInstanceName(prop);
                prop.setProperty("org.quartz.scheduler.instanceName", instName);
            }
            prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
            prop.put("org.terracotta.quartz.skipUpdateCheck", "true");
            if (this.enableJmx && !prop.containsKey("org.quartz.scheduler.jmx.export")) {
                prop.put("org.quartz.scheduler.jmx.export", "true");
                LOG.info("Setting org.quartz.scheduler.jmx.export=true to ensure QuartzScheduler(s) will be enlisted in JMX.");
            }
            answer = new StdSchedulerFactory(prop);
        }
        if (LOG.isDebugEnabled()) {
            String name = prop.getProperty("org.quartz.scheduler.instanceName");
            LOG.debug("Creating SchedulerFactory: {} with properties: {}", (Object)name, (Object)prop);
        }
        return answer;
    }

    protected String createInstanceName(Properties prop) {
        String instName = prop.getProperty("org.quartz.scheduler.instanceName");
        String identity = QuartzHelper.getQuartzContextName(this.getCamelContext());
        if (identity != null) {
            instName = instName == null ? "scheduler-" + identity : instName + "-" + identity;
        }
        return instName;
    }

    public boolean isClustered() throws SchedulerException {
        return this.getScheduler().getMetaData().isJobStoreClustered();
    }

    private Properties loadProperties() throws SchedulerException {
        Properties answer = this.getProperties();
        if (answer == null && this.getPropertiesFile() != null) {
            LOG.info("Loading Quartz properties file from: {}", (Object)this.getPropertiesFile());
            InputStream is = null;
            try {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.getPropertiesFile());
                answer = new Properties();
                answer.load(is);
            }
            catch (IOException e) {
                try {
                    throw new SchedulerException("Error loading Quartz properties file: " + this.getPropertiesFile(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)is);
        }
        return answer;
    }

    public void setSchedulerFactory(SchedulerFactory schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Boolean prefixJobNameWithEndpointId;
        Boolean autoStartScheduler;
        Integer startDelayedSeconds = (Integer)this.getAndRemoveParameter(parameters, "startDelayedSeconds", Integer.class);
        if (startDelayedSeconds != null) {
            if (this.startDelayedSeconds != 0 && this.startDelayedSeconds != startDelayedSeconds) {
                LOG.warn("A Quartz job is already configured with a different 'startDelayedSeconds' configuration! All Quartz jobs must share the same 'startDelayedSeconds' configuration! Cannot apply the 'startDelayedSeconds' configuration!");
            } else {
                this.startDelayedSeconds = startDelayedSeconds;
            }
        }
        if ((autoStartScheduler = (Boolean)this.getAndRemoveParameter(parameters, "autoStartScheduler", Boolean.class)) != null) {
            this.autoStartScheduler = autoStartScheduler;
        }
        if ((prefixJobNameWithEndpointId = (Boolean)this.getAndRemoveParameter(parameters, "prefixJobNameWithEndpointId", Boolean.class)) != null) {
            this.prefixJobNameWithEndpointId = prefixJobNameWithEndpointId;
        }
        Map triggerParameters = IntrospectionSupport.extractProperties(parameters, (String)"trigger.");
        Map jobParameters = IntrospectionSupport.extractProperties(parameters, (String)"job.");
        QuartzEndpoint result = new QuartzEndpoint(uri, this);
        TriggerKey triggerKey = this.createTriggerKey(uri, remaining, result);
        result.setTriggerKey(triggerKey);
        result.setTriggerParameters(triggerParameters);
        result.setJobParameters(jobParameters);
        if (startDelayedSeconds != null) {
            result.setStartDelayedSeconds(startDelayedSeconds);
        }
        if (autoStartScheduler != null) {
            result.setAutoStartScheduler(autoStartScheduler);
        }
        if (prefixJobNameWithEndpointId != null) {
            result.setPrefixJobNameWithEndpointId(prefixJobNameWithEndpointId);
        }
        return result;
    }

    private TriggerKey createTriggerKey(String uri, String remaining, QuartzEndpoint endpoint) throws Exception {
        String name;
        String group;
        URI u = new URI(uri);
        String path = ObjectHelper.after((String)u.getPath(), (String)"/");
        String host = u.getHost();
        if (host == null && (host = ObjectHelper.before((String)remaining, (String)"/")) == null) {
            host = remaining;
        }
        if (ObjectHelper.isNotEmpty((Object)path) && ObjectHelper.isNotEmpty((Object)host)) {
            group = host;
            name = path;
        } else {
            String camelContextName = this.getCamelContext().getManagementName();
            group = camelContextName == null ? "Camel" : "Camel_" + camelContextName;
            name = host;
        }
        if (this.prefixJobNameWithEndpointId) {
            name = endpoint.getId() + "_" + name;
        }
        return new TriggerKey(name, group);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.scheduler == null) {
            this.createAndInitScheduler();
        }
    }

    private void createAndInitScheduler() throws SchedulerException {
        LOG.info("Create and initializing scheduler.");
        this.scheduler = this.createScheduler();
        SchedulerContext quartzContext = this.storeCamelContextInQuartzContext();
        AtomicInteger number = (AtomicInteger)quartzContext.get((Object)"CamelQuartzJobsCount");
        if (number == null) {
            number = new AtomicInteger(0);
            quartzContext.put("CamelQuartzJobsCount", (Object)number);
        }
    }

    private SchedulerContext storeCamelContextInQuartzContext() throws SchedulerException {
        SchedulerContext quartzContext = this.scheduler.getContext();
        String camelContextName = QuartzHelper.getQuartzContextName(this.getCamelContext());
        LOG.debug("Storing camelContextName={} into Quartz Context space.", (Object)camelContextName);
        quartzContext.put("CamelQuartzCamelContext-" + camelContextName, (Object)this.getCamelContext());
        return quartzContext;
    }

    private Scheduler createScheduler() throws SchedulerException {
        return this.getSchedulerFactory().getScheduler();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.scheduler != null) {
            AtomicInteger number = (AtomicInteger)this.scheduler.getContext().get((Object)"CamelQuartzJobsCount");
            if (number != null && number.get() > 0) {
                LOG.info("Cannot shutdown scheduler: " + this.scheduler.getSchedulerName() + " as there are still " + number.get() + " jobs registered.");
            } else {
                LOG.info("Shutting down scheduler. (will wait for all jobs to complete first.)");
                this.scheduler.shutdown(true);
                this.scheduler = null;
            }
        }
    }

    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        if (this.scheduler == null) {
            this.createAndInitScheduler();
        } else {
            this.storeCamelContextInQuartzContext();
        }
        if (!this.autoStartScheduler) {
            LOG.info("Not starting scheduler because autoStartScheduler is set to false.");
        } else if (this.startDelayedSeconds > 0) {
            if (this.scheduler.isStarted()) {
                LOG.warn("The scheduler has already started. Cannot apply the 'startDelayedSeconds' configuration!");
            } else {
                LOG.info("Starting scheduler with startDelayedSeconds={}", (Object)this.startDelayedSeconds);
                this.scheduler.startDelayed(this.startDelayedSeconds);
            }
        } else if (this.scheduler.isStarted()) {
            LOG.info("The scheduler has already been started.");
        } else {
            LOG.info("Starting scheduler.");
            this.scheduler.start();
        }
    }
}

