/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz2;

import java.io.Serializable;
import java.util.List;
import org.apache.camel.Route;
import org.apache.camel.routepolicy.quartz2.ScheduledJobState;
import org.apache.camel.routepolicy.quartz2.ScheduledRoutePolicy;
import org.apache.camel.routepolicy.quartz2.ScheduledRoutePolicyConstants;
import org.apache.camel.spi.RoutePolicy;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledJob
implements Job,
Serializable,
ScheduledRoutePolicyConstants {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledJob.class);
    private static final long serialVersionUID = 26L;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        LOG.debug("Running ScheduledJob: jobExecutionContext={}", (Object)jobExecutionContext);
        SchedulerContext schedulerContext = this.getSchedulerContext(jobExecutionContext);
        ScheduledJobState state = (ScheduledJobState)schedulerContext.get((Object)jobExecutionContext.getJobDetail().getKey().toString());
        ScheduledRoutePolicyConstants.Action storedAction = state.getAction();
        Route storedRoute = state.getRoute();
        List policyList = storedRoute.getRouteContext().getRoutePolicyList();
        for (RoutePolicy policy : policyList) {
            try {
                if (!(policy instanceof ScheduledRoutePolicy)) continue;
                ((ScheduledRoutePolicy)policy).onJobExecute(storedAction, storedRoute);
            }
            catch (Exception e) {
                throw new JobExecutionException("Failed to execute Scheduled Job for route " + storedRoute.getId() + " with trigger name: " + jobExecutionContext.getTrigger().getKey(), (Throwable)e);
            }
        }
    }

    private SchedulerContext getSchedulerContext(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            return jobExecutionContext.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed to obtain scheduler context for job " + jobExecutionContext.getJobDetail().getKey());
        }
    }
}

