/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.LongString;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.TrustManager;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rabbitmq.RabbitMQComponent;
import org.apache.camel.component.rabbitmq.RabbitMQConsumer;
import org.apache.camel.component.rabbitmq.RabbitMQProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="rabbitmq", syntax="rabbitmq:hostname:portNumber/exchangeName", consumerClass=RabbitMQConsumer.class, label="messaging")
public class RabbitMQEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private String hostname;
    @UriPath
    @Metadata(required="true")
    private int portNumber;
    @UriPath
    @Metadata(required="true")
    private String exchangeName;
    @UriParam(defaultValue="guest")
    private String username = "guest";
    @UriParam(defaultValue="guest")
    private String password = "guest";
    @UriParam(defaultValue="/")
    private String vhost = "/";
    @UriParam(defaultValue="10")
    private int threadPoolSize = 10;
    @UriParam(defaultValue="true")
    private boolean autoAck = true;
    @UriParam(defaultValue="true")
    private boolean autoDelete = true;
    @UriParam(defaultValue="true")
    private boolean durable = true;
    @UriParam(defaultValue="false")
    private boolean bridgeEndpoint;
    private String queue = String.valueOf(UUID.randomUUID().toString().hashCode());
    @UriParam(defaultValue="direct")
    private String exchangeType = "direct";
    @UriParam
    private String routingKey;
    @UriParam
    private Address[] addresses;
    @UriParam(defaultValue="0")
    private int connectionTimeout = 0;
    @UriParam(defaultValue="0")
    private int requestedChannelMax = 0;
    @UriParam(defaultValue="0")
    private int requestedFrameMax = 0;
    @UriParam(defaultValue="0")
    private int requestedHeartbeat = 0;
    @UriParam
    private String sslProtocol;
    @UriParam
    private TrustManager trustManager;
    @UriParam
    private Map<String, Object> clientProperties;
    @UriParam
    private ConnectionFactory connectionFactory;
    @UriParam
    private Boolean automaticRecoveryEnabled;
    @UriParam
    private Integer networkRecoveryInterval;
    @UriParam
    private Boolean topologyRecoveryEnabled;
    @UriParam
    private boolean prefetchEnabled;
    @UriParam
    private int prefetchSize;
    @UriParam
    private int prefetchCount;
    @UriParam
    private boolean prefetchGlobal;
    @UriParam(defaultValue="1")
    private int concurrentConsumers = 1;
    @UriParam(defaultValue="true")
    private boolean declare = true;
    @UriParam
    private String deadLetterExchange;
    @UriParam
    private String deadLetterRoutingKey;
    @UriParam
    private String deadLetterQueue;
    @UriParam(defaultValue="direct")
    private String deadLetterExchangeType = "direct";
    @UriParam(defaultValue="10")
    private int channelPoolMaxSize = 10;
    @UriParam(defaultValue="1000")
    private long channelPoolMaxWait = 1000L;

    public RabbitMQEndpoint() {
    }

    public RabbitMQEndpoint(String endpointUri, RabbitMQComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
    }

    public RabbitMQEndpoint(String endpointUri, RabbitMQComponent component, ConnectionFactory connectionFactory) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.connectionFactory = connectionFactory;
    }

    public Exchange createRabbitExchange(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        DefaultExchange exchange = new DefaultExchange(this.getCamelContext(), this.getExchangePattern());
        DefaultMessage message = new DefaultMessage();
        exchange.setIn((Message)message);
        message.setHeader("rabbitmq.ROUTING_KEY", (Object)envelope.getRoutingKey());
        message.setHeader("rabbitmq.EXCHANGE_NAME", (Object)envelope.getExchange());
        message.setHeader("rabbitmq.DELIVERY_TAG", (Object)envelope.getDeliveryTag());
        Map headers = properties.getHeaders();
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                if (entry.getValue() instanceof LongString) {
                    message.setHeader((String)entry.getKey(), (Object)entry.getValue().toString());
                    continue;
                }
                message.setHeader((String)entry.getKey(), entry.getValue());
            }
        }
        message.setBody((Object)body);
        return exchange;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RabbitMQConsumer consumer = new RabbitMQConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Connection connect(ExecutorService executor) throws IOException {
        if (this.getAddresses() == null) {
            return this.getOrCreateConnectionFactory().newConnection(executor);
        }
        return this.getOrCreateConnectionFactory().newConnection(executor, this.getAddresses());
    }

    public void declareExchangeAndQueue(Channel channel) throws IOException {
        HashMap<String, String> queueArgs = null;
        if (this.deadLetterExchange != null) {
            queueArgs = new HashMap<String, String>();
            queueArgs.put("x-dead-letter-exchange", this.getDeadLetterExchange());
            queueArgs.put("x-dead-letter-routing-key", this.getDeadLetterRoutingKey());
            channel.exchangeDeclare(this.getDeadLetterExchange(), this.getDeadLetterExchangeType(), this.isDurable(), this.isAutoDelete(), new HashMap());
            channel.queueDeclare(this.getDeadLetterQueue(), this.isDurable(), false, this.isAutoDelete(), null);
            channel.queueBind(this.getDeadLetterQueue(), this.getDeadLetterExchange(), this.getDeadLetterRoutingKey() == null ? "" : this.getDeadLetterRoutingKey());
        }
        channel.exchangeDeclare(this.getExchangeName(), this.getExchangeType(), this.isDurable(), this.isAutoDelete(), new HashMap());
        if (this.getQueue() != null) {
            channel.queueDeclare(this.getQueue(), this.isDurable(), false, this.isAutoDelete(), queueArgs);
            channel.queueBind(this.getQueue(), this.getExchangeName(), this.getRoutingKey() == null ? "" : this.getRoutingKey());
        }
    }

    private ConnectionFactory getOrCreateConnectionFactory() {
        if (this.connectionFactory == null) {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setUsername(this.getUsername());
            factory.setPassword(this.getPassword());
            factory.setVirtualHost(this.getVhost());
            factory.setHost(this.getHostname());
            factory.setPort(this.getPortNumber());
            if (this.getClientProperties() != null) {
                factory.setClientProperties(this.getClientProperties());
            }
            factory.setConnectionTimeout(this.getConnectionTimeout());
            factory.setRequestedChannelMax(this.getRequestedChannelMax());
            factory.setRequestedFrameMax(this.getRequestedFrameMax());
            factory.setRequestedHeartbeat(this.getRequestedHeartbeat());
            if (this.getSslProtocol() != null) {
                try {
                    if (this.getSslProtocol().equals("true")) {
                        factory.useSslProtocol();
                    } else if (this.getTrustManager() == null) {
                        factory.useSslProtocol(this.getSslProtocol());
                    } else {
                        factory.useSslProtocol(this.getSslProtocol(), this.getTrustManager());
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException("Invalid sslProtocol " + this.sslProtocol, e);
                }
                catch (KeyManagementException e) {
                    throw new IllegalArgumentException("Invalid sslProtocol " + this.sslProtocol, e);
                }
            }
            if (this.getAutomaticRecoveryEnabled() != null) {
                factory.setAutomaticRecoveryEnabled(this.getAutomaticRecoveryEnabled().booleanValue());
            }
            if (this.getNetworkRecoveryInterval() != null) {
                factory.setNetworkRecoveryInterval(this.getNetworkRecoveryInterval().intValue());
            }
            if (this.getTopologyRecoveryEnabled() != null) {
                factory.setTopologyRecoveryEnabled(this.getTopologyRecoveryEnabled().booleanValue());
            }
            this.connectionFactory = factory;
        }
        return this.connectionFactory;
    }

    public Producer createProducer() throws Exception {
        return new RabbitMQProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    protected ExecutorService createExecutor() {
        if (this.getCamelContext() != null) {
            return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "RabbitMQConsumer", this.getThreadPoolSize());
        }
        return Executors.newFixedThreadPool(this.getThreadPoolSize());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setBridgeEndpoint(boolean bridgeEndpoint) {
        this.bridgeEndpoint = bridgeEndpoint;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setAddresses(String addresses) {
        Address[] addressArray = Address.parseAddresses((String)addresses);
        if (addressArray.length > 0) {
            this.addresses = addressArray;
        }
    }

    public Address[] getAddresses() {
        return this.addresses;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    public int getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public void setRequestedFrameMax(int requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public void setRequestedHeartbeat(int requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public Map<String, Object> getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public Boolean getAutomaticRecoveryEnabled() {
        return this.automaticRecoveryEnabled;
    }

    public void setAutomaticRecoveryEnabled(Boolean automaticRecoveryEnabled) {
        this.automaticRecoveryEnabled = automaticRecoveryEnabled;
    }

    public Integer getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public void setNetworkRecoveryInterval(Integer networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
    }

    public Boolean getTopologyRecoveryEnabled() {
        return this.topologyRecoveryEnabled;
    }

    public void setTopologyRecoveryEnabled(Boolean topologyRecoveryEnabled) {
        this.topologyRecoveryEnabled = topologyRecoveryEnabled;
    }

    public boolean isPrefetchEnabled() {
        return this.prefetchEnabled;
    }

    public void setPrefetchEnabled(boolean prefetchEnabled) {
        this.prefetchEnabled = prefetchEnabled;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchGlobal(boolean prefetchGlobal) {
        this.prefetchGlobal = prefetchGlobal;
    }

    public boolean isPrefetchGlobal() {
        return this.prefetchGlobal;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public boolean isDeclare() {
        return this.declare;
    }

    public void setDeclare(boolean declare) {
        this.declare = declare;
    }

    public String getDeadLetterExchange() {
        return this.deadLetterExchange;
    }

    public void setDeadLetterExchange(String deadLetterExchange) {
        this.deadLetterExchange = deadLetterExchange;
    }

    public String getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public void setDeadLetterQueue(String deadLetterQueue) {
        this.deadLetterQueue = deadLetterQueue;
    }

    public String getDeadLetterRoutingKey() {
        return this.deadLetterRoutingKey;
    }

    public void setDeadLetterRoutingKey(String deadLetterRoutingKey) {
        this.deadLetterRoutingKey = deadLetterRoutingKey;
    }

    public String getDeadLetterExchangeType() {
        return this.deadLetterExchangeType;
    }

    public void setDeadLetterExchangeType(String deadLetterExchangeType) {
        this.deadLetterExchangeType = deadLetterExchangeType;
    }

    public int getChannelPoolMaxSize() {
        return this.channelPoolMaxSize;
    }

    public void setChannelPoolMaxSize(int channelPoolMaxSize) {
        this.channelPoolMaxSize = channelPoolMaxSize;
    }

    public long getChannelPoolMaxWait() {
        return this.channelPoolMaxWait;
    }

    public void setChannelPoolMaxWait(long channelPoolMaxWait) {
        this.channelPoolMaxWait = channelPoolMaxWait;
    }
}

