/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MethodBasedRouter
extends Restlet {
    private static final Logger LOG = LoggerFactory.getLogger(MethodBasedRouter.class);
    private String uriPattern;
    private Map<Method, Restlet> routes = new ConcurrentHashMap<Method, Restlet>();
    private AtomicBoolean hasBeenAttachedFlag = new AtomicBoolean(false);

    MethodBasedRouter(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public void handle(Request request, Response response) {
        Method method = request.getMethod();
        LOG.debug("MethodRouter ({}) received request method: {}", (Object)this.uriPattern, (Object)method);
        Restlet target = this.routes.get(method);
        if (target != null) {
            target.handle(request, response);
        } else {
            LOG.debug("MethodRouter ({}) method not allowed: {}", (Object)this.uriPattern, (Object)method);
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.setAllowedMethods(this.routes.keySet());
        }
    }

    void addRoute(Method method, Restlet target) {
        this.routes.put(method, target);
    }

    void removeRoute(Method method) {
        this.routes.remove(method);
    }

    boolean hasRoutes() {
        return !this.routes.isEmpty();
    }

    boolean hasBeenAttached() {
        return this.hasBeenAttachedFlag.getAndSet(true);
    }

    String getUriPattern() {
        return this.uriPattern;
    }
}

