/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet.converter;

import java.util.ArrayList;
import org.apache.camel.Converter;
import org.restlet.data.MediaType;
import org.restlet.data.Method;

@Converter
public final class RestletConverter {
    private RestletConverter() {
    }

    @Converter
    public static Method toMethod(String name) {
        return Method.valueOf((String)name.toUpperCase());
    }

    @Converter
    public static Method[] toMethods(String name) {
        String[] strings = name.split(",");
        ArrayList<Method> methods = new ArrayList<Method>();
        for (String string : strings) {
            methods.add(RestletConverter.toMethod(string));
        }
        return methods.toArray(new Method[methods.size()]);
    }

    @Converter
    public static MediaType toMediaType(String name) {
        return MediaType.valueOf((String)name);
    }

    @Converter
    public static MediaType[] toMediaTypes(String name) {
        String[] strings = name.split(",");
        ArrayList<MediaType> answer = new ArrayList<MediaType>(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            MediaType mediaType = RestletConverter.toMediaType(strings[i]);
            if (mediaType == null) continue;
            answer.add(mediaType);
        }
        return answer.toArray(new MediaType[answer.size()]);
    }
}

