/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.bulk.BatchInfo;
import org.apache.camel.component.salesforce.api.dto.bulk.BatchInfoList;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.api.dto.bulk.Error;
import org.apache.camel.component.salesforce.api.dto.bulk.JobInfo;
import org.apache.camel.component.salesforce.api.dto.bulk.JobStateEnum;
import org.apache.camel.component.salesforce.api.dto.bulk.ObjectFactory;
import org.apache.camel.component.salesforce.api.dto.bulk.QueryResultList;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.BulkApiClient;
import org.apache.camel.component.salesforce.internal.client.SalesforceExchange;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.StringUtil;

public class DefaultBulkApiClient
extends AbstractClientBase
implements BulkApiClient {
    private static final String TOKEN_HEADER = "X-SFDC-Session";
    private static final ContentType DEFAULT_ACCEPT_TYPE = ContentType.XML;
    private JAXBContext context;
    private ObjectFactory objectFactory;

    public DefaultBulkApiClient(String version, SalesforceSession session, HttpClient httpClient) throws SalesforceException {
        super(version, session, httpClient);
        try {
            this.context = JAXBContext.newInstance((String)JobInfo.class.getPackage().getName(), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (JAXBException e) {
            String msg = "Error loading Bulk API DTOs: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
        this.objectFactory = new ObjectFactory();
    }

    @Override
    public void createJob(JobInfo request, final BulkApiClient.JobInfoResponseCallback callback) {
        this.sanitizeJobRequest(request);
        final SalesforceExchange post = this.getContentExchange("POST", this.jobUrl(null));
        try {
            this.marshalRequest(this.objectFactory.createJobInfo(request), post, "application/xml;charset=utf-8");
        }
        catch (SalesforceException e) {
            callback.onResponse(null, e);
            return;
        }
        this.doHttpRequest(post, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                JobInfo value = null;
                if (response != null) {
                    try {
                        value = (JobInfo)DefaultBulkApiClient.this.unmarshalResponse(response, post, JobInfo.class);
                    }
                    catch (SalesforceException e) {
                        ex = e;
                    }
                }
                callback.onResponse(value, ex);
            }
        });
    }

    private void sanitizeJobRequest(JobInfo request) {
        request.setApexProcessingTime(null);
        request.setApiActiveProcessingTime(null);
        request.setApiVersion(null);
        request.setCreatedById(null);
        request.setCreatedDate(null);
        request.setId(null);
        request.setNumberBatchesCompleted(null);
        request.setNumberBatchesFailed(null);
        request.setNumberBatchesInProgress(null);
        request.setNumberBatchesQueued(null);
        request.setNumberBatchesTotal(null);
        request.setNumberRecordsFailed(null);
        request.setNumberRecordsProcessed(null);
        request.setNumberRetries(null);
        request.setState(null);
        request.setSystemModstamp(null);
        request.setSystemModstamp(null);
    }

    @Override
    public void getJob(String jobId, final BulkApiClient.JobInfoResponseCallback callback) {
        final SalesforceExchange get = this.getContentExchange("GET", this.jobUrl(jobId));
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                JobInfo value = null;
                try {
                    value = (JobInfo)DefaultBulkApiClient.this.unmarshalResponse(response, get, JobInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, ex);
            }
        });
    }

    @Override
    public void closeJob(String jobId, final BulkApiClient.JobInfoResponseCallback callback) {
        JobInfo request = new JobInfo();
        request.setState(JobStateEnum.CLOSED);
        final SalesforceExchange post = this.getContentExchange("POST", this.jobUrl(jobId));
        try {
            this.marshalRequest(this.objectFactory.createJobInfo(request), post, "application/xml;charset=utf-8");
        }
        catch (SalesforceException e) {
            callback.onResponse(null, e);
            return;
        }
        this.doHttpRequest(post, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                JobInfo value = null;
                try {
                    value = (JobInfo)DefaultBulkApiClient.this.unmarshalResponse(response, post, JobInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, ex);
            }
        });
    }

    @Override
    public void abortJob(String jobId, final BulkApiClient.JobInfoResponseCallback callback) {
        JobInfo request = new JobInfo();
        request.setState(JobStateEnum.ABORTED);
        final SalesforceExchange post = this.getContentExchange("POST", this.jobUrl(jobId));
        try {
            this.marshalRequest(this.objectFactory.createJobInfo(request), post, "application/xml;charset=utf-8");
        }
        catch (SalesforceException e) {
            callback.onResponse(null, e);
            return;
        }
        this.doHttpRequest(post, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                JobInfo value = null;
                try {
                    value = (JobInfo)DefaultBulkApiClient.this.unmarshalResponse(response, post, JobInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, ex);
            }
        });
    }

    @Override
    public void createBatch(InputStream batchStream, String jobId, ContentType contentTypeEnum, final BulkApiClient.BatchInfoResponseCallback callback) {
        final SalesforceExchange post = this.getContentExchange("POST", this.batchUrl(jobId, null));
        post.setRequestContentSource(batchStream);
        post.setRequestContentType(DefaultBulkApiClient.getContentType(contentTypeEnum) + ";charset=" + "UTF-8");
        this.doHttpRequest(post, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                BatchInfo value = null;
                try {
                    value = (BatchInfo)DefaultBulkApiClient.this.unmarshalResponse(response, post, BatchInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, ex);
            }
        });
    }

    @Override
    public void getBatch(String jobId, String batchId, final BulkApiClient.BatchInfoResponseCallback callback) {
        final SalesforceExchange get = this.getContentExchange("GET", this.batchUrl(jobId, batchId));
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                BatchInfo value = null;
                try {
                    value = (BatchInfo)DefaultBulkApiClient.this.unmarshalResponse(response, get, BatchInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, ex);
            }
        });
    }

    @Override
    public void getAllBatches(String jobId, final BulkApiClient.BatchInfoListResponseCallback callback) {
        final SalesforceExchange get = this.getContentExchange("GET", this.batchUrl(jobId, null));
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                BatchInfoList value = null;
                try {
                    value = (BatchInfoList)DefaultBulkApiClient.this.unmarshalResponse(response, get, BatchInfoList.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value != null ? value.getBatchInfo() : null, ex);
            }
        });
    }

    @Override
    public void getRequest(String jobId, String batchId, final BulkApiClient.StreamResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.batchUrl(jobId, batchId));
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                callback.onResponse(response, ex);
            }
        });
    }

    @Override
    public void getResults(String jobId, String batchId, final BulkApiClient.StreamResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.batchResultUrl(jobId, batchId, null));
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                callback.onResponse(response, ex);
            }
        });
    }

    @Override
    public void createBatchQuery(String jobId, String soqlQuery, ContentType jobContentType, final BulkApiClient.BatchInfoResponseCallback callback) {
        final SalesforceExchange post = this.getContentExchange("POST", this.batchUrl(jobId, null));
        byte[] queryBytes = soqlQuery.getBytes(StringUtil.__UTF8_CHARSET);
        post.setRequestContent((Buffer)new ByteArrayBuffer(queryBytes));
        post.setRequestContentType(DefaultBulkApiClient.getContentType(jobContentType) + ";charset=" + "UTF-8");
        this.doHttpRequest(post, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                BatchInfo value = null;
                try {
                    value = (BatchInfo)DefaultBulkApiClient.this.unmarshalResponse(response, post, BatchInfo.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value, ex);
            }
        });
    }

    @Override
    public void getQueryResultIds(String jobId, String batchId, final BulkApiClient.QueryResultIdsCallback callback) {
        final SalesforceExchange get = this.getContentExchange("GET", this.batchResultUrl(jobId, batchId, null));
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                QueryResultList value = null;
                try {
                    value = (QueryResultList)DefaultBulkApiClient.this.unmarshalResponse(response, get, QueryResultList.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(value != null ? Collections.unmodifiableList(value.getResult()) : null, ex);
            }
        });
    }

    @Override
    public void getQueryResult(String jobId, String batchId, String resultId, final BulkApiClient.StreamResponseCallback callback) {
        SalesforceExchange get = this.getContentExchange("GET", this.batchResultUrl(jobId, batchId, resultId));
        this.doHttpRequest(get, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                callback.onResponse(response, ex);
            }
        });
    }

    @Override
    protected void setAccessToken(HttpExchange httpExchange) {
        httpExchange.setRequestHeader(TOKEN_HEADER, this.accessToken);
    }

    @Override
    protected void doHttpRequest(ContentExchange request, AbstractClientBase.ClientResponseCallback callback) {
        this.setAccessToken((HttpExchange)request);
        request.setRequestHeader("Accept-Charset", "UTF-8");
        if (!request.getRequestFields().containsKey("Accept")) {
            String contentType = DefaultBulkApiClient.getContentType(DEFAULT_ACCEPT_TYPE);
            request.setRequestHeader("Accept", contentType);
        }
        super.doHttpRequest(request, callback);
    }

    private static String getContentType(ContentType type) {
        String result = null;
        switch (type) {
            case CSV: {
                result = "text/csv";
                break;
            }
            case XML: {
                result = "application/xml";
                break;
            }
            case ZIP_CSV: 
            case ZIP_XML: {
                result = type.toString().toLowerCase().replace('_', '/');
                break;
            }
        }
        return result;
    }

    @Override
    protected SalesforceException createRestException(ContentExchange request) {
        try {
            Error error = this.unmarshalResponse(new ByteArrayInputStream(request.getResponseContentBytes()), request, Error.class);
            RestError restError = new RestError();
            restError.setErrorCode(error.getExceptionCode());
            restError.setMessage(error.getExceptionMessage());
            return new SalesforceException(Arrays.asList(restError), request.getResponseStatus());
        }
        catch (SalesforceException e) {
            String msg = "Error un-marshaling Salesforce Error: " + e.getMessage();
            return new SalesforceException(msg, (Throwable)((Object)e));
        }
    }

    private <T> T unmarshalResponse(InputStream response, ContentExchange request, Class<T> resultClass) throws SalesforceException {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            JAXBElement result = unmarshaller.unmarshal((Source)new StreamSource(response), resultClass);
            return (T)result.getValue();
        }
        catch (JAXBException e) {
            throw new SalesforceException(String.format("Error unmarshaling response {%s:%s} : %s", request.getMethod(), request.getRequestURI(), e.getMessage()), e);
        }
        catch (IllegalArgumentException e) {
            throw new SalesforceException(String.format("Error unmarshaling response for {%s:%s} : %s", request.getMethod(), request.getRequestURI(), e.getMessage()), e);
        }
    }

    private void marshalRequest(Object input, ContentExchange request, String contentType) throws SalesforceException {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            marshaller.marshal(input, (OutputStream)byteStream);
            request.setRequestContent((Buffer)new ByteArrayBuffer(byteStream.toByteArray()));
            request.setRequestContentType(contentType);
        }
        catch (JAXBException e) {
            throw new SalesforceException(String.format("Error marshaling request for {%s:%s} : %s", request.getMethod(), request.getRequestURI(), e.getMessage()), e);
        }
        catch (IllegalArgumentException e) {
            throw new SalesforceException(String.format("Error marshaling request for {%s:%s} : %s", request.getMethod(), request.getRequestURI(), e.getMessage()), e);
        }
    }

    private String jobUrl(String jobId) {
        if (jobId != null) {
            return this.instanceUrl + "/services/async/" + this.version + "/job/" + jobId;
        }
        return this.instanceUrl + "/services/async/" + this.version + "/job";
    }

    private String batchUrl(String jobId, String batchId) {
        if (batchId != null) {
            return this.jobUrl(jobId) + "/batch/" + batchId;
        }
        return this.jobUrl(jobId) + "/batch";
    }

    private String batchResultUrl(String jobId, String batchId, String resultId) {
        if (resultId != null) {
            return this.batchUrl(jobId, batchId) + "/result/" + resultId;
        }
        return this.batchUrl(jobId, batchId) + "/result";
    }
}

