/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.streaming;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelException;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.CreateSObjectResult;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.client.SyncResponseCallback;
import org.apache.camel.component.salesforce.internal.dto.PushTopic;
import org.apache.camel.component.salesforce.internal.dto.QueryRecordsPushTopic;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushTopicHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PushTopicHelper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String PUSH_TOPIC_OBJECT_NAME = "PushTopic";
    private static final long API_TIMEOUT = 60L;
    private final SalesforceEndpointConfig config;
    private final String topicName;
    private final RestClient restClient;

    public PushTopicHelper(SalesforceEndpointConfig config, String topicName, RestClient restClient) {
        this.config = config;
        this.topicName = topicName;
        this.restClient = restClient;
    }

    public void createOrUpdateTopic() throws CamelException {
        String query = this.config.getSObjectQuery();
        SyncResponseCallback callback = new SyncResponseCallback();
        try {
            this.restClient.query("SELECT Id, Name, Query, ApiVersion, IsActive, NotifyForFields, NotifyForOperations, Description FROM PushTopic WHERE Name = '" + this.topicName + "'", callback);
            if (!callback.await(60L, TimeUnit.SECONDS)) {
                throw new SalesforceException("API call timeout!", null);
            }
            if (callback.getException() != null) {
                throw callback.getException();
            }
            QueryRecordsPushTopic records = (QueryRecordsPushTopic)OBJECT_MAPPER.readValue(callback.getResponse(), QueryRecordsPushTopic.class);
            if (records.getTotalSize() == 1) {
                PushTopic topic = records.getRecords().get(0);
                LOG.info("Found existing topic {}: {}", (Object)this.topicName, (Object)topic);
                if (!query.equals(topic.getQuery()) || this.config.getNotifyForFields() != null && !this.config.getNotifyForFields().equals((Object)topic.getNotifyForFields()) || this.config.getNotifyForOperations() != null && !this.config.getNotifyForOperations().equals((Object)topic.getNotifyForOperations())) {
                    if (!this.config.isUpdateTopic()) {
                        String msg = "Query doesn't match existing Topic and updateTopic is set to false";
                        throw new CamelException(msg);
                    }
                    this.updateTopic(topic.getId());
                }
            } else {
                this.createTopic();
            }
        }
        catch (SalesforceException e) {
            throw new CamelException(String.format("Error retrieving Topic %s: %s", this.topicName, e.getMessage()), (Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new CamelException(String.format("Un-marshaling error retrieving Topic %s: %s", this.topicName, e.getMessage()), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CamelException(String.format("Un-marshaling error retrieving Topic %s: %s", this.topicName, e.getMessage()), (Throwable)e);
        }
        finally {
            if (callback.getResponse() != null) {
                try {
                    callback.getResponse().close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void createTopic() throws CamelException {
        PushTopic topic = new PushTopic();
        topic.setName(this.topicName);
        topic.setApiVersion(Double.valueOf(this.config.getApiVersion()));
        topic.setQuery(this.config.getSObjectQuery());
        topic.setDescription("Topic created by Camel Salesforce component");
        topic.setNotifyForFields(this.config.getNotifyForFields());
        topic.setNotifyForOperations(this.config.getNotifyForOperations());
        LOG.info("Creating Topic {}: {}", (Object)this.topicName, (Object)topic);
        SyncResponseCallback callback = new SyncResponseCallback();
        try {
            this.restClient.createSObject(PUSH_TOPIC_OBJECT_NAME, new ByteArrayInputStream(OBJECT_MAPPER.writeValueAsBytes((Object)topic)), callback);
            if (!callback.await(60L, TimeUnit.SECONDS)) {
                throw new SalesforceException("API call timeout!", null);
            }
            if (callback.getException() != null) {
                throw callback.getException();
            }
            CreateSObjectResult result = (CreateSObjectResult)OBJECT_MAPPER.readValue(callback.getResponse(), CreateSObjectResult.class);
            if (!result.getSuccess().booleanValue()) {
                SalesforceException salesforceException = new SalesforceException(result.getErrors(), 400);
                throw new CamelException(String.format("Error creating Topic %s: %s", this.topicName, result.getErrors()), (Throwable)((Object)salesforceException));
            }
        }
        catch (SalesforceException e) {
            throw new CamelException(String.format("Error creating Topic %s: %s", this.topicName, e.getMessage()), (Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new CamelException(String.format("Un-marshaling error creating Topic %s: %s", this.topicName, e.getMessage()), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new CamelException(String.format("Un-marshaling error creating Topic %s: %s", this.topicName, e.getMessage()), (Throwable)e);
        }
        finally {
            if (callback.getResponse() != null) {
                try {
                    callback.getResponse().close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void updateTopic(String topicId) throws CamelException {
        String query = this.config.getSObjectQuery();
        LOG.info("Updating Topic {} with Query [{}]", (Object)this.topicName, (Object)query);
        SyncResponseCallback callback = new SyncResponseCallback();
        try {
            PushTopic topic = new PushTopic();
            topic.setQuery(query);
            topic.setNotifyForFields(this.config.getNotifyForFields());
            topic.setNotifyForOperations(this.config.getNotifyForOperations());
            this.restClient.updateSObject(PUSH_TOPIC_OBJECT_NAME, topicId, new ByteArrayInputStream(OBJECT_MAPPER.writeValueAsBytes((Object)topic)), callback);
            if (!callback.await(60L, TimeUnit.SECONDS)) {
                throw new SalesforceException("API call timeout!", null);
            }
            if (callback.getException() != null) {
                throw callback.getException();
            }
        }
        catch (SalesforceException e) {
            throw new CamelException(String.format("Error updating topic %s with query [%s] : %s", this.topicName, query, e.getMessage()), (Throwable)((Object)e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CamelException(String.format("Error updating topic %s with query [%s] : %s", this.topicName, query, e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new CamelException(String.format("Error updating topic %s with query [%s] : %s", this.topicName, query, e.getMessage()), (Throwable)e);
        }
        finally {
            if (callback.getResponse() != null) {
                try {
                    callback.getResponse().close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

