/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

public class StringMultiSelectPicklistSerializer
extends StdSerializer<Object> {
    private static final long serialVersionUID = 1406195556960561677L;

    protected StringMultiSelectPicklistSerializer(Class<Object> t) {
        super(t);
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        try {
            String[] a = (String[])value;
            int length = a.length;
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                buffer.append(a[i].trim());
                if (i >= length - 1) continue;
                buffer.append(';');
            }
            jgen.writeString(buffer.toString());
        }
        catch (Exception e) {
            throw new JsonGenerationException(String.format("Exception writing pick list value %s of type %s: %s", value, value.getClass().getName(), e.getMessage()), jgen);
        }
    }
}

