/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.servlet.DefaultHttpRegistry;
import org.apache.camel.component.servlet.HttpRegistry;
import org.apache.camel.component.servlet.ServletConsumer;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;

public class ServletComponent
extends HttpComponent {
    private String servletName = "CamelServlet";
    private HttpRegistry httpRegistry;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HttpClientParams params = new HttpClientParams();
        IntrospectionSupport.setProperties((Object)params, parameters, (String)"httpClient.");
        LinkedHashSet authMethods = new LinkedHashSet();
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters, authMethods);
        Boolean throwExceptionOnFailure = (Boolean)this.getAndRemoveParameter(parameters, "throwExceptionOnFailure", Boolean.class);
        Boolean transferException = (Boolean)this.getAndRemoveParameter(parameters, "transferException", Boolean.class);
        Boolean bridgeEndpoint = (Boolean)this.getAndRemoveParameter(parameters, "bridgeEndpoint", Boolean.class);
        HttpBinding binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        Boolean matchOnUriPrefix = (Boolean)this.getAndRemoveParameter(parameters, "matchOnUriPrefix", Boolean.class);
        String servletName = (String)this.getAndRemoveParameter(parameters, "servletName", String.class, this.getServletName());
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(UnsafeUriCharactersEncoder.encode((String)uri)), parameters);
        ServletEndpoint endpoint = this.createServletEndpoint(uri, this, httpUri, params, this.getHttpConnectionManager(), configurer);
        endpoint.setServletName(servletName);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setBinding(binding);
        }
        if (throwExceptionOnFailure != null) {
            endpoint.setThrowExceptionOnFailure(throwExceptionOnFailure);
        }
        if (transferException != null) {
            endpoint.setTransferException(transferException);
        }
        if (bridgeEndpoint != null) {
            endpoint.setBridgeEndpoint(bridgeEndpoint);
        }
        if (matchOnUriPrefix != null) {
            endpoint.setMatchOnUriPrefix(matchOnUriPrefix);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected ServletEndpoint createServletEndpoint(String endpointUri, ServletComponent component, URI httpUri, HttpClientParams params, HttpConnectionManager httpConnectionManager, HttpClientConfigurer clientConfigurer) throws Exception {
        return new ServletEndpoint(endpointUri, component, httpUri, params, httpConnectionManager, clientConfigurer);
    }

    public void connect(HttpConsumer consumer) throws Exception {
        ServletConsumer sc = (ServletConsumer)consumer;
        String name = sc.getEndpoint().getServletName();
        HttpRegistry registry = this.httpRegistry;
        if (registry == null) {
            registry = DefaultHttpRegistry.getHttpRegistry(name);
        }
        registry.register(consumer);
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
        ServletConsumer sc = (ServletConsumer)consumer;
        String name = sc.getEndpoint().getServletName();
        HttpRegistry registry = this.httpRegistry;
        if (registry == null) {
            registry = DefaultHttpRegistry.getHttpRegistry(name);
        }
        registry.unregister(consumer);
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public HttpRegistry getHttpRegistry() {
        return this.httpRegistry;
    }

    public void setHttpRegistry(HttpRegistry httpRegistry) {
        this.httpRegistry = httpRegistry;
    }
}

