/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import javax.servlet.http.HttpServletRequest;
import org.apache.camel.component.http.DefaultHttpBinding;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.component.servlet.ServletEndpoint;

public class ServletRestHttpBinding
extends DefaultHttpBinding {
    protected void populateRequestParameters(HttpServletRequest request, HttpMessage message) throws Exception {
        super.populateRequestParameters(request, message);
        String path = request.getPathInfo();
        if (path == null) {
            return;
        }
        ServletEndpoint endpoint = (ServletEndpoint)message.getExchange().getFromEndpoint();
        String consumerPath = endpoint.getPath();
        if (this.useRestMatching(consumerPath)) {
            String[] paths = path.split("/");
            String[] consumerPaths = consumerPath.split("/");
            for (int i = 0; i < consumerPaths.length && paths.length >= i; ++i) {
                String p1 = consumerPaths[i];
                if (!p1.startsWith("{") || !p1.endsWith("}")) continue;
                String key = p1.substring(1, p1.length() - 1);
                String value = paths[i];
                if (value == null) continue;
                message.setHeader(key, (Object)value);
            }
        }
    }

    private boolean useRestMatching(String path) {
        return path.indexOf(123) > -1;
    }
}

