/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.camel.component.http.CamelServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CamelHttpTransportServlet
extends CamelServlet {
    private static final transient Log LOG = LogFactory.getLog(CamelHttpTransportServlet.class);
    private static final Map<String, CamelServlet> CAMEL_SERVLET_MAP = new ConcurrentHashMap<String, CamelServlet>();
    private String servletName;
    private AbstractApplicationContext applicationContext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletName = config.getServletName();
        CAMEL_SERVLET_MAP.put(this.servletName, this);
        String contextConfigLocation = config.getInitParameter("contextConfigLocation");
        if (contextConfigLocation != null) {
            this.applicationContext = new ClassPathXmlApplicationContext(contextConfigLocation.split(","));
            LOG.info((Object)"Started the application context rightly");
        }
    }

    public void destroy() {
        CAMEL_SERVLET_MAP.remove(this.servletName);
        if (this.applicationContext != null) {
            this.applicationContext.stop();
        }
    }

    public static CamelServlet getCamelServlet(String servletName) {
        CamelServlet answer = null;
        if (servletName != null) {
            answer = CAMEL_SERVLET_MAP.get(servletName);
        } else if (CAMEL_SERVLET_MAP.size() > 0) {
            Iterator<CamelServlet> iterator = CAMEL_SERVLET_MAP.values().iterator();
            answer = iterator.next();
            LOG.info((Object)("Since no servlet name is specified, using the first element of camelServlet map [" + answer.getServletName() + "]"));
        }
        return answer;
    }
}

