/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap.name;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.xml.namespace.QName;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;
import org.apache.camel.dataformat.soap.name.MethodInfo;
import org.apache.camel.dataformat.soap.name.TypeInfo;
import org.apache.camel.dataformat.soap.name.TypeNameStrategy;

public class ServiceInterfaceStrategy
implements ElementNameStrategy {
    private Map<String, MethodInfo> soapActionToMethodInfo = new HashMap<String, MethodInfo>();
    private Map<String, QName> inTypeNameToQName = new HashMap<String, QName>();
    private Map<String, QName> outTypeNameToQName = new HashMap<String, QName>();
    private boolean isClient;
    private ElementNameStrategy fallBackStrategy;
    private Map<QName, Class<? extends Exception>> faultNameToException = new HashMap<QName, Class<? extends Exception>>();

    public ServiceInterfaceStrategy(Class<?> serviceInterface, boolean isClient) {
        this.analyzeServiceInterface(serviceInterface);
        this.isClient = isClient;
        this.fallBackStrategy = new TypeNameStrategy();
    }

    public String getMethodForSoapAction(String soapAction) {
        MethodInfo methodInfo = this.soapActionToMethodInfo.get(soapAction);
        return methodInfo == null ? null : methodInfo.getName();
    }

    private TypeInfo getOutInfo(Method method) {
        ResponseWrapper respWrap = method.getAnnotation(ResponseWrapper.class);
        if (respWrap != null && respWrap.className() != null) {
            return new TypeInfo(respWrap.className(), new QName(respWrap.targetNamespace(), respWrap.localName()));
        }
        Class<?> returnType = method.getReturnType();
        if (Void.TYPE.equals(returnType)) {
            return new TypeInfo(null, null);
        }
        Class<?> type = method.getReturnType();
        WebResult webResult = method.getAnnotation(WebResult.class);
        if (webResult != null) {
            return new TypeInfo(type.getName(), new QName(webResult.targetNamespace(), webResult.name()));
        }
        throw new IllegalArgumentException("Result type of method " + method.getName() + " is not annotated with WebParam. This is not yet supported");
    }

    private TypeInfo getInInfo(Method method) {
        RequestWrapper requestWrapper = method.getAnnotation(RequestWrapper.class);
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 0) {
            return new TypeInfo(null, null);
        }
        if (requestWrapper != null && requestWrapper.className() != null) {
            return new TypeInfo(requestWrapper.className(), new QName(requestWrapper.targetNamespace(), requestWrapper.localName()));
        }
        if (types.length == 1) {
            Annotation[] firstParamAnnotations;
            for (Annotation annotation : firstParamAnnotations = method.getParameterAnnotations()[0]) {
                if (!(annotation instanceof WebParam)) continue;
                WebParam webParam = (WebParam)annotation;
                return new TypeInfo(types[0].getName(), new QName(webParam.targetNamespace(), webParam.name()));
            }
            throw new IllegalArgumentException("Parameter of method " + method.getName() + " is not annotated with WebParam. This is not yet supported");
        }
        throw new IllegalArgumentException("Method " + method.getName() + " has more than one parameter and no request wrapper. This is not yet supported");
    }

    private MethodInfo analyzeMethod(Method method) {
        TypeInfo inInfo = this.getInInfo(method);
        TypeInfo outInfo = this.getOutInfo(method);
        WebMethod webMethod = method.getAnnotation(WebMethod.class);
        String soapAction = webMethod != null ? webMethod.action() : null;
        return new MethodInfo(method.getName(), soapAction, inInfo, outInfo);
    }

    private void analyzeServiceInterface(Class<?> serviceInterface) {
        Method[] methods;
        for (Method method : methods = serviceInterface.getMethods()) {
            MethodInfo info = this.analyzeMethod(method);
            if (info.getIn() != null) {
                this.inTypeNameToQName.put(info.getIn().getTypeName(), info.getIn().getElName());
            }
            if (info.getSoapAction() != null && !"".equals(info.getSoapAction())) {
                this.soapActionToMethodInfo.put(info.getSoapAction(), info);
            }
            this.outTypeNameToQName.put(info.getOut().getTypeName(), info.getOut().getElName());
            this.addExceptions(method);
        }
    }

    private void addExceptions(Method method) {
        Class<?>[] exTypes;
        for (Class<?> exType : exTypes = method.getExceptionTypes()) {
            WebFault webFault = exType.getAnnotation(WebFault.class);
            if (webFault == null) continue;
            QName faultName = new QName(webFault.targetNamespace(), webFault.name());
            this.faultNameToException.put(faultName, exType);
        }
    }

    @Override
    public QName findQNameForSoapActionOrType(String soapAction, Class<?> type) {
        MethodInfo info = this.soapActionToMethodInfo.get(soapAction);
        if (info != null) {
            if (this.isClient) {
                return info.getIn().getElName();
            }
            return info.getOut().getElName();
        }
        QName qName = null;
        if (type != null) {
            qName = this.isClient ? this.inTypeNameToQName.get(type.getName()) : this.outTypeNameToQName.get(type.getName());
        }
        if (qName == null) {
            try {
                qName = this.fallBackStrategy.findQNameForSoapActionOrType(soapAction, type);
            }
            catch (Exception e) {
                String msg = "No method found that matches the given SoapAction " + soapAction + " or that has an " + (this.isClient ? "input" : "output") + " of type " + type.getName();
                throw new RuntimeCamelException(msg, (Throwable)e);
            }
        }
        return qName;
    }

    @Override
    public Class<? extends Exception> findExceptionForFaultName(QName faultName) {
        return this.faultNameToException.get(faultName);
    }
}

