/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch.support;

import org.apache.camel.ProducerTemplate;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;

public class CamelJobExecutionListener
implements JobExecutionListener {
    private final ProducerTemplate producerTemplate;
    private final String endpointUri;

    public CamelJobExecutionListener(ProducerTemplate producerTemplate, String endpointUri) {
        this.producerTemplate = producerTemplate;
        this.endpointUri = endpointUri;
    }

    public void beforeJob(JobExecution jobExecution) {
        this.producerTemplate.sendBodyAndHeader(this.endpointUri, (Object)jobExecution, "SPRING_BATCH_JOB_EVENT_TYPE", (Object)EventType.BEFORE.name());
    }

    public void afterJob(JobExecution jobExecution) {
        this.producerTemplate.sendBodyAndHeader(this.endpointUri, (Object)jobExecution, "SPRING_BATCH_JOB_EVENT_TYPE", (Object)EventType.AFTER.name());
    }

    public static enum EventType {
        BEFORE,
        AFTER;

        public static final String HEADER_KEY = "SPRING_BATCH_JOB_EVENT_TYPE";
    }
}

