/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import org.apache.camel.CamelContext;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class CamelHealthIndicator
extends AbstractHealthIndicator {
    private CamelContext camelContext;

    public CamelHealthIndicator(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.camelContext == null) {
            builder.unknown();
        } else {
            builder.withDetail("name", (Object)this.camelContext.getName());
            builder.withDetail("version", (Object)this.camelContext.getVersion());
            builder.withDetail("contextStatus", (Object)this.camelContext.getStatus().name());
            if (this.camelContext.getStatus().isStarted()) {
                builder.up();
            } else if (this.camelContext.getStatus().isStopped()) {
                builder.down();
            } else {
                builder.unknown();
            }
        }
    }
}

