/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.health;

import org.apache.camel.converter.TimePatternConverter;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.health.RoutePerformanceCounterEvaluators;
import org.apache.camel.impl.health.RoutesHealthCheckRepository;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.health.HealthCheckRoutesConfiguration;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.util.ObjectHelper;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={Condition.class})
@EnableConfigurationProperties(value={HealthCheckRoutesConfiguration.class})
public class HealthCheckRoutesAutoConfiguration {
    @Bean
    @Scope(value="singleton")
    @ConditionalOnMissingBean(value={RoutesHealthCheckRepository.class})
    public HealthCheckRepository routesHealthCheckRepository(HealthCheckRoutesConfiguration configuration) {
        Integer failures;
        String time;
        RoutesHealthCheckRepository repository = new RoutesHealthCheckRepository();
        HealthCheckRoutesConfiguration.ThresholdsConfiguration thresholds = configuration.getThresholds();
        if (thresholds.getExchangesFailed() != null) {
            repository.addEvaluator(RoutePerformanceCounterEvaluators.exchangesFailed((long)thresholds.getExchangesFailed()));
        }
        if (thresholds.getExchangesInflight() != null) {
            repository.addEvaluator(RoutePerformanceCounterEvaluators.exchangesInflight((long)thresholds.getExchangesInflight()));
        }
        if (thresholds.getRedeliveries() != null) {
            repository.addEvaluator(RoutePerformanceCounterEvaluators.redeliveries((long)thresholds.getRedeliveries()));
        }
        if (thresholds.getExternalRedeliveries() != null) {
            repository.addEvaluator(RoutePerformanceCounterEvaluators.redeliveries((long)thresholds.getExternalRedeliveries()));
        }
        if (thresholds.getLastProcessingTime() != null) {
            time = thresholds.getLastProcessingTime().getThreshold();
            failures = thresholds.getLastProcessingTime().getFailures();
            if (ObjectHelper.isNotEmpty((Object)time) && ObjectHelper.isNotEmpty((Object)failures)) {
                repository.addEvaluator(RoutePerformanceCounterEvaluators.lastProcessingTime((long)TimePatternConverter.toMilliSeconds((String)time), (int)failures));
            }
        }
        if (thresholds.getMinProcessingTime() != null) {
            time = thresholds.getMinProcessingTime().getThreshold();
            failures = thresholds.getMinProcessingTime().getFailures();
            if (ObjectHelper.isNotEmpty((Object)time) && ObjectHelper.isNotEmpty((Object)failures)) {
                repository.addEvaluator(RoutePerformanceCounterEvaluators.minProcessingTime((long)TimePatternConverter.toMilliSeconds((String)time), (int)failures));
            }
        }
        if (thresholds.getMeanProcessingTime() != null) {
            time = thresholds.getMeanProcessingTime().getThreshold();
            failures = thresholds.getMeanProcessingTime().getFailures();
            if (ObjectHelper.isNotEmpty((Object)time) && ObjectHelper.isNotEmpty((Object)failures)) {
                repository.addEvaluator(RoutePerformanceCounterEvaluators.meanProcessingTime((long)TimePatternConverter.toMilliSeconds((String)time), (int)failures));
            }
        }
        if (thresholds.getMaxProcessingTime() != null) {
            time = thresholds.getMaxProcessingTime().getThreshold();
            failures = thresholds.getMaxProcessingTime().getFailures();
            if (ObjectHelper.isNotEmpty((Object)time) && ObjectHelper.isNotEmpty((Object)failures)) {
                repository.addEvaluator(RoutePerformanceCounterEvaluators.maxProcessingTime((long)TimePatternConverter.toMilliSeconds((String)time), (int)failures));
            }
        }
        if (configuration.getThreshold() != null) {
            for (String key : configuration.getThreshold().keySet()) {
                Integer failures2;
                String time2;
                HealthCheckRoutesConfiguration.ThresholdsConfiguration threshold = configuration.getThreshold(key);
                if (threshold.getExchangesFailed() != null) {
                    repository.addRouteEvaluator(key, RoutePerformanceCounterEvaluators.exchangesFailed((long)threshold.getExchangesFailed()));
                }
                if (threshold.getExchangesInflight() != null) {
                    repository.addRouteEvaluator(key, RoutePerformanceCounterEvaluators.exchangesInflight((long)threshold.getExchangesInflight()));
                }
                if (threshold.getRedeliveries() != null) {
                    repository.addRouteEvaluator(key, RoutePerformanceCounterEvaluators.redeliveries((long)threshold.getRedeliveries()));
                }
                if (threshold.getExternalRedeliveries() != null) {
                    repository.addRouteEvaluator(key, RoutePerformanceCounterEvaluators.redeliveries((long)threshold.getExternalRedeliveries()));
                }
                if (threshold.getLastProcessingTime() != null) {
                    time2 = threshold.getLastProcessingTime().getThreshold();
                    failures2 = threshold.getLastProcessingTime().getFailures();
                    if (ObjectHelper.isNotEmpty((Object)time2) && ObjectHelper.isNotEmpty((Object)failures2)) {
                        repository.addRouteEvaluator(key, RoutePerformanceCounterEvaluators.lastProcessingTime((long)TimePatternConverter.toMilliSeconds((String)time2), (int)failures2));
                    }
                }
                if (threshold.getMinProcessingTime() != null) {
                    time2 = threshold.getMinProcessingTime().getThreshold();
                    failures2 = threshold.getMinProcessingTime().getFailures();
                    if (ObjectHelper.isNotEmpty((Object)time2) && ObjectHelper.isNotEmpty((Object)failures2)) {
                        repository.addRouteEvaluator(key, RoutePerformanceCounterEvaluators.minProcessingTime((long)TimePatternConverter.toMilliSeconds((String)time2), (int)failures2));
                    }
                }
                if (threshold.getMeanProcessingTime() != null) {
                    time2 = threshold.getMeanProcessingTime().getThreshold();
                    failures2 = threshold.getMeanProcessingTime().getFailures();
                    if (ObjectHelper.isNotEmpty((Object)time2) && ObjectHelper.isNotEmpty((Object)failures2)) {
                        repository.addRouteEvaluator(key, RoutePerformanceCounterEvaluators.meanProcessingTime((long)TimePatternConverter.toMilliSeconds((String)time2), (int)failures2));
                    }
                }
                if (threshold.getMaxProcessingTime() == null) continue;
                time2 = threshold.getMaxProcessingTime().getThreshold();
                failures2 = threshold.getMaxProcessingTime().getFailures();
                if (!ObjectHelper.isNotEmpty((Object)time2) || !ObjectHelper.isNotEmpty((Object)failures2)) continue;
                repository.addRouteEvaluator(key, RoutePerformanceCounterEvaluators.maxProcessingTime((long)TimePatternConverter.toMilliSeconds((String)time2), (int)failures2));
            }
        }
        return repository;
    }

    public static class Condition
    extends GroupCondition {
        public Condition() {
            super("camel.health", "camel.health.check.routes");
        }
    }
}

