/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.transform.TransformerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.spring.ws.SpringWebserviceConfiguration;
import org.apache.camel.component.spring.ws.SpringWebserviceEndpoint;
import org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher;
import org.apache.camel.component.spring.ws.bean.CamelSpringWSEndpointMapping;
import org.apache.camel.component.spring.ws.filter.MessageFilter;
import org.apache.camel.component.spring.ws.type.EndpointMappingKey;
import org.apache.camel.component.spring.ws.type.EndpointMappingType;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;

public class SpringWebserviceComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SpringWebserviceComponent.class);

    public SpringWebserviceComponent() {
    }

    public SpringWebserviceComponent(CamelContext context) {
        super(context);
    }

    @Deprecated
    protected String preProcessUri(String uri) {
        String[] u = uri.split("\\?");
        return u[0].replaceAll("%7B", "(").replaceAll("%7D", ")") + (u.length > 1 ? "?" + u[1] : "");
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SpringWebserviceConfiguration configuration = new SpringWebserviceConfiguration();
        this.addConsumerConfiguration(remaining, parameters, configuration);
        this.addProducerConfiguration(remaining, parameters, configuration);
        this.addXmlConverterToConfiguration(parameters, configuration);
        this.configureMessageFilter(parameters, configuration);
        this.setProperties(configuration, parameters);
        return new SpringWebserviceEndpoint((Component)this, uri, configuration);
    }

    private void addConsumerConfiguration(String remaining, Map<String, Object> parameters, SpringWebserviceConfiguration configuration) {
        EndpointMappingType type = EndpointMappingType.getTypeFromUriPrefix(remaining);
        if (type != null) {
            LOG.debug("Building Spring Web Services consumer of type " + (Object)((Object)type));
            String lookupKey = this.getLookupKey(remaining, type);
            if (EndpointMappingType.BEANNAME.equals((Object)type)) {
                this.addEndpointDispatcherToConfiguration(configuration, lookupKey);
            } else {
                this.addEndpointMappingToConfiguration(parameters, configuration);
            }
            configuration.setEndpointMappingKey(new EndpointMappingKey(type, lookupKey, type.equals((Object)EndpointMappingType.XPATHRESULT) ? this.getXPathExpressionFromParameters(parameters) : null));
        }
    }

    private void addProducerConfiguration(String remaining, Map<String, Object> parameters, SpringWebserviceConfiguration configuration) throws URISyntaxException {
        if (configuration.getEndpointMapping() == null && configuration.getEndpointDispatcher() == null) {
            LOG.debug("Building Spring Web Services producer");
            URI webServiceEndpointUri = new URI(UnsafeUriCharactersEncoder.encode((String)remaining));
            WebServiceTemplate webServiceTemplate = (WebServiceTemplate)this.resolveAndRemoveReferenceParameter(parameters, "webServiceTemplate", WebServiceTemplate.class, new WebServiceTemplate());
            WebServiceMessageSender messageSender = (WebServiceMessageSender)this.resolveAndRemoveReferenceParameter(parameters, "messageSender", WebServiceMessageSender.class, null);
            WebServiceMessageFactory messageFactory = (WebServiceMessageFactory)this.resolveAndRemoveReferenceParameter(parameters, "messageFactory", WebServiceMessageFactory.class, null);
            if (webServiceTemplate.getDefaultUri() == null) {
                webServiceTemplate.setDefaultUri(webServiceEndpointUri.toString());
            }
            if (messageSender != null) {
                webServiceTemplate.setMessageSender(messageSender);
            }
            if (messageFactory != null) {
                webServiceTemplate.setMessageFactory(messageFactory);
            }
            configuration.setWebServiceTemplate(webServiceTemplate);
        }
    }

    private String getLookupKey(String remaining, EndpointMappingType type) {
        String lookupKey = remaining.substring(type.getPrefix().length());
        lookupKey = lookupKey.startsWith("//") ? lookupKey.substring(2) : lookupKey;
        return SpringWebserviceConfiguration.decode(lookupKey);
    }

    private XPathExpression getXPathExpressionFromParameters(Map<String, Object> parameters) {
        String xpathExpression = (String)this.getAndRemoveParameter(parameters, "expression", String.class);
        if (xpathExpression == null) {
            throw new RuntimeCamelException("Expression parameter is required when using XPath endpoint mapping");
        }
        XPathExpression expression = XPathExpressionFactory.createXPathExpression((String)xpathExpression);
        return expression;
    }

    private void addEndpointMappingToConfiguration(Map<String, Object> parameters, SpringWebserviceConfiguration configuration) {
        CamelSpringWSEndpointMapping endpointMapping = (CamelSpringWSEndpointMapping)this.resolveAndRemoveReferenceParameter(parameters, "endpointMapping", CamelSpringWSEndpointMapping.class, null);
        if (endpointMapping == null && configuration.getEndpointDispatcher() == null) {
            throw new IllegalArgumentException("No instance of CamelSpringWSEndpointMapping found in Spring ApplicationContext. This bean is required for Spring-WS consumer support (unless the 'spring-ws:beanname:' URI scheme is used)");
        }
        configuration.setEndpointMapping(endpointMapping);
    }

    private void addEndpointDispatcherToConfiguration(SpringWebserviceConfiguration configuration, String lookupKey) {
        CamelEndpointDispatcher endpoint = (CamelEndpointDispatcher)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)lookupKey, CamelEndpointDispatcher.class);
        configuration.setEndpointDispatcher(endpoint);
    }

    private void addXmlConverterToConfiguration(Map<String, Object> parameters, SpringWebserviceConfiguration configuration) {
        XmlConverter xmlConverter = new XmlConverter();
        TransformerFactory transformerFactory = (TransformerFactory)this.resolveAndRemoveReferenceParameter(parameters, "transformerFactory", TransformerFactory.class, null);
        if (transformerFactory != null) {
            xmlConverter.setTransformerFactory(transformerFactory);
        }
        configuration.setXmlConverter(xmlConverter);
    }

    private void configureMessageFilter(Map<String, Object> parameters, SpringWebserviceConfiguration configuration) {
        MessageFilter globalMessageFilter = (MessageFilter)EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)"messageFilter", MessageFilter.class, (boolean)false);
        MessageFilter messageFilter = (MessageFilter)this.resolveAndRemoveReferenceParameter(parameters, "messageFilter", MessageFilter.class, globalMessageFilter);
        configuration.setMessageFilter(messageFilter);
    }
}

