/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.spring.spi.TransactionErrorHandler;
import org.apache.camel.spring.spi.TransactionErrorHandlerBuilder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionPolicy
implements TransactedPolicy {
    private static final transient Logger LOG = LoggerFactory.getLogger(SpringTransactionPolicy.class);
    private TransactionTemplate template;
    private String propagationBehaviorName;
    private PlatformTransactionManager transactionManager;

    public SpringTransactionPolicy() {
    }

    public SpringTransactionPolicy(TransactionTemplate template) {
        this.template = template;
    }

    public SpringTransactionPolicy(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
    }

    public Processor wrap(RouteContext routeContext, Processor processor) {
        TransactionErrorHandler answer;
        ErrorHandlerBuilderRef builderRef;
        String ref;
        ErrorHandlerBuilder builder = (ErrorHandlerBuilder)routeContext.getRoute().getErrorHandlerBuilder();
        if (builder instanceof ErrorHandlerBuilderRef && ErrorHandlerBuilderRef.isErrorHandlerBuilderConfigured((String)(ref = (builderRef = (ErrorHandlerBuilderRef)builder).getRef()))) {
            LOG.debug("Looking up ErrorHandlerBuilder with ref: {}", (Object)ref);
            builder = (ErrorHandlerBuilder)ErrorHandlerBuilderRef.lookupErrorHandlerBuilder((RouteContext)routeContext, (String)ref);
        }
        if (builder != null && builder.supportTransacted()) {
            LOG.debug("The ErrorHandlerBuilder configured is already a TransactionErrorHandlerBuilder: {}", (Object)builder);
            answer = this.createTransactionErrorHandler(routeContext, processor, builder);
            answer.setExceptionPolicy(builder.getExceptionPolicyStrategy());
            builder.configure(routeContext, (ErrorHandler)answer);
        } else {
            if (builder != null) {
                LOG.debug("The ErrorHandlerBuilder configured is not a TransactionErrorHandlerBuilder: {}", (Object)builder);
            } else {
                LOG.debug("No ErrorHandlerBuilder configured, will use default TransactionErrorHandlerBuilder settings");
            }
            TransactionErrorHandlerBuilder txBuilder = new TransactionErrorHandlerBuilder();
            txBuilder.setTransactionTemplate(this.getTransactionTemplate());
            txBuilder.setSpringTransactionPolicy(this);
            if (builder != null) {
                txBuilder.setErrorHandlers(builder.getErrorHandlers());
            }
            answer = this.createTransactionErrorHandler(routeContext, processor, (ErrorHandlerBuilder)txBuilder);
            answer.setExceptionPolicy(txBuilder.getExceptionPolicyStrategy());
            txBuilder.configure(routeContext, (ErrorHandler)answer);
            routeContext.getRoute().setErrorHandlerBuilder((ErrorHandlerFactory)txBuilder);
        }
        return answer;
    }

    protected TransactionErrorHandler createTransactionErrorHandler(RouteContext routeContext, Processor processor, ErrorHandlerBuilder builder) {
        TransactionErrorHandler answer;
        try {
            answer = (TransactionErrorHandler)builder.createErrorHandler(routeContext, processor);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public TransactionTemplate getTransactionTemplate() {
        if (this.template == null) {
            ObjectHelper.notNull((Object)this.transactionManager, (String)"transactionManager");
            this.template = new TransactionTemplate(this.transactionManager);
            if (this.propagationBehaviorName != null) {
                this.template.setPropagationBehaviorName(this.propagationBehaviorName);
            }
        }
        return this.template;
    }

    public void setTransactionTemplate(TransactionTemplate template) {
        this.template = template;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setPropagationBehaviorName(String propagationBehaviorName) {
        this.propagationBehaviorName = propagationBehaviorName;
    }

    public String getPropagationBehaviorName() {
        return this.propagationBehaviorName;
    }
}

