/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.RedeliveryErrorHandler;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.spring.spi.TransactionRollbackException;
import org.apache.camel.util.ObjectHelper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandler
extends RedeliveryErrorHandler {
    private final TransactionTemplate transactionTemplate;

    public TransactionErrorHandler(CamelContext camelContext, Processor output, Logger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, Predicate handledPolicy, ExceptionPolicyStrategy exceptionPolicyStrategy, TransactionTemplate transactionTemplate, Predicate retryWhile) {
        super(camelContext, output, logger, redeliveryProcessor, redeliveryPolicy, handledPolicy, null, null, false, retryWhile);
        this.setExceptionPolicy(exceptionPolicyStrategy);
        this.transactionTemplate = transactionTemplate;
    }

    public boolean supportTransacted() {
        return true;
    }

    public String toString() {
        if (this.output == null) {
            return "";
        }
        return "TransactionErrorHandler:" + TransactionErrorHandler.propagationBehaviorToString(this.transactionTemplate.getPropagationBehavior()) + "[" + this.getOutput() + "]";
    }

    public void process(Exchange exchange) throws Exception {
        if (exchange.getUnitOfWork().isTransactedBy((Object)this.transactionTemplate)) {
            this.processByErrorHandler(exchange);
        } else {
            this.processInTransaction(exchange);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInTransaction(Exchange exchange) throws Exception {
        String id = ObjectHelper.getIdentityHashCode((Object)this.transactionTemplate);
        try {
            exchange.getUnitOfWork().beginTransactedBy((Object)this.transactionTemplate);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Transaction begin (" + id + ") for ExchangeId: " + exchange.getExchangeId()));
            }
            this.doInTransactionTemplate(exchange);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Transaction commit (" + id + ") for ExchangeId: " + exchange.getExchangeId()));
            }
        }
        catch (TransactionRollbackException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Transaction rollback (" + id + ") for ExchangeId: " + exchange.getExchangeId()));
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Transaction rollback (" + id + ") for ExchangeId: " + exchange.getExchangeId() + " due exception: " + e.getMessage()));
            exchange.setException((Throwable)e);
        }
        finally {
            exchange.getUnitOfWork().endTransactedBy((Object)this.transactionTemplate);
        }
    }

    protected void doInTransactionTemplate(final Exchange exchange) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Object rce = null;
                TransactionErrorHandler.this.processByErrorHandler(exchange);
                if (exchange.getException() != null || exchange.isRollbackOnly()) {
                    exchange.removeProperty("CamelRollbackOnlyLast");
                    if (exchange.getException() != null) {
                        rce = ObjectHelper.wrapRuntimeCamelException((Throwable)exchange.getException());
                    } else if (exchange.isRollbackOnly()) {
                        rce = new TransactionRollbackException();
                    }
                    if (!status.isRollbackOnly()) {
                        status.setRollbackOnly();
                    }
                    if (rce != null) {
                        throw rce;
                    }
                }
            }
        });
    }

    protected void processByErrorHandler(Exchange exchange) {
        super.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
            }
        });
    }

    private static String propagationBehaviorToString(int propagationBehavior) {
        String rc;
        switch (propagationBehavior) {
            case 2: {
                rc = "PROPAGATION_MANDATORY";
                break;
            }
            case 6: {
                rc = "PROPAGATION_NESTED";
                break;
            }
            case 5: {
                rc = "PROPAGATION_NEVER";
                break;
            }
            case 4: {
                rc = "PROPAGATION_NOT_SUPPORTED";
                break;
            }
            case 0: {
                rc = "PROPAGATION_REQUIRED";
                break;
            }
            case 3: {
                rc = "PROPAGATION_REQUIRES_NEW";
                break;
            }
            case 1: {
                rc = "PROPAGATION_SUPPORTS";
                break;
            }
            default: {
                rc = "UNKNOWN";
            }
        }
        return rc;
    }
}

