/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.stream.StreamEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamConsumer
extends DefaultConsumer
implements Runnable {
    private static final transient Log LOG = LogFactory.getLog(StreamConsumer.class);
    private static final String TYPES = "in,file,url";
    private static final String INVALID_URI = "Invalid uri, valid form: 'stream:{in,file,url}'";
    private static final List<String> TYPES_LIST = Arrays.asList("in,file,url".split(","));
    private ExecutorService executor;
    private InputStream inputStream = System.in;
    private StreamEndpoint endpoint;
    private String uri;
    private boolean initialPromptDone;

    public StreamConsumer(StreamEndpoint endpoint, Processor processor, String uri) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.uri = uri;
        this.validateUri(uri);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if ("in".equals(this.uri)) {
            this.inputStream = System.in;
        } else if ("file".equals(this.uri)) {
            this.inputStream = this.resolveStreamFromFile();
        } else if ("url".equals(this.uri)) {
            this.inputStream = this.resolveStreamFromUrl();
        }
        this.executor = ExecutorServiceHelper.newSingleThreadExecutor((String)this.endpoint.getEndpointUri(), (boolean)true);
        this.executor.execute(this);
    }

    public void doStop() throws Exception {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        super.doStop();
    }

    public void run() {
        try {
            this.readFromStream();
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }

    private void readFromStream() throws Exception {
        Charset charset = this.endpoint.getCharset();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream, charset));
        if (this.endpoint.isScanStream()) {
            while (this.isRunAllowed()) {
                boolean eos;
                String line = br.readLine();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Read line: " + line));
                }
                boolean bl = eos = line == null;
                if (!eos && this.isRunAllowed()) {
                    this.processLine(line);
                }
                try {
                    Thread.sleep(this.endpoint.getScanStreamDelay());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        } else {
            boolean eos = false;
            while (!eos && this.isRunAllowed()) {
                if (this.endpoint.getPromptMessage() != null) {
                    this.doPromptMessage();
                }
                String line = br.readLine();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Read line: " + line));
                }
                if ((eos = line == null) || !this.isRunAllowed()) continue;
                this.processLine(line);
            }
        }
    }

    protected void processLine(Object line) throws Exception {
        Exchange exchange = this.endpoint.createExchange();
        DefaultMessage msg = new DefaultMessage();
        msg.setBody(line);
        exchange.setIn((Message)msg);
        this.getProcessor().process(exchange);
    }

    protected void doPromptMessage() {
        long delay = 0L;
        if (!this.initialPromptDone && this.endpoint.getInitialPromptDelay() > 0L) {
            this.initialPromptDone = true;
            delay = this.endpoint.getInitialPromptDelay();
        } else if (this.endpoint.getPromptDelay() > 0L) {
            delay = this.endpoint.getPromptDelay();
        }
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        System.out.print(this.endpoint.getPromptMessage());
    }

    private InputStream resolveStreamFromUrl() throws IOException {
        String u = this.endpoint.getUrl();
        ObjectHelper.notEmpty((String)u, (String)"url");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to read from url: " + u));
        }
        URL url = new URL(u);
        URLConnection c = url.openConnection();
        return c.getInputStream();
    }

    private InputStream resolveStreamFromFile() throws IOException {
        String fileName = this.endpoint.getFileName();
        ObjectHelper.notEmpty((String)fileName, (String)"fileName");
        File file = new File(fileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("File to be scanned : " + file.getName() + ", path : " + file.getAbsolutePath()));
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        FileInputStream fileStream = new FileInputStream(file);
        return fileStream;
    }

    private void validateUri(String uri) throws IllegalArgumentException {
        String[] s = uri.split(":");
        if (s.length < 2) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        String[] t = s[1].split("\\?");
        if (t.length < 1) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        this.uri = t[0].trim();
        if (this.uri.startsWith("//")) {
            this.uri = this.uri.substring(2);
        }
        if (!TYPES_LIST.contains(this.uri)) {
            throw new IllegalArgumentException(INVALID_URI);
        }
    }
}

