/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.StringQuoteHelper;

public final class PropertyBindingSupport {
    private PropertyBindingSupport() {
    }

    public static Builder build() {
        return new Builder();
    }

    public static boolean autowireSingletonPropertiesFromRegistry(CamelContext camelContext, Object target) {
        return PropertyBindingSupport.autowireSingletonPropertiesFromRegistry(camelContext, target, false, false, null);
    }

    public static boolean autowireSingletonPropertiesFromRegistry(CamelContext camelContext, Object target, boolean bindNullOnly, boolean deepNesting, OnAutowiring callback) {
        try {
            if (target != null) {
                HashSet<Object> parents = new HashSet<Object>();
                return PropertyBindingSupport.doAutowireSingletonPropertiesFromRegistry(camelContext, target, parents, bindNullOnly, deepNesting, callback);
            }
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, (Throwable)e);
        }
        return false;
    }

    private static boolean doAutowireSingletonPropertiesFromRegistry(CamelContext camelContext, Object target, Set<Object> parents, boolean bindNullOnly, boolean deepNesting, OnAutowiring callback) throws Exception {
        LinkedHashMap properties = new LinkedHashMap();
        ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().getProperties(target, properties, null);
        boolean hit = false;
        for (Map.Entry entry : properties.entrySet()) {
            Set lookup;
            Class type;
            boolean skip;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if ("basicPropertyBinding".equals(key) || (skip = parents.contains(value) || value instanceof CamelContext) || (type = PropertyBindingSupport.getGetterType(camelContext, target, key, false)) != null && CamelContext.class.isAssignableFrom(type) || !PropertyBindingSupport.isComplexUserType(type)) continue;
            if ((!bindNullOnly || value == null) && (lookup = camelContext.getRegistry().findByType(type)).size() == 1 && (value = lookup.iterator().next()) != null && (hit |= ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(camelContext, target, key, value)) && callback != null) {
                callback.onAutowire(target, key, type, value);
            }
            if (value == null && deepNesting) {
                Object instance;
                Class<?> parameterType;
                Method method = PropertyBindingSupport.findBestSetterMethod(camelContext, target.getClass(), key, true, true, false);
                if (method == null || (parameterType = method.getParameterTypes()[0]) == null || !org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType) || (instance = camelContext.getInjector().newInstance(parameterType)) == null) continue;
                ObjectHelper.invokeMethod(method, target, instance);
                target = instance;
                parents.add(target);
                value = instance;
                hit |= PropertyBindingSupport.doAutowireSingletonPropertiesFromRegistry(camelContext, value, parents, bindNullOnly, deepNesting, callback);
                continue;
            }
            if (value == null) continue;
            parents.add(target);
            hit |= PropertyBindingSupport.doAutowireSingletonPropertiesFromRegistry(camelContext, value, parents, bindNullOnly, deepNesting, callback);
        }
        return hit;
    }

    public static boolean bindProperties(CamelContext camelContext, Object target, Map<String, Object> properties) {
        org.apache.camel.util.ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        return PropertyBindingSupport.build().bind(camelContext, target, properties);
    }

    private static boolean doBindProperties(CamelContext camelContext, Object target, Map<String, Object> properties, String optionPrefix, boolean ignoreCase, boolean removeParameter, boolean mandatory, boolean nesting, boolean deepNesting, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference, boolean placeholder, PropertyConfigurer configurer) {
        org.apache.camel.util.ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        String uOptionPrefix = ignoreCase && org.apache.camel.util.ObjectHelper.isNotEmpty((Object)optionPrefix) ? optionPrefix.toUpperCase(Locale.US) : "";
        int size = properties.size();
        if (configurer instanceof GeneratedPropertyConfigurer) {
            GeneratedPropertyConfigurer gen = (GeneratedPropertyConfigurer)configurer;
            Iterator<Map.Entry<String, Object>> iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                String key2 = entry.getKey();
                Object value = entry.getValue();
                if (key2.indexOf(46) != -1) continue;
                try {
                    if (value instanceof String) {
                        value = camelContext.resolvePropertyPlaceholders((String)value);
                    }
                    value = PropertyBindingSupport.resolveValue(camelContext, target, key2, value, ignoreCase, fluentBuilder, allowPrivateSetter);
                    boolean hit = gen.configure(camelContext, target, key2, value, ignoreCase);
                    if (!removeParameter || !hit) continue;
                    iter.remove();
                }
                catch (Exception e) {
                    throw new PropertyBindingException(target, key2, value, (Throwable)e);
                }
            }
        }
        PropertyBindingSupport.setReferenceProperties(camelContext, target, properties);
        properties.keySet().stream().sorted(Comparator.comparingInt(s -> StringHelper.countChar((String)s, (char)'.'))).forEach(key -> {
            boolean bound;
            String propertyKey = key;
            Object value = properties.get(key);
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)optionPrefix)) {
                boolean match;
                boolean bl = match = key.startsWith(optionPrefix) || ignoreCase && key.toUpperCase(Locale.US).startsWith(uOptionPrefix);
                if (!match) {
                    return;
                }
                key = key.substring(optionPrefix.length());
            }
            if ((bound = PropertyBindingSupport.bindProperty(camelContext, target, key, value, ignoreCase, nesting, deepNesting, fluentBuilder, allowPrivateSetter, reference, placeholder)) && removeParameter) {
                properties.remove(propertyKey);
            }
            if (mandatory && !bound) {
                throw new PropertyBindingException(target, propertyKey, value);
            }
        });
        return properties.size() != size;
    }

    private static boolean bindProperty(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase, boolean nesting, boolean deepNesting, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference, boolean placeholder) {
        try {
            if (target != null && name != null) {
                return PropertyBindingSupport.setProperty(camelContext, target, name, value, false, ignoreCase, nesting, deepNesting, fluentBuilder, allowPrivateSetter, reference, placeholder);
            }
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, name, value, (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object resolveValue(CamelContext context, Object target, String name, Object value, boolean ignoreCase, boolean fluentBuilder, boolean allowPrivateSetter) throws Exception {
        if (!(value instanceof String)) return value;
        if (value.toString().startsWith("#class:")) {
            String className = value.toString().substring(7);
            String factoryMethod = null;
            String parameters = null;
            if (className.endsWith(")") && className.indexOf(40) != -1) {
                parameters = StringHelper.after((String)className, (String)"(");
                parameters = parameters.substring(0, parameters.length() - 1);
                className = StringHelper.before((String)className, (String)"(");
            }
            if (className != null && className.indexOf(35) != -1) {
                factoryMethod = StringHelper.after((String)className, (String)"#");
                className = StringHelper.before((String)className, (String)"#");
            }
            Class type = context.getClassResolver().resolveMandatoryClass(className);
            value = factoryMethod != null ? context.getInjector().newInstance(type, factoryMethod) : (parameters != null ? PropertyBindingSupport.newInstanceConstructorParameters(context, type, parameters) : context.getInjector().newInstance(type));
            if (value != null) return value;
            throw new IllegalStateException("Cannot create instance of class: " + className);
        }
        if (value.toString().startsWith("#type:")) {
            String typeName = value.toString().substring(6);
            Class type = context.getClassResolver().resolveMandatoryClass(typeName);
            Set types = context.getRegistry().findByType(type);
            if (types.size() == 1) {
                return types.iterator().next();
            }
            if (types.size() <= 1) throw new IllegalStateException("Cannot select single type: " + typeName + " as there are no beans in the registry with this type");
            throw new IllegalStateException("Cannot select single type: " + typeName + " as there are " + types.size() + " beans in the registry with this type");
        }
        if (value.toString().equals("#autowired")) {
            Method method = PropertyBindingSupport.findBestSetterMethod(context, target.getClass(), name, fluentBuilder, allowPrivateSetter, ignoreCase);
            if (method == null) throw new IllegalStateException("Cannot find setter method with name: " + name + " on class: " + target.getClass().getName() + " to use for autowiring");
            Class<?> parameterType = method.getParameterTypes()[0];
            Set types = context.getRegistry().findByType(parameterType);
            if (types.size() == 1) {
                return types.iterator().next();
            }
            if (types.size() <= 1) throw new IllegalStateException("Cannot select single type: " + parameterType + " as there are no beans in the registry with this type");
            throw new IllegalStateException("Cannot select single type: " + parameterType + " as there are " + types.size() + " beans in the registry with this type");
        }
        if (!value.toString().startsWith("#bean:")) return value;
        String key = value.toString().substring(6);
        return context.getRegistry().lookupByName(key);
    }

    private static boolean setProperty(CamelContext context, Object target, String name, Object value, boolean mandatory, boolean ignoreCase, boolean nesting, boolean deepNesting, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference, boolean placeholder) throws Exception {
        boolean hit;
        String refName = null;
        if (placeholder) {
            name = context.resolvePropertyPlaceholders(name);
            if (value instanceof String) {
                value = context.resolvePropertyPlaceholders(value.toString());
            }
        }
        String ognlPath = name;
        if (nesting && name.indexOf(46) > 0) {
            String[] parts = name.split("\\.");
            Object newTarget = target;
            Class<?> newClass = target.getClass();
            for (int i = 0; i < parts.length - 1; ++i) {
                String part = parts[i];
                Object prop = PropertyBindingSupport.getOrElseProperty(context, newTarget, part, null, ignoreCase);
                if (prop == null) {
                    if (!deepNesting) break;
                    Method method = PropertyBindingSupport.findBestSetterMethod(context, newClass, part, fluentBuilder, allowPrivateSetter, ignoreCase);
                    if (method != null) {
                        Class<?> parameterType = method.getParameterTypes()[0];
                        Object instance = null;
                        if (parameterType != null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
                            instance = context.getInjector().newInstance(parameterType);
                        }
                        if (instance == null) continue;
                        ObjectHelper.invokeMethod(method, newTarget, instance);
                        newTarget = instance;
                        newClass = newTarget.getClass();
                        continue;
                    }
                    if (!mandatory) continue;
                    throw new IllegalArgumentException("Cannot find getter method: " + part + " on bean: " + newClass + " when binding property: " + ognlPath);
                }
                newTarget = prop;
                newClass = newTarget.getClass();
            }
            if (newTarget != target) {
                target = newTarget;
                name = parts[parts.length - 1];
            }
        }
        if (reference && value instanceof String) {
            if (value.toString().startsWith("#bean:")) {
                refName = "#" + ((String)value).substring(6);
                value = null;
            } else {
                value = PropertyBindingSupport.resolveValue(context, target, name, value, ignoreCase, fluentBuilder, allowPrivateSetter);
            }
        }
        if (!(hit = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(context, context.getTypeConverter(), target, name, value, refName, fluentBuilder, allowPrivateSetter, ignoreCase)) && mandatory) {
            throw new IllegalArgumentException("Cannot find setter method: " + name + " on bean: " + target + " of type: " + target.getClass().getName() + " when binding property: " + ognlPath);
        }
        return hit;
    }

    private static Object getOrElseProperty(CamelContext context, Object target, String property, Object defaultValue, boolean ignoreCase) {
        Object answer;
        String key = property;
        String lookupKey = null;
        if (property.contains("[") && property.endsWith("]")) {
            int pos = property.indexOf(91);
            lookupKey = property.substring(pos + 1, property.length() - 1);
            key = property.substring(0, pos);
        }
        if ((answer = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().getOrElseProperty(target, key, defaultValue, ignoreCase)) instanceof Map && lookupKey != null) {
            Map map = (Map)answer;
            answer = map.getOrDefault(lookupKey, defaultValue);
        } else if (answer instanceof List) {
            List list = (List)answer;
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)lookupKey)) {
                int idx = Integer.valueOf(lookupKey);
                answer = list.get(idx);
            } else {
                answer = list.isEmpty() ? null : list.get(list.size() - 1);
            }
        }
        return answer != null ? answer : defaultValue;
    }

    private static Method findBestSetterMethod(CamelContext context, Class clazz, String name, boolean fluentBuilder, boolean allowPrivateSetter, boolean ignoreCase) {
        Set candidates = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().findSetterMethods(clazz, name, false, allowPrivateSetter, ignoreCase);
        if (candidates.size() == 1) {
            return (Method)candidates.iterator().next();
        }
        if (fluentBuilder && (candidates = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().findSetterMethods(clazz, name, fluentBuilder, allowPrivateSetter, ignoreCase)).size() == 1) {
            return (Method)candidates.iterator().next();
        }
        return null;
    }

    private static Class getGetterType(CamelContext context, Object target, String name, boolean ignoreCase) {
        try {
            if (ignoreCase) {
                Method getter = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().getPropertyGetter(target.getClass(), name, true);
                if (getter != null) {
                    return getter.getReturnType();
                }
            } else {
                Method getter = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().getPropertyGetter(target.getClass(), name, false);
                if (getter != null) {
                    return getter.getReturnType();
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isComplexUserType(Class type) {
        return type != null && !type.isPrimitive() && !type.getName().startsWith("java.");
    }

    private static void setReferenceProperties(CamelContext context, Object target, Map<String, Object> parameters) {
        Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Object v;
            String value;
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (name.contains(".") || name.contains("[") || name.contains("]") || !PropertyBindingSupport.isReferenceParameter(value = (v = entry.getValue()) != null ? v.toString() : null)) continue;
            try {
                boolean hit = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(context, context.getTypeConverter(), target, name, null, value, true, false, false);
                if (!hit) continue;
                it.remove();
            }
            catch (Exception e) {
                throw new PropertyBindingException(target, (Throwable)e);
            }
        }
    }

    private static boolean isReferenceParameter(String parameter) {
        return parameter != null && parameter.trim().startsWith("#");
    }

    private static Object newInstanceConstructorParameters(CamelContext camelContext, Class<?> type, String parameters) throws Exception {
        String[] params = StringQuoteHelper.splitSafeQuote((String)parameters, (char)',');
        Constructor found = PropertyBindingSupport.findMatchingConstructor(type.getConstructors(), params);
        if (found != null) {
            Object[] arr = new Object[found.getParameterCount()];
            for (int i = 0; i < found.getParameterCount(); ++i) {
                Class<?> paramType = found.getParameterTypes()[i];
                String param = params[i];
                Object val = camelContext.getTypeConverter().convertTo(paramType, (Object)param);
                if (val instanceof String) {
                    val = StringHelper.removeLeadingAndEndingQuotes((String)((String)val));
                }
                arr[i] = val;
            }
            return found.newInstance(arr);
        }
        return null;
    }

    private static Constructor findMatchingConstructor(Constructor<?>[] constructors, String[] params) {
        ArrayList candidates = new ArrayList();
        Constructor<?> fallbackCandidate = null;
        for (Constructor<?> ctr : constructors) {
            if (ctr.getParameterCount() != params.length) continue;
            boolean matches = true;
            for (int i = 0; i < ctr.getParameterCount(); ++i) {
                String parameter = params[i];
                if (parameter != null) {
                    parameter = parameter.trim();
                }
                Class<?> parameterType = PropertyBindingSupport.getValidParameterType(parameter);
                Class<?> expectedType = ctr.getParameterTypes()[i];
                if (parameterType == null || expectedType == null) continue;
                if (Object.class.equals(expectedType)) {
                    fallbackCandidate = ctr;
                    matches = false;
                    break;
                }
                boolean matchingTypes = PropertyBindingSupport.isParameterMatchingType(parameterType, expectedType);
                if (matchingTypes) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            candidates.add(ctr);
        }
        return candidates.size() == 1 ? (Constructor<?>)candidates.get(0) : fallbackCandidate;
    }

    private static Class<?> getValidParameterType(String value) {
        if (org.apache.camel.util.ObjectHelper.isEmpty((Object)value)) {
            return null;
        }
        if ((value = value.trim()).startsWith("'") && value.endsWith("'")) {
            return String.class;
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return String.class;
        }
        if (value.equals("true") || value.equals("false")) {
            return Boolean.class;
        }
        if (value.equals("null")) {
            return Object.class;
        }
        if (StringHelper.hasStartToken((String)value, (String)"simple")) {
            return Object.class;
        }
        boolean numeric = true;
        for (char ch : value.toCharArray()) {
            if (Character.isDigit(ch)) continue;
            numeric = false;
            break;
        }
        if (numeric) {
            return Number.class;
        }
        return null;
    }

    private static boolean isParameterMatchingType(Class<?> parameterType, Class<?> expectedType) {
        if (Number.class.equals(parameterType) && (Integer.class.isAssignableFrom(expectedType) || Long.class.isAssignableFrom(expectedType) || Integer.TYPE.isAssignableFrom(expectedType) || Long.TYPE.isAssignableFrom(expectedType))) {
            return true;
        }
        if (Boolean.class.equals(parameterType) && (Boolean.class.isAssignableFrom(expectedType) || Boolean.TYPE.isAssignableFrom(expectedType))) {
            return true;
        }
        return parameterType.isAssignableFrom(expectedType);
    }

    @FunctionalInterface
    public static interface OnAutowiring {
        public void onAutowire(Object var1, String var2, Class var3, Object var4);
    }

    public static class Builder {
        private CamelContext camelContext;
        private Object target;
        private Map<String, Object> properties;
        private boolean removeParameters = true;
        private boolean mandatory;
        private boolean nesting = true;
        private boolean deepNesting = true;
        private boolean reference = true;
        private boolean placeholder = true;
        private boolean fluentBuilder = true;
        private boolean allowPrivateSetter = true;
        private boolean ignoreCase;
        private String optionPrefix;
        private PropertyConfigurer configurer;

        public Builder withCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
            return this;
        }

        public Builder withTarget(Object target) {
            this.target = target;
            return this;
        }

        public Builder withProperties(Map<String, Object> properties) {
            if (this.properties == null) {
                this.properties = properties;
            } else {
                this.properties.forEach(properties::putIfAbsent);
                this.properties = properties;
            }
            return this;
        }

        public Builder withProperty(String key, Object value) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Object>();
            }
            this.properties.put(key, value);
            return this;
        }

        public Builder withRemoveParameters(boolean removeParameters) {
            this.removeParameters = removeParameters;
            return this;
        }

        public Builder withMandatory(boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        public Builder withNesting(boolean nesting) {
            this.nesting = nesting;
            return this;
        }

        public Builder withDeepNesting(boolean deepNesting) {
            this.deepNesting = deepNesting;
            return this;
        }

        public Builder withReference(boolean reference) {
            this.reference = reference;
            return this;
        }

        public Builder withPlaceholder(boolean placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Builder withFluentBuilder(boolean fluentBuilder) {
            this.fluentBuilder = fluentBuilder;
            return this;
        }

        public Builder withAllowPrivateSetter(boolean allowPrivateSetter) {
            this.allowPrivateSetter = allowPrivateSetter;
            return this;
        }

        public Builder withIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public Builder withOptionPrefix(String optionPrefix) {
            this.optionPrefix = optionPrefix;
            return this;
        }

        public Builder withConfigurer(PropertyConfigurer configurer) {
            this.configurer = configurer;
            return this;
        }

        public boolean bind() {
            org.apache.camel.util.ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
            org.apache.camel.util.ObjectHelper.notNull((Object)this.target, (String)"target");
            org.apache.camel.util.ObjectHelper.notNull(this.properties, (String)"properties");
            return PropertyBindingSupport.doBindProperties(this.camelContext, this.target, this.properties, this.optionPrefix, this.ignoreCase, this.removeParameters, this.mandatory, this.nesting, this.deepNesting, this.fluentBuilder, this.allowPrivateSetter, this.reference, this.placeholder, this.configurer);
        }

        public boolean bind(CamelContext camelContext, Object target, Map<String, Object> properties) {
            CamelContext context = camelContext != null ? camelContext : this.camelContext;
            Object obj = target != null ? target : this.target;
            Map<String, Object> prop = properties != null ? properties : this.properties;
            org.apache.camel.util.ObjectHelper.notNull((Object)context, (String)"camelContext");
            org.apache.camel.util.ObjectHelper.notNull((Object)obj, (String)"target");
            org.apache.camel.util.ObjectHelper.notNull(prop, (String)"properties");
            return PropertyBindingSupport.doBindProperties(context, obj, prop, this.optionPrefix, this.ignoreCase, this.removeParameters, this.mandatory, this.nesting, this.deepNesting, this.fluentBuilder, this.allowPrivateSetter, this.reference, this.placeholder, this.configurer);
        }

        public boolean bind(CamelContext camelContext, Object target, String key, Object value) {
            org.apache.camel.util.ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
            org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
            org.apache.camel.util.ObjectHelper.notNull((Object)key, (String)"key");
            org.apache.camel.util.ObjectHelper.notNull((Object)value, (String)"value");
            HashMap<String, Object> properties = new HashMap<String, Object>(1);
            properties.put(key, value);
            return PropertyBindingSupport.doBindProperties(camelContext, target, properties, this.optionPrefix, this.ignoreCase, this.removeParameters, this.mandatory, this.nesting, this.deepNesting, this.fluentBuilder, this.allowPrivateSetter, this.reference, this.placeholder, this.configurer);
        }
    }
}

