/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.SafeCopyProperty;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.ObjectHelper;

class AbstractExchange
implements ExtendedExchange {
    static final int INTERNAL_LENGTH = ExchangePropertyKey.values().length;
    static final Object[] EMPTY_INTERNAL_PROPERTIES = new Object[INTERNAL_LENGTH];
    final CamelContext context;
    Map<String, Object> properties;
    final Object[] internalProperties = new Object[INTERNAL_LENGTH];
    long created;
    Message in;
    Message out;
    Exception exception;
    String exchangeId;
    UnitOfWork unitOfWork;
    ExchangePattern pattern;
    Endpoint fromEndpoint;
    String fromRouteId;
    List<Synchronization> onCompletions;
    Boolean externalRedelivered;
    String historyNodeId;
    String historyNodeLabel;
    String historyNodeSource;
    boolean transacted;
    boolean routeStop;
    boolean rollbackOnly;
    boolean rollbackOnlyLast;
    boolean notifyEvent;
    boolean interrupted;
    boolean interruptable = true;
    boolean redeliveryExhausted;
    boolean streamCacheDisabled;
    Boolean errorHandlerHandled;
    AsyncCallback defaultConsumerCallback;
    Map<String, SafeCopyProperty> safeCopyProperties;

    public AbstractExchange(CamelContext context) {
        this.context = context;
        this.pattern = ExchangePattern.InOnly;
        this.created = System.currentTimeMillis();
    }

    public AbstractExchange(CamelContext context, ExchangePattern pattern) {
        this.context = context;
        this.pattern = pattern;
        this.created = System.currentTimeMillis();
    }

    public AbstractExchange(Exchange parent) {
        this.context = parent.getContext();
        this.pattern = parent.getPattern();
        this.created = parent.getCreated();
        this.fromEndpoint = parent.getFromEndpoint();
        this.fromRouteId = parent.getFromRouteId();
        this.unitOfWork = parent.getUnitOfWork();
    }

    public AbstractExchange(Endpoint fromEndpoint) {
        this.context = fromEndpoint.getCamelContext();
        this.pattern = fromEndpoint.getExchangePattern();
        this.created = System.currentTimeMillis();
        this.fromEndpoint = fromEndpoint;
    }

    public AbstractExchange(Endpoint fromEndpoint, ExchangePattern pattern) {
        this.context = fromEndpoint.getCamelContext();
        this.pattern = pattern;
        this.created = System.currentTimeMillis();
        this.fromEndpoint = fromEndpoint;
    }

    public long getCreated() {
        return this.created;
    }

    public Exchange copy() {
        List history;
        DefaultExchange exchange = new DefaultExchange((Exchange)this);
        exchange.setIn(this.getIn().copy());
        MessageHelper.copyBody(this.getIn(), exchange.getIn());
        if (this.getIn().hasHeaders()) {
            exchange.getIn().setHeaders(this.safeCopyHeaders(this.getIn().getHeaders()));
        }
        if (this.hasOut()) {
            exchange.setOut(this.getOut().copy());
            MessageHelper.copyBody(this.getOut(), exchange.getOut());
            if (this.getOut().hasHeaders()) {
                exchange.getOut().setHeaders(this.safeCopyHeaders(this.getOut().getHeaders()));
            }
        }
        exchange.setException(this.exception);
        exchange.setRouteStop(this.routeStop);
        exchange.setRollbackOnly(this.rollbackOnly);
        exchange.setRollbackOnlyLast(this.rollbackOnlyLast);
        exchange.setNotifyEvent(this.notifyEvent);
        exchange.setRedeliveryExhausted(this.redeliveryExhausted);
        exchange.setErrorHandlerHandled(this.errorHandlerHandled);
        exchange.setStreamCacheDisabled(this.streamCacheDisabled);
        if (this.hasProperties()) {
            this.copyProperties(this.getProperties(), exchange.getProperties());
        }
        if (this.hasSafeCopyProperties()) {
            this.safeCopyProperties(this.safeCopyProperties, exchange.getSafeCopyProperties());
        }
        System.arraycopy(this.internalProperties, 0, exchange.internalProperties, 0, this.internalProperties.length);
        if (this.getContext().isMessageHistory().booleanValue() && (history = (List)exchange.internalProperties[ExchangePropertyKey.MESSAGE_HISTORY.ordinal()]) != null) {
            exchange.internalProperties[ExchangePropertyKey.MESSAGE_HISTORY.ordinal()] = new CopyOnWriteArrayList(history);
        }
        return exchange;
    }

    private Map<String, Object> safeCopyHeaders(Map<String, Object> headers) {
        ExtendedCamelContext ecc;
        HeadersMapFactory factory;
        if (headers == null) {
            return null;
        }
        if (this.context != null && (factory = (ecc = (ExtendedCamelContext)this.context).getHeadersMapFactory()) != null) {
            return factory.newMap(headers);
        }
        return new HashMap<String, Object>(headers);
    }

    private void copyProperties(Map<String, Object> source, Map<String, Object> target) {
        target.putAll(source);
    }

    private void safeCopyProperties(Map<String, SafeCopyProperty> source, Map<String, SafeCopyProperty> target) {
        source.entrySet().stream().forEach(entry -> target.put((String)entry.getKey(), ((SafeCopyProperty)entry.getValue()).safeCopy()));
    }

    public void copySafeCopyPropertiesTo(ExtendedExchange target) {
        if (this.safeCopyProperties != null && !this.safeCopyProperties.isEmpty()) {
            this.safeCopyProperties.entrySet().forEach(entry -> target.setSafeCopyProperty((String)entry.getKey(), ((SafeCopyProperty)entry.getValue()).safeCopy()));
        }
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Object getProperty(ExchangePropertyKey key) {
        return this.internalProperties[key.ordinal()];
    }

    public <T> T getProperty(ExchangePropertyKey key, Class<T> type) {
        Object value = this.getProperty(key);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType((Exchange)this, type, value);
    }

    public <T> T getProperty(ExchangePropertyKey key, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType((Exchange)this, type, value);
    }

    public void setProperty(ExchangePropertyKey key, Object value) {
        this.internalProperties[key.ordinal()] = value;
    }

    public Object removeProperty(ExchangePropertyKey key) {
        Object old = this.internalProperties[key.ordinal()];
        this.internalProperties[key.ordinal()] = null;
        return old;
    }

    public Object getProperty(String name) {
        Object answer = null;
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey((String)name);
        if (key != null) {
            answer = this.internalProperties[key.ordinal()];
        }
        if (answer == null && this.properties != null) {
            answer = this.properties.get(name);
        }
        return answer;
    }

    public Object getProperty(String name, Object defaultValue) {
        Object answer = this.getProperty(name);
        return answer != null ? answer : defaultValue;
    }

    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType((Exchange)this, type, value);
    }

    public <T> T getProperty(String name, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType((Exchange)this, type, value);
    }

    public void setProperty(String name, Object value) {
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey((String)name);
        if (key != null) {
            this.setProperty(key, value);
        } else if (value != null) {
            if (this.properties == null) {
                this.properties = new ConcurrentHashMap<String, Object>(8);
            }
            this.properties.put(name, value);
        } else if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    public void setProperties(Map<String, Object> properties) {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>(8);
        } else {
            this.properties.clear();
        }
        this.properties.putAll(properties);
    }

    public Object removeProperty(String name) {
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey((String)name);
        if (key != null) {
            return this.removeProperty(key);
        }
        if (!this.hasProperties()) {
            return null;
        }
        return this.properties.remove(name);
    }

    public boolean removeProperties(String pattern) {
        return this.removeProperties(pattern, null);
    }

    public boolean removeProperties(String pattern, String ... excludePatterns) {
        if (excludePatterns == null && "*".equals(pattern)) {
            if (this.properties != null) {
                this.properties.clear();
            }
            System.arraycopy(EMPTY_INTERNAL_PROPERTIES, 0, this.internalProperties, 0, INTERNAL_LENGTH);
            return true;
        }
        boolean matches = false;
        for (ExchangePropertyKey epk : ExchangePropertyKey.values()) {
            String key = epk.getName();
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            this.internalProperties[epk.ordinal()] = null;
        }
        if (this.properties != null) {
            HashSet<String> toBeRemoved = null;
            for (String key : this.properties.keySet()) {
                if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
                matches = true;
                if (toBeRemoved == null) {
                    toBeRemoved = new HashSet<String>();
                }
                toBeRemoved.add(key);
            }
            if (matches && toBeRemoved != null) {
                if (toBeRemoved.size() == this.properties.size()) {
                    this.properties.clear();
                } else {
                    for (String key : toBeRemoved) {
                        this.properties.remove(key);
                    }
                }
            }
        }
        return matches;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>(8);
        }
        return this.properties;
    }

    Map<String, SafeCopyProperty> getSafeCopyProperties() {
        if (this.safeCopyProperties == null) {
            this.safeCopyProperties = new ConcurrentHashMap<String, SafeCopyProperty>(2);
        }
        return this.safeCopyProperties;
    }

    public Map<String, Object> getAllProperties() {
        Map<String, Object> map = this.getInternalProperties();
        if (this.properties != null && !this.properties.isEmpty()) {
            map.putAll(this.properties);
        }
        return map;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    private boolean hasSafeCopyProperties() {
        return this.safeCopyProperties != null && !this.safeCopyProperties.isEmpty();
    }

    public Message getIn() {
        if (this.in == null) {
            this.in = new DefaultMessage(this.getContext());
            this.configureMessage(this.in);
        }
        return this.in;
    }

    public <T> T getIn(Class<T> type) {
        Message in = this.getIn();
        if (type.isInstance(in)) {
            return type.cast(in);
        }
        return (T)this.context.getTypeConverter().convertTo(type, (Exchange)this, (Object)in);
    }

    public <T> T getInOrNull(Class<T> type) {
        if (this.in == null) {
            return null;
        }
        if (type.isInstance(this.in)) {
            return type.cast(this.in);
        }
        return null;
    }

    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    public Message getOut() {
        if (this.out == null) {
            this.out = this.in instanceof MessageSupport ? ((MessageSupport)this.in).newInstance() : new DefaultMessage(this.getContext());
            this.configureMessage(this.out);
        }
        return this.out;
    }

    public <T> T getOut(Class<T> type) {
        if (!this.hasOut()) {
            return null;
        }
        Message out = this.getOut();
        if (type.isInstance(out)) {
            return type.cast(out);
        }
        return (T)this.context.getTypeConverter().convertTo(type, (Exchange)this, (Object)out);
    }

    public boolean hasOut() {
        return this.out != null;
    }

    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    public Message getMessage() {
        return this.hasOut() ? this.getOut() : this.getIn();
    }

    public <T> T getMessage(Class<T> type) {
        return this.hasOut() ? this.getOut(type) : this.getIn(type);
    }

    public void setMessage(Message message) {
        if (this.hasOut()) {
            this.setOut(message);
        } else {
            this.setIn(message);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public <T> T getException(Class<T> type) {
        return (T)ObjectHelper.getException(type, (Throwable)this.exception);
    }

    public void setException(Throwable t) {
        this.exception = t == null ? null : (t instanceof Exception ? (Exception)t : CamelExecutionException.wrapCamelExecutionException((Exchange)this, (Throwable)t));
        if (t instanceof InterruptedException) {
            this.setInterrupted(true);
        }
    }

    public <T extends Exchange> T adapt(Class<T> type) {
        return (T)((Exchange)type.cast(this));
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public Endpoint getFromEndpoint() {
        return this.fromEndpoint;
    }

    public void setFromEndpoint(Endpoint fromEndpoint) {
        this.fromEndpoint = fromEndpoint;
    }

    public String getFromRouteId() {
        return this.fromRouteId;
    }

    public void setFromRouteId(String fromRouteId) {
        this.fromRouteId = fromRouteId;
    }

    public String getExchangeId() {
        if (this.exchangeId == null) {
            this.exchangeId = this.createExchangeId();
        }
        return this.exchangeId;
    }

    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    public boolean isFailed() {
        return this.exception != null;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean isRouteStop() {
        return this.routeStop;
    }

    public void setRouteStop(boolean routeStop) {
        this.routeStop = routeStop;
    }

    public boolean isExternalRedelivered() {
        if (this.externalRedelivered == null) {
            Message msg = this.getIn();
            if (msg instanceof DefaultMessage) {
                this.externalRedelivered = ((DefaultMessage)msg).isTransactedRedelivered();
            }
            if (this.externalRedelivered == null) {
                this.externalRedelivered = false;
            }
        }
        return this.externalRedelivered;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }

    public boolean isRollbackOnlyLast() {
        return this.rollbackOnlyLast;
    }

    public void setRollbackOnlyLast(boolean rollbackOnlyLast) {
        this.rollbackOnlyLast = rollbackOnlyLast;
    }

    public UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
        if (unitOfWork != null && this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                unitOfWork.addSynchronization(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        }
    }

    public void addOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork == null) {
            if (this.onCompletions == null) {
                this.onCompletions = new ArrayList<Synchronization>();
            }
            this.onCompletions.add(onCompletion);
        } else {
            this.getUnitOfWork().addSynchronization(onCompletion);
        }
    }

    public boolean containsOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork != null) {
            return this.unitOfWork.containsSynchronization(onCompletion);
        }
        return this.onCompletions != null && this.onCompletions.contains(onCompletion);
    }

    public void handoverCompletions(Exchange target) {
        if (this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                ((ExtendedExchange)target.adapt(ExtendedExchange.class)).addOnCompletion(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        } else if (this.unitOfWork != null) {
            this.unitOfWork.handoverSynchronization(target);
        }
    }

    public List<Synchronization> handoverCompletions() {
        ArrayList<Synchronization> answer = null;
        if (this.onCompletions != null) {
            answer = new ArrayList<Synchronization>(this.onCompletions);
            this.onCompletions.clear();
            this.onCompletions = null;
        }
        return answer;
    }

    public String getHistoryNodeId() {
        return this.historyNodeId;
    }

    public void setHistoryNodeId(String historyNodeId) {
        this.historyNodeId = historyNodeId;
    }

    public String getHistoryNodeLabel() {
        return this.historyNodeLabel;
    }

    public void setHistoryNodeLabel(String historyNodeLabel) {
        this.historyNodeLabel = historyNodeLabel;
    }

    public String getHistoryNodeSource() {
        return this.historyNodeSource;
    }

    public void setHistoryNodeSource(String historyNodeSource) {
        this.historyNodeSource = historyNodeSource;
    }

    public boolean isNotifyEvent() {
        return this.notifyEvent;
    }

    public void setNotifyEvent(boolean notifyEvent) {
        this.notifyEvent = notifyEvent;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        if (this.interruptable) {
            this.interrupted = interrupted;
        }
    }

    public void setInterruptable(boolean interruptable) {
        this.interruptable = interruptable;
    }

    public boolean isRedeliveryExhausted() {
        return this.redeliveryExhausted;
    }

    public void setRedeliveryExhausted(boolean redeliveryExhausted) {
        this.redeliveryExhausted = redeliveryExhausted;
    }

    public Boolean getErrorHandlerHandled() {
        return this.errorHandlerHandled;
    }

    public boolean isErrorHandlerHandledSet() {
        return this.errorHandlerHandled != null;
    }

    public boolean isErrorHandlerHandled() {
        return this.errorHandlerHandled;
    }

    public void setErrorHandlerHandled(Boolean errorHandlerHandled) {
        this.errorHandlerHandled = errorHandlerHandled;
    }

    public boolean isStreamCacheDisabled() {
        return this.streamCacheDisabled;
    }

    public void setStreamCacheDisabled(boolean streamCacheDisabled) {
        this.streamCacheDisabled = streamCacheDisabled;
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange((Exchange)this);
            messageSupport.setCamelContext(this.getContext());
        }
    }

    public void copyInternalProperties(Exchange target) {
        AbstractExchange ae = (AbstractExchange)target;
        for (int i = 0; i < this.internalProperties.length; ++i) {
            Object value = this.internalProperties[i];
            if (value == null) continue;
            ae.internalProperties[i] = value;
        }
    }

    public Map<String, Object> getInternalProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ExchangePropertyKey key : ExchangePropertyKey.values()) {
            Object value = this.internalProperties[key.ordinal()];
            if (value == null) continue;
            map.put(key.getName(), value);
        }
        return map;
    }

    public AsyncCallback getDefaultConsumerCallback() {
        return this.defaultConsumerCallback;
    }

    public void setDefaultConsumerCallback(AsyncCallback defaultConsumerCallback) {
        this.defaultConsumerCallback = defaultConsumerCallback;
    }

    protected String createExchangeId() {
        return this.context.getUuidGenerator().generateExchangeUuid();
    }

    public final String toString() {
        if (this.exchangeId != null) {
            return "Exchange[" + this.exchangeId + "]";
        }
        return "Exchange[]";
    }

    public void setSafeCopyProperty(String key, SafeCopyProperty value) {
        if (value != null) {
            if (this.safeCopyProperties == null) {
                this.safeCopyProperties = new ConcurrentHashMap<String, SafeCopyProperty>(2);
            }
            this.safeCopyProperties.put(key, value);
        } else if (this.safeCopyProperties != null) {
            this.safeCopyProperties.remove(key);
        }
    }

    public <T> T getSafeCopyProperty(String key, Class<T> type) {
        if (!this.hasSafeCopyProperties()) {
            return null;
        }
        SafeCopyProperty value = this.getSafeCopyProperties().get(key);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType((Exchange)this, type, value);
    }
}

