/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;

public final class InputStreamCache
extends ByteArrayInputStream
implements StreamCache {
    public InputStreamCache(byte[] data) {
        super(data);
    }

    public InputStreamCache(byte[] data, int count) {
        super(data);
        this.count = count;
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.buf, this.pos, this.count - this.pos);
    }

    public StreamCache copy(Exchange exchange) {
        return new InputStreamCache(this.buf, this.count);
    }

    public boolean inMemory() {
        return true;
    }

    public long length() {
        return this.count;
    }
}

