/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;

public abstract class TypeConverterSupport
implements TypeConverter {
    public boolean allowNull() {
        return false;
    }

    public <T> T convertTo(Class<T> type, Object value) throws TypeConversionException {
        return (T)this.convertTo(type, null, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        Object t = this.convertTo(type, null, value);
        if (t == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return (T)t;
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        Object t = this.convertTo(type, exchange, value);
        if (t == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return (T)t;
    }

    public <T> T tryConvertTo(Class<T> type, Object value) {
        try {
            return (T)this.convertTo(type, null, value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        try {
            return (T)this.convertTo(type, exchange, value);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

