/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;

public final class PredicateToExpressionAdapter
implements Expression {
    private final Predicate predicate;

    public PredicateToExpressionAdapter(Predicate predicate) {
        this.predicate = predicate;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        boolean matches = this.predicate.matches(exchange);
        return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, (Object)matches);
    }

    public String toString() {
        return this.predicate.toString();
    }

    public static Expression toExpression(Predicate predicate) {
        if (predicate instanceof Expression) {
            return (Expression)predicate;
        }
        return new PredicateToExpressionAdapter(predicate);
    }
}

