/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.resume;

import org.apache.camel.CamelContext;
import org.apache.camel.resume.ResumeAction;
import org.apache.camel.resume.ResumeActionAware;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResumeStrategyHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ResumeStrategyHelper.class);

    private ResumeStrategyHelper() {
    }

    public static void resume(CamelContext context, Object on, ResumeStrategy resumeStrategy, String actionName) throws Exception {
        ResumeStrategyHelper.resume(context, on, resumeStrategy, actionName, ResumeAdapter.class);
    }

    public static <T extends ResumeAdapter> void resume(CamelContext context, Object on, ResumeStrategy resumeStrategy, String actionName, Class<T> adapterClass) throws Exception {
        if (resumeStrategy == null) {
            LOG.debug("Skipping resume operation because there's no resume strategy defined");
            return;
        }
        LOG.debug("Loading the resume cache");
        resumeStrategy.loadCache();
        ResumeAdapter resumeAdapter = resumeStrategy.getAdapter(adapterClass);
        if (resumeAdapter == null) {
            LOG.warn("The resume cannot be executed because no resume adapter was provided");
            return;
        }
        if (resumeAdapter instanceof ResumeActionAware) {
            ResumeAction action = (ResumeAction)context.getRegistry().lookupByName(actionName);
            ObjectHelper.notNull((Object)action, (String)"The resume action cannot be null", (Object)on);
            ((ResumeActionAware)resumeAdapter).setResumeAction(action);
        }
        resumeAdapter.resume();
    }
}

