/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderOrPropertyException;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class ConvertHeaderProcessor
extends ServiceSupport
implements AsyncProcessor,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final String name;
    private final Expression headerName;
    private final Class<?> type;
    private final String charset;
    private final boolean mandatory;

    public ConvertHeaderProcessor(String name, Expression headerName, Class<?> type, String charset, boolean mandatory) {
        ObjectHelper.notNull((Object)headerName, (String)"headerName");
        ObjectHelper.notNull(type, (String)"type", (Object)((Object)this));
        this.name = name;
        this.headerName = headerName;
        this.type = type;
        this.charset = IOHelper.normalizeCharset((String)charset);
        this.mandatory = mandatory;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public void process(Exchange exchange) throws Exception {
        Object value;
        String name;
        Message old = exchange.getMessage();
        if (old.getHeader(name = (String)this.headerName.evaluate(exchange, String.class)) == null) {
            return;
        }
        if (exchange.getException() != null) {
            return;
        }
        String originalCharsetName = null;
        if (this.charset != null) {
            originalCharsetName = (String)exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)this.charset);
        }
        if ((value = old.getHeader(name)) == null && this.mandatory) {
            throw new NoSuchHeaderOrPropertyException(exchange, name, null, this.type);
        }
        value = this.mandatory ? exchange.getContext().getTypeConverter().mandatoryConvertTo(this.type, exchange, value) : exchange.getContext().getTypeConverter().convertTo(this.type, exchange, value);
        old.setHeader(name, value);
        if (this.charset != null) {
            if (originalCharsetName != null && !originalCharsetName.isEmpty()) {
                exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)originalCharsetName);
            } else {
                exchange.removeProperty(ExchangePropertyKey.CHARSET_NAME);
            }
        }
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange);
        this.process(exchange, callback);
        return callback.getFuture();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getCharset() {
        return this.charset;
    }
}

