/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointHelper.class);
    private static final AtomicLong ENDPOINT_COUNTER = new AtomicLong();

    private EndpointHelper() {
    }

    public static String resolveEndpointUriPropertyPlaceholders(CamelContext camelContext, String uri) {
        try {
            uri = camelContext.getCamelContextExtension().resolvePropertyPlaceholders(uri, true);
            if (uri == null || uri.isEmpty()) {
                return uri;
            }
            String prefix = "{{?";
            if (uri.contains(prefix)) {
                String unresolved = uri;
                uri = EndpointHelper.doResolveEndpointUriOptionalPropertyPlaceholders(unresolved);
                LOG.trace("Unresolved optional placeholders removed from uri: {} -> {}", (Object)unresolved, (Object)uri);
            }
            LOG.trace("Resolved property placeholders with uri: {}", (Object)uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        return uri;
    }

    private static String doResolveEndpointUriOptionalPropertyPlaceholders(String uri) throws URISyntaxException {
        String prefix = "{{?";
        int pos = 0;
        for (int i = 0; i < uri.length(); ++i) {
            char ch = uri.charAt(i);
            if (ch != '?') continue;
            if (i > 2) {
                char ch1 = uri.charAt(i - 1);
                char ch2 = uri.charAt(i - 2);
                if (ch1 == '{' || ch2 == '{') continue;
                pos = i;
                break;
            }
            pos = i;
            break;
        }
        String base = pos > 0 ? uri.substring(0, pos) : uri;
        String query = pos > 0 ? uri.substring(pos + 1) : null;
        String pattern = "\\{\\{?.*}}";
        base = base.replaceAll(pattern, "");
        if (query != null && query.contains(prefix)) {
            Map params = URISupport.parseQuery((String)query);
            Map<String, Object> keep = EndpointHelper.extractParamsToKeep(params, prefix);
            query = URISupport.createQueryString(keep);
        }
        uri = query != null && !query.isEmpty() ? base + "?" + query : base;
        return uri;
    }

    private static Map<String, Object> extractParamsToKeep(Map<String, Object> params, String prefix) {
        LinkedHashMap<String, Object> keep = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            int dot;
            String s;
            Object value;
            String key = entry.getKey();
            if (key.startsWith(prefix) || (value = entry.getValue()) instanceof String && ((s = value.toString()).startsWith(prefix) || (dot = s.indexOf(58)) > 0 && dot < s.length() - 1 && (s = s.substring(dot + 1)).startsWith(prefix))) continue;
            keep.put(key, value);
        }
        return keep;
    }

    public static String normalizeEndpointUri(String uri) {
        try {
            uri = URISupport.normalizeUri((String)uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollEndpoint(Endpoint endpoint, Processor processor, long timeout) throws Exception {
        PollingConsumer consumer = endpoint.createPollingConsumer();
        try {
            Exchange exchange;
            ServiceHelper.startService((Service)consumer);
            while ((exchange = consumer.receive(timeout)) != null) {
                processor.process(exchange);
            }
        }
        finally {
            try {
                ServiceHelper.stopAndShutdownService((Object)consumer);
            }
            catch (Exception e) {
                LOG.warn("Failed to stop PollingConsumer: {}. This example is ignored.", (Object)consumer, (Object)e);
            }
        }
    }

    public static void pollEndpoint(Endpoint endpoint, Processor processor) throws Exception {
        EndpointHelper.pollEndpoint(endpoint, processor, 1000L);
    }

    public static boolean matchEndpoint(CamelContext context, String uri, String pattern) {
        boolean match;
        if (context != null) {
            try {
                uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(context, uri);
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        }
        if (!(match = EndpointHelper.doMatchEndpoint(uri = EndpointHelper.normalizeEndpointUri(uri), pattern, false))) {
            match = EndpointHelper.doMatchEndpoint(uri, pattern, true);
        }
        return match;
    }

    private static boolean doMatchEndpoint(String uri, String pattern, boolean regexp) {
        boolean match;
        String toggleUri = null;
        boolean bl = match = regexp ? PatternHelper.matchRegex(uri, pattern) : PatternHelper.matchPattern(uri, pattern);
        if (!match) {
            toggleUri = EndpointHelper.toggleUriSchemeSeparators(uri);
            boolean bl2 = match = regexp ? PatternHelper.matchRegex(toggleUri, pattern) : PatternHelper.matchPattern(toggleUri, pattern);
        }
        if (!match && !regexp && pattern != null && pattern.contains("?")) {
            try {
                pattern = URISupport.normalizeUri((String)pattern);
                return uri.equalsIgnoreCase(pattern) || toggleUri.equalsIgnoreCase(pattern);
            }
            catch (URISyntaxException e) {
                return false;
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        }
        return match;
    }

    private static String toggleUriSchemeSeparators(String normalizedUri) {
        if (normalizedUri.contains("://")) {
            String scheme = StringHelper.before((String)normalizedUri, (String)"://");
            String path = StringHelper.after((String)normalizedUri, (String)"://");
            return scheme + ":" + path;
        }
        String scheme = StringHelper.before((String)normalizedUri, (String)":");
        String path = StringHelper.after((String)normalizedUri, (String)":");
        return scheme + "://" + path;
    }

    public static boolean isReferenceParameter(String parameter) {
        return parameter != null && parameter.trim().startsWith("#") && parameter.trim().length() > 1;
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type) {
        return EndpointHelper.resolveReferenceParameter(context, value, type, true);
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type, boolean mandatory) {
        Object answer = null;
        if (value.startsWith("#class:")) {
            try {
                answer = EndpointHelper.createBean(context, value, type);
            }
            catch (Exception e) {
                throw new NoSuchBeanException(value, (Throwable)e);
            }
        } else if (value.startsWith("#type:")) {
            try {
                value = value.substring(6);
                Class clazz = context.getClassResolver().resolveMandatoryClass(value);
                answer = context.getRegistry().mandatoryFindSingleByType(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new NoSuchBeanException(value, (Throwable)e);
            }
        } else {
            value = value.replace("#bean:", "");
            answer = CamelContextHelper.lookup(context, value = value.replace("#", ""), type);
            if (answer == null) {
                answer = CamelContextHelper.lookup(context, value);
            }
        }
        if (mandatory && answer == null) {
            if (type != null) {
                throw new NoSuchBeanException(value, type.getTypeName());
            }
            throw new NoSuchBeanException(value);
        }
        if (answer != null) {
            answer = mandatory ? (Object)CamelContextHelper.convertTo(context, type, answer) : (Object)CamelContextHelper.tryConvertTo(context, type, answer);
        }
        return (T)answer;
    }

    private static <T> T createBean(CamelContext camelContext, String name, Class<T> type) throws Exception {
        Object answer;
        String typeOrRef;
        String factoryMethod = null;
        String parameters = null;
        String className = name.substring(7);
        if (className.endsWith(")") && className.indexOf(40) != -1) {
            parameters = StringHelper.after((String)className, (String)"(");
            parameters = parameters.substring(0, parameters.length() - 1);
            className = StringHelper.before((String)className, (String)"(");
        }
        if (className != null && className.indexOf(35) != -1) {
            factoryMethod = StringHelper.after((String)className, (String)"#");
            className = StringHelper.before((String)className, (String)"#");
        }
        Class clazz = camelContext.getClassResolver().resolveMandatoryClass(className);
        Class factoryClass = null;
        if (factoryMethod != null && (typeOrRef = StringHelper.before((String)factoryMethod, (String)":")) != null) {
            factoryMethod = StringHelper.after((String)factoryMethod, (String)":");
            Object existing = camelContext.getRegistry().lookupByName(typeOrRef);
            factoryClass = existing != null ? existing.getClass() : camelContext.getClassResolver().resolveMandatoryClass(typeOrRef);
        }
        if (factoryMethod != null && parameters != null) {
            Class target = factoryClass != null ? factoryClass : clazz;
            answer = PropertyBindingSupport.newInstanceFactoryParameters(camelContext, target, factoryMethod, parameters);
        } else {
            answer = factoryMethod != null ? camelContext.getInjector().newInstance(type, factoryClass, factoryMethod) : (parameters != null ? PropertyBindingSupport.newInstanceConstructorParameters(camelContext, clazz, parameters) : camelContext.getInjector().newInstance(clazz));
        }
        if (answer == null) {
            throw new IllegalStateException("Cannot create bean: " + name);
        }
        return type.cast(answer);
    }

    public static <T> List<T> resolveReferenceListParameter(CamelContext context, String value, Class<T> elementType) {
        if (value == null) {
            return new ArrayList();
        }
        List<String> elements = Arrays.asList(value.split(","));
        if (elements.size() == 1) {
            Object bean = EndpointHelper.resolveReferenceParameter(context, elements.get(0).trim(), Object.class);
            if (bean instanceof List) {
                return (List)bean;
            }
            ArrayList<T> singleElementList = new ArrayList<T>();
            singleElementList.add(elementType.cast(bean));
            return singleElementList;
        }
        ArrayList<T> result = new ArrayList<T>(elements.size());
        for (String element : elements) {
            result.add(EndpointHelper.resolveReferenceParameter(context, element.trim(), elementType));
        }
        return result;
    }

    public static <T> T resolveParameter(CamelContext context, String value, Class<T> type) {
        Object result = EndpointHelper.isReferenceParameter(value) ? EndpointHelper.resolveReferenceParameter(context, value, type) : context.getTypeConverter().convertTo(type, (Object)value);
        return result;
    }

    public static String getRouteIdFromEndpoint(Endpoint endpoint) {
        if (endpoint == null || endpoint.getCamelContext() == null) {
            return null;
        }
        List routes = endpoint.getCamelContext().getRoutes();
        for (Route route : routes) {
            if (!route.getEndpoint().equals(endpoint) && !route.getEndpoint().getEndpointKey().equals(endpoint.getEndpointKey())) continue;
            return route.getId();
        }
        return null;
    }

    public static String createEndpointId() {
        return "endpoint" + ENDPOINT_COUNTER.incrementAndGet();
    }

    public static String lookupEndpointRegistryId(Endpoint endpoint) {
        if (endpoint == null || endpoint.getCamelContext() == null) {
            return null;
        }
        Endpoint delegate = null;
        if (endpoint instanceof DelegateEndpoint) {
            delegate = ((DelegateEndpoint)endpoint).getEndpoint();
        }
        Map map = endpoint.getCamelContext().getRegistry().findByTypeWithName(Endpoint.class);
        for (Map.Entry entry : map.entrySet()) {
            if (!((Endpoint)entry.getValue()).equals(endpoint) && !((Endpoint)entry.getValue()).equals(delegate)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public static ExchangePattern resolveExchangePatternFromUrl(String url) {
        if (url.contains("exchangePattern=InOnly")) {
            return ExchangePattern.InOnly;
        }
        if (url.contains("exchangePattern=InOut")) {
            return ExchangePattern.InOut;
        }
        return null;
    }
}

