/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.PredicateAssertHelper;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TestSupport.class);

    private TestSupport() {
    }

    public static ValueBuilder header(String name) {
        return Builder.header((String)name);
    }

    public static ValueBuilder exchangeProperty(String name) {
        return Builder.exchangeProperty((String)name);
    }

    public static ValueBuilder body() {
        return Builder.body();
    }

    public static <T> ValueBuilder bodyAs(Class<T> type) {
        return Builder.bodyAs(type);
    }

    public static ValueBuilder systemProperty(String name) {
        return Builder.systemProperty((String)name);
    }

    public static ValueBuilder systemProperty(String name, String defaultValue) {
        return Builder.systemProperty((String)name, (String)defaultValue);
    }

    public static <T> T assertIsInstanceOf(Class<T> expectedType, Object value) {
        Assertions.assertNotNull((Object)value, (String)("Expected an instance of type: " + expectedType.getName() + " but was null"));
        Assertions.assertTrue((boolean)expectedType.isInstance(value), (String)("Object should be of type " + expectedType.getName() + " but was: " + value + " with the type: " + value.getClass().getName()));
        return expectedType.cast(value);
    }

    public static void assertEndpointUri(Endpoint endpoint, String expectedUri) {
        Assertions.assertNotNull((Object)endpoint, (String)("Endpoint is null when expecting endpoint for: " + expectedUri));
        Assertions.assertEquals((Object)expectedUri, (Object)endpoint.getEndpointUri(), (String)("Endpoint uri for: " + endpoint));
    }

    public static Object assertInMessageHeader(Exchange exchange, String headerName, Object expectedValue) {
        return TestSupport.assertMessageHeader(exchange.getIn(), headerName, expectedValue);
    }

    public static Object assertOutMessageHeader(Exchange exchange, String headerName, Object expectedValue) {
        return TestSupport.assertMessageHeader(exchange.getMessage(), headerName, expectedValue);
    }

    public static void assertInMessageBodyEquals(Exchange exchange, Object expectedBody) throws InvalidPayloadException {
        Object actualBody;
        Assertions.assertNotNull((Object)exchange, (String)"Should have a response exchange");
        if (expectedBody == null) {
            actualBody = exchange.getIn().getMandatoryBody();
            Assertions.assertEquals((Object)expectedBody, (Object)actualBody, (String)("in body of: " + exchange));
        } else {
            actualBody = exchange.getIn().getMandatoryBody(expectedBody.getClass());
        }
        Assertions.assertEquals((Object)expectedBody, (Object)actualBody, (String)("in body of: " + exchange));
        LOG.debug("Received response: " + exchange + " with in: " + exchange.getIn());
    }

    public static void assertMessageBodyEquals(Exchange exchange, Object expectedBody) throws InvalidPayloadException {
        Object actualBody;
        Assertions.assertNotNull((Object)exchange, (String)"Should have a response exchange!");
        if (expectedBody == null) {
            actualBody = exchange.getMessage().getMandatoryBody();
            Assertions.assertEquals((Object)expectedBody, (Object)actualBody, (String)("output body of: " + exchange));
        } else {
            actualBody = exchange.getMessage().getMandatoryBody(expectedBody.getClass());
        }
        Assertions.assertEquals((Object)expectedBody, (Object)actualBody, (String)("output body of: " + exchange));
        LOG.debug("Received response: " + exchange + " with out: " + exchange.getMessage());
    }

    public static Object assertMessageHeader(Message message, String headerName, Object expectedValue) {
        Object actualValue = message.getHeader(headerName);
        Assertions.assertEquals((Object)expectedValue, (Object)actualValue, (String)("Header: " + headerName + " on Message: " + message));
        return actualValue;
    }

    public static Object assertExpression(Expression expression, Exchange exchange, Object expectedAnswer) {
        Object actualAnswer = expectedAnswer != null ? expression.evaluate(exchange, expectedAnswer.getClass()) : expression.evaluate(exchange, Object.class);
        LOG.debug("Evaluated expression: " + expression + " on exchange: " + exchange + " result: " + actualAnswer);
        Assertions.assertEquals((Object)expectedAnswer, (Object)actualAnswer, (String)("Expression: " + expression + " on Exchange: " + exchange));
        return actualAnswer;
    }

    public static void assertPredicateMatches(Predicate predicate, Exchange exchange) {
        TestSupport.assertPredicate(predicate, exchange, true);
    }

    public static void assertPredicateDoesNotMatch(Predicate predicate, Exchange exchange) {
        try {
            PredicateAssertHelper.assertMatches((Predicate)predicate, (String)"Predicate should match: ", (Exchange)exchange);
        }
        catch (AssertionError e) {
            LOG.debug("Caught expected assertion error: " + e);
        }
        TestSupport.assertPredicate(predicate, exchange, false);
    }

    public static boolean assertPredicate(Predicate predicate, Exchange exchange, boolean expectedValue) {
        if (expectedValue) {
            PredicateAssertHelper.assertMatches((Predicate)predicate, (String)"Predicate failed: ", (Exchange)exchange);
        }
        boolean actualValue = predicate.matches(exchange);
        LOG.debug("Evaluated predicate: " + predicate + " on exchange: " + exchange + " result: " + actualValue);
        Assertions.assertEquals((Object)expectedValue, (Object)actualValue, (String)("Predicate: " + predicate + " on Exchange: " + exchange));
        return actualValue;
    }

    public static <T> T assertOneElement(List<T> list) {
        Assertions.assertEquals((int)1, (int)list.size(), (String)("Size of list should be 1: " + list));
        return list.get(0);
    }

    public static <T> List<T> assertListSize(List<T> list, int expectedSize) {
        return TestSupport.assertListSize("List", list, expectedSize);
    }

    public static <T> List<T> assertListSize(String brokenAssertionMessagePrefix, List<T> list, int expectedSize) {
        Assertions.assertEquals((int)expectedSize, (int)list.size(), (String)(brokenAssertionMessagePrefix + " should be of size: " + expectedSize + " but is: " + list));
        return list;
    }

    public static <T> Collection<T> assertCollectionSize(Collection<T> list, int expectedSize) {
        return TestSupport.assertCollectionSize("List", list, expectedSize);
    }

    public static <T> Collection<T> assertCollectionSize(String brokenAssertionMessagePrefix, Collection<T> list, int expectedSize) {
        Assertions.assertEquals((int)expectedSize, (int)list.size(), (String)(brokenAssertionMessagePrefix + " should be of size: " + expectedSize + " but is: " + list));
        return list;
    }

    public static void assertStringContains(String text, String containedText) {
        Assertions.assertNotNull((Object)text, (String)"Text should not be null!");
        Assertions.assertTrue((boolean)text.contains(containedText), (String)("Text: " + text + " does not contain: " + containedText));
    }

    public static void assertDirectoryEquals(String expected, String actual) {
        TestSupport.assertDirectoryEquals(null, expected, actual);
    }

    public static void assertDirectoryEquals(String message, String expected, String actual) {
        String expectedPath = expected.replace('\\', '/');
        String actualPath = actual.replace('\\', '/');
        if (message != null) {
            Assertions.assertEquals((Object)message, (Object)expectedPath, (String)actualPath);
        } else {
            Assertions.assertEquals((Object)expectedPath, (Object)actualPath);
        }
    }

    public static void assertDirectoryExists(String filename) {
        File file = new File(filename);
        Assertions.assertTrue((boolean)file.exists(), (String)("Directory " + filename + " should exist"));
        Assertions.assertTrue((boolean)file.isDirectory(), (String)("Directory " + filename + " should be a directory"));
    }

    public static void assertFileExists(String filename) {
        File file = new File(filename);
        Assertions.assertTrue((boolean)file.exists(), (String)("File " + filename + " should exist"));
        Assertions.assertTrue((boolean)file.isFile(), (String)("File " + filename + " should be a file"));
    }

    public static void assertFileNotExists(String filename) {
        File file = new File(filename);
        Assertions.assertFalse((boolean)file.exists(), (String)("File " + filename + " should not exist"));
    }

    public static Endpoint resolveMandatoryEndpoint(CamelContext context, String endpointUri) {
        Endpoint endpoint = context.getEndpoint(endpointUri);
        Assertions.assertNotNull((Object)endpoint, (String)("No endpoint found for URI: " + endpointUri));
        return endpoint;
    }

    public static <T extends Endpoint> T resolveMandatoryEndpoint(CamelContext context, String endpointUri, Class<T> endpointType) {
        Endpoint endpoint = context.getEndpoint(endpointUri, endpointType);
        Assertions.assertNotNull((Object)endpoint, (String)("No endpoint found for URI: " + endpointUri));
        return (T)endpoint;
    }

    public static Exchange createExchangeWithBody(CamelContext camelContext, Object body) {
        DefaultExchange exchange = new DefaultExchange(camelContext);
        Message message = exchange.getIn();
        message.setBody(body);
        return exchange;
    }

    public static List<Route> getRouteList(RouteBuilder builder) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)builder);
        context.start();
        List answer = context.getRoutes();
        context.stop();
        return answer;
    }

    public static boolean deleteDirectory(String file) {
        return TestSupport.deleteDirectory(new File(file));
    }

    public static boolean deleteDirectory(File file) {
        int tries = 0;
        int maxTries = 5;
        boolean exists = true;
        while (exists && tries < maxTries) {
            TestSupport.recursivelyDeleteDirectory(file);
            ++tries;
            exists = file.exists();
            if (!exists) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return !exists;
    }

    public static void recursivelyDeleteDirectory(File file) {
        boolean success;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                TestSupport.recursivelyDeleteDirectory(child);
            }
        }
        if (!(success = file.delete())) {
            LOG.warn("Deletion of file: " + file.getAbsolutePath() + " failed");
        }
    }

    public static void createDirectory(String file) {
        File dir = new File(file);
        dir.mkdirs();
    }

    public static boolean isPlatform(String expectedPlatform) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.contains(expectedPlatform.toLowerCase(Locale.US));
    }

    public static boolean isJavaVendor(String expectedVendor) {
        String javaVendor = System.getProperty("java.vendor").toLowerCase(Locale.US);
        return javaVendor.contains(expectedVendor.toLowerCase(Locale.US));
    }

    public static boolean isJava18() {
        return TestSupport.getJavaMajorVersion() == 8;
    }

    public static boolean isJava18_261_later() {
        boolean ret;
        String version = System.getProperty("java.version");
        try {
            ret = version != null && version.startsWith("1.8.0_") && Integer.parseInt(version.substring(6)) >= 261;
        }
        catch (NumberFormatException ex) {
            ret = false;
        }
        return ret;
    }

    public static boolean isJava19() {
        return TestSupport.getJavaMajorVersion() == 9;
    }

    public static int getJavaMajorVersion() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        if (javaSpecVersion.contains(".")) {
            return Integer.parseInt(javaSpecVersion.split("\\.")[1]);
        }
        return Integer.parseInt(javaSpecVersion);
    }
}

