/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LanguageBuilderFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Registry;
import org.apache.camel.test.junit5.AbstractTestSupport;
import org.apache.camel.test.junit5.CamelContextConfiguration;
import org.apache.camel.test.junit5.CamelContextManager;
import org.apache.camel.test.junit5.ContextManagerExtension;
import org.apache.camel.test.junit5.TestExecutionConfiguration;
import org.apache.camel.test.junit5.TestLoggerExtension;
import org.apache.camel.test.junit5.TestSupport;
import org.apache.camel.test.junit5.util.CamelContextTestHelper;
import org.apache.camel.test.junit5.util.ExtensionHelper;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CamelTestSupport
extends AbstractTestSupport
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final Logger LOG = LoggerFactory.getLogger(CamelTestSupport.class);
    @RegisterExtension
    @Order(value=10)
    protected TestLoggerExtension testLoggerExtension = new TestLoggerExtension();
    @RegisterExtension
    protected CamelTestSupport camelTestSupportExtension = this;
    private final StopWatch watch = new StopWatch();
    @RegisterExtension
    @Order(value=1)
    public final ContextManagerExtension contextManagerExtension;
    private CamelContextManager contextManager;

    protected CamelTestSupport() {
        super(new TestExecutionConfiguration(), new CamelContextConfiguration());
        this.configureTest(this.testConfigurationBuilder);
        this.configureContext(this.camelContextConfiguration);
        this.contextManagerExtension = new ContextManagerExtension(this.testConfigurationBuilder, this.camelContextConfiguration);
    }

    @Override
    public void configureContext(CamelContextConfiguration camelContextConfiguration) {
        camelContextConfiguration.withCamelContextSupplier(this::createCamelContext).withRegistryBinder(this::bindToRegistry).withPostProcessor(this::postProcessTest).withRoutesSupplier(this::createRouteBuilders).withUseOverridePropertiesWithPropertiesComponent(this.useOverridePropertiesWithPropertiesComponent()).withRouteFilterExcludePattern(this.getRouteFilterExcludePattern()).withRouteFilterIncludePattern(this.getRouteFilterIncludePattern()).withMockEndpoints(this.isMockEndpoints()).withMockEndpointsAndSkip(this.isMockEndpointsAndSkip());
    }

    @Override
    public void configureTest(TestExecutionConfiguration testExecutionConfiguration) {
        testExecutionConfiguration.withJMX(this.useJmx()).withUseRouteBuilder(this.isUseRouteBuilder()).withUseAdviceWith(this.isUseAdviceWith()).withDumpRouteCoverage(this.isDumpRouteCoverage());
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        this.watch.taken();
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        LOG.trace("Before test execution {}", (Object)context.getDisplayName());
        this.watch.restart();
    }

    @Deprecated(since="4.7.0")
    public long timeTaken() {
        return this.watch.taken();
    }

    @Deprecated(since="4.7.0")
    public final String getCurrentTestName() {
        return this.contextManagerExtension.getCurrentTestName();
    }

    @Deprecated(since="4.7.0")
    @BeforeEach
    public final void setUp() throws Exception {
        this.unsupportedCheck();
        this.setupResources();
        this.doPreSetup();
        this.contextManager = this.contextManagerExtension.getContextManager();
        this.contextManager.createCamelContext(this);
        this.context = this.contextManager.context();
        this.doPostSetup();
        this.watch.restart();
    }

    @Deprecated(since="4.7.0")
    protected void doPreSetup() throws Exception {
    }

    @Deprecated(since="4.7.0")
    protected void doPostSetup() throws Exception {
    }

    @Deprecated(since="4.7.0")
    protected void doSpringBootCheck() {
        boolean springBoot = ExtensionHelper.hasClassAnnotation(this.getClass(), "org.springframework.boot.test.context.SpringBootTest");
        if (springBoot) {
            throw new RuntimeException("Spring Boot detected: The CamelTestSupport/CamelSpringTestSupport class is not intended for Camel testing with Spring Boot.");
        }
    }

    @Deprecated(since="4.7.0")
    protected void doQuarkusCheck() {
        boolean quarkus = ExtensionHelper.hasClassAnnotation(this.getClass(), "io.quarkus.test.junit.QuarkusTest", "org.apache.camel.quarkus.test.CamelQuarkusTest");
        if (quarkus) {
            throw new RuntimeException("Quarkus detected: The CamelTestSupport/CamelSpringTestSupport class is not intended for Camel testing with Quarkus.");
        }
    }

    @Deprecated(since="4.7.0")
    protected void unsupportedCheck() {
        ExtensionHelper.hasUnsupported(this.getClass());
    }

    @Deprecated(since="4.7.0")
    protected final void doSetUp() throws Exception {
        throw new UnsupportedOperationException("Do not use the doSetUp method");
    }

    @Deprecated(since="4.7.0")
    @AfterEach
    public final void tearDown(TestInfo testInfo) throws Exception {
        long time = this.watch.taken();
        LOG.debug("tearDown()");
        if (this.contextManager != null) {
            this.contextManager.dumpRouteCoverage(this.getClass(), testInfo.getDisplayName(), time);
        } else {
            LOG.warn("A context manager is required to dump the route coverage for the Camel context but it's not available (it's null). It's likely that the test is misconfigured!");
        }
        this.doPostTearDown();
        this.cleanupResources();
    }

    @Deprecated(since="4.7.0")
    protected void doPostTearDown() throws Exception {
    }

    @Deprecated(since="4.7.0")
    protected int getShutdownTimeout() {
        return this.camelContextConfiguration.shutdownTimeout();
    }

    @Deprecated(since="4.7.0")
    protected void postProcessTest() throws Exception {
        this.context = this.contextManager.context();
        this.template = this.contextManager.template();
        this.fluentTemplate = this.contextManager.fluentTemplate();
        this.consumer = this.contextManager.consumer();
    }

    @Deprecated(since="4.7.0")
    protected void applyCamelPostProcessor() throws Exception {
    }

    @Deprecated
    protected boolean hasClassAnnotation(String ... names) {
        return ExtensionHelper.hasClassAnnotation(this.getClass(), names);
    }

    @Deprecated(since="4.7.0")
    protected void stopCamelContext() throws Exception {
        this.contextManager.stopCamelContext();
    }

    @Deprecated(since="4.7.0")
    protected void startCamelContext() throws Exception {
        this.contextManager.startCamelContext();
    }

    protected CamelContext createCamelContext() throws Exception {
        return CamelContextTestHelper.createCamelContext(this.createCamelRegistry());
    }

    protected void bindToRegistry(Registry registry) throws Exception {
    }

    protected LanguageBuilderFactory expression() {
        return new LanguageBuilderFactory();
    }

    @Deprecated(since="4.7.0")
    protected Registry createCamelRegistry() throws Exception {
        return null;
    }

    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    @Deprecated(since="4.7.0")
    protected RoutesBuilder[] createRouteBuilders() throws Exception {
        return new RoutesBuilder[]{this.createRouteBuilder()};
    }

    @Deprecated(since="4.7.0")
    protected final Endpoint resolveMandatoryEndpoint(String uri) {
        return TestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri);
    }

    @Deprecated(since="4.7.0")
    protected final <T extends Endpoint> T resolveMandatoryEndpoint(String uri, Class<T> endpointType) {
        return TestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri, endpointType);
    }

    protected final MockEndpoint getMockEndpoint(String uri) {
        return this.getMockEndpoint(uri, true);
    }

    @Deprecated(since="4.7.0")
    protected final MockEndpoint getMockEndpoint(String uri, boolean create) throws NoSuchEndpointException {
        return TestSupport.getMockEndpoint((CamelContext)this.context, uri, create);
    }

    @Deprecated(since="4.7.0")
    protected final void sendBody(String endpointUri, Object body) {
        TestSupport.sendBody(this.template, endpointUri, body);
    }

    @Deprecated(since="4.7.0")
    protected final void sendBody(String endpointUri, Object body, Map<String, Object> headers) {
        TestSupport.sendBody(this.template, endpointUri, body, headers);
    }

    @Deprecated(since="4.7.0")
    protected final void sendBodies(String endpointUri, Object ... bodies) {
        TestSupport.sendBodies(this.template, endpointUri, bodies);
    }

    @Deprecated(since="4.7.0")
    protected final Exchange createExchangeWithBody(Object body) {
        return TestSupport.createExchangeWithBody((CamelContext)this.context, body);
    }

    @Deprecated(since="4.7.0")
    protected final void assertExpression(Exchange exchange, String languageName, String expressionText, Object expectedValue) {
        TestSupport.assertExpression((CamelContext)this.context, exchange, languageName, expressionText, expectedValue);
    }

    @Deprecated(since="4.7.0")
    protected final void assertPredicate(String languageName, String expressionText, Exchange exchange, boolean expected) {
        TestSupport.assertPredicate((CamelContext)this.context, languageName, expressionText, exchange, expected);
    }

    @Deprecated(since="4.7.0")
    protected final Language assertResolveLanguage(String languageName) {
        return TestSupport.assertResolveLanguage((CamelContext)this.context, languageName);
    }

    @Deprecated(since="4.7.0")
    protected final void assertValidContext(CamelContext context) {
        Assertions.assertNotNull((Object)context, (String)"No context found!");
    }

    protected final <T extends Endpoint> T getMandatoryEndpoint(String uri, Class<T> type) {
        return TestSupport.getMandatoryEndpoint(this.context(), uri, type);
    }

    protected final Endpoint getMandatoryEndpoint(String uri) {
        return TestSupport.getMandatoryEndpoint(this.context(), uri);
    }

    @Deprecated(since="4.7.0")
    protected void debugBefore(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, String id, String label) {
    }

    @Deprecated(since="4.7.0")
    protected void debugAfter(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, String id, String label, long timeTaken) {
    }
}

