/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring.junit5;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RouteCoverageDumper {
    private static final Logger LOG = LoggerFactory.getLogger(RouteCoverageDumper.class);

    private RouteCoverageDumper() {
    }

    public static void dumpRouteCoverage(CamelContext context, String testClassName, String testName) {
        try {
            String dir = "target/camel-route-coverage";
            String name = testClassName + "-" + testName + ".xml";
            ManagedCamelContext managedCamelContext = (ManagedCamelContext)context.getExtension(ManagedCamelContext.class);
            if (managedCamelContext == null) {
                LOG.warn("Cannot dump route coverage to file as JMX is not enabled. Ensure camel-management JAR is on classpath (can be test scope). Override useJmx() method to enable JMX in the unit test classes. Or when using Spring you can add the @EnableRouteCoverage annotation to the test classes.");
            } else {
                ManagedCamelContextMBean mBean = managedCamelContext.getManagedCamelContext();
                String xml = mBean.dumpRoutesCoverageAsXml();
                String combined = "<camelRouteCoverage>\n" + RouteCoverageDumper.gatherTestDetailsAsXml(testClassName, testName) + xml + "\n</camelRouteCoverage>";
                File file = new File(dir);
                boolean result = file.mkdirs();
                if (!result) {
                    LOG.error("mkdirs() failed for " + file);
                }
                file = new File(dir, name);
                LOG.info("Dumping route coverage to file: {}", (Object)file);
                ByteArrayInputStream is = new ByteArrayInputStream(combined.getBytes());
                FileOutputStream os = new FileOutputStream(file, false);
                IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)os);
                IOHelper.close((Closeable)os);
            }
        }
        catch (Exception e) {
            LOG.warn("Error during dumping route coverage statistic. This exception is ignored.", (Throwable)e);
        }
    }

    private static String gatherTestDetailsAsXml(String testClassName, String testName) {
        StringBuilder sb = new StringBuilder();
        sb.append("<test>\n");
        sb.append("  <class>").append(testClassName).append("</class>\n");
        sb.append("  <method>").append(testName).append("</method>\n");
        sb.append("</test>\n");
        return sb.toString();
    }
}

