/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.management.event.CamelContextStoppingEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteCoverageEventNotifier
extends EventNotifierSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RouteCoverageEventNotifier.class);
    private final String testClassName;
    private final Function testMethodName;

    public RouteCoverageEventNotifier(String testClassName, Function testMethodName) {
        this.testClassName = testClassName;
        this.testMethodName = testMethodName;
        this.setIgnoreCamelContextEvents(false);
        this.setIgnoreExchangeEvents(true);
    }

    public boolean isEnabled(EventObject event) {
        return event instanceof CamelContextStoppingEvent;
    }

    public void notify(EventObject event) throws Exception {
        CamelContext context = ((CamelContextStoppingEvent)event).getContext();
        try {
            String className = ((Object)((Object)this)).getClass().getSimpleName();
            String dir = "target/camel-route-coverage";
            String testName = (String)this.testMethodName.apply(this);
            String name = className + "-" + testName + ".xml";
            ManagedCamelContextMBean managedCamelContext = context.getManagedCamelContext();
            if (managedCamelContext == null) {
                LOG.warn("Cannot dump route coverage to file as JMX is not enabled. Override useJmx() method to enable JMX in the unit test classes.");
            } else {
                String xml = managedCamelContext.dumpRoutesCoverageAsXml();
                String combined = "<camelRouteCoverage>\n" + this.gatherTestDetailsAsXml(testName) + xml + "\n</camelRouteCoverage>";
                File file = new File(dir);
                file.mkdirs();
                file = new File(dir, name);
                LOG.info("Dumping route coverage to file: " + file);
                ByteArrayInputStream is = new ByteArrayInputStream(combined.getBytes());
                FileOutputStream os = new FileOutputStream(file, false);
                IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)os);
                IOHelper.close((Closeable)os);
            }
        }
        catch (Exception e) {
            LOG.warn("Error during dumping route coverage statistic. This exception is ignored.", (Throwable)e);
        }
    }

    private String gatherTestDetailsAsXml(String testName) {
        StringBuilder sb = new StringBuilder();
        sb.append("<test>\n");
        sb.append("  <class>").append(this.testClassName).append("</class>\n");
        sb.append("  <method>").append(testName).append("</method>\n");
        sb.append("</test>\n");
        return sb.toString();
    }
}

