/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit4;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.camel.CamelContext;
import org.apache.camel.Channel;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.PredicateAssertHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestSupport
extends Assert {
    protected static final String LS = System.getProperty("line.separator");
    private static final Logger LOG = LoggerFactory.getLogger(TestSupport.class);
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Rule
    public TestName testName = new TestName();

    public static ValueBuilder header(String name) {
        return Builder.header((String)name);
    }

    public static ValueBuilder property(String name) {
        return Builder.property((String)name);
    }

    public static ValueBuilder body() {
        return Builder.body();
    }

    public static <T> ValueBuilder bodyAs(Class<T> type) {
        return Builder.bodyAs(type);
    }

    public static ValueBuilder outBody() {
        return Builder.outBody();
    }

    public static <T> ValueBuilder outBodyAs(Class<T> type) {
        return Builder.outBodyAs(type);
    }

    public static ValueBuilder faultBody() {
        return Builder.faultBody();
    }

    public static <T> ValueBuilder faultBodyAs(Class<T> type) {
        return Builder.faultBodyAs(type);
    }

    public static ValueBuilder systemProperty(String name) {
        return Builder.systemProperty((String)name);
    }

    public static ValueBuilder systemProperty(String name, String defaultValue) {
        return Builder.systemProperty((String)name, (String)defaultValue);
    }

    public static <T> T assertIsInstanceOf(Class<T> expectedType, Object value) {
        TestSupport.assertNotNull((String)("Expected an instance of type: " + expectedType.getName() + " but was null"), (Object)value);
        TestSupport.assertTrue((String)("object should be a " + expectedType.getName() + " but was: " + value + " with type: " + value.getClass().getName()), (boolean)expectedType.isInstance(value));
        return expectedType.cast(value);
    }

    public static void assertEndpointUri(Endpoint endpoint, String uri) {
        TestSupport.assertNotNull((String)("Endpoint is null when expecting endpoint for: " + uri), (Object)endpoint);
        TestSupport.assertEquals((String)("Endpoint uri for: " + endpoint), (Object)uri, (Object)endpoint.getEndpointUri());
    }

    public static Object assertInMessageHeader(Exchange exchange, String name, Object expected) {
        return TestSupport.assertMessageHeader(exchange.getIn(), name, expected);
    }

    public static Object assertOutMessageHeader(Exchange exchange, String name, Object expected) {
        return TestSupport.assertMessageHeader(exchange.getOut(), name, expected);
    }

    public static void assertInMessageBodyEquals(Exchange exchange, Object expected) throws InvalidPayloadException {
        Object actual;
        TestSupport.assertNotNull((String)"Should have a response exchange!", (Object)exchange);
        if (expected == null) {
            actual = exchange.getIn().getMandatoryBody();
            TestSupport.assertEquals((String)("in body of: " + exchange), (Object)expected, (Object)actual);
        } else {
            actual = exchange.getIn().getMandatoryBody(expected.getClass());
        }
        TestSupport.assertEquals((String)("in body of: " + exchange), (Object)expected, (Object)actual);
        LOG.debug("Received response: " + exchange + " with in: " + exchange.getIn());
    }

    public static void assertOutMessageBodyEquals(Exchange exchange, Object expected) throws InvalidPayloadException {
        Object actual;
        TestSupport.assertNotNull((String)"Should have a response exchange!", (Object)exchange);
        if (expected == null) {
            actual = exchange.getOut().getMandatoryBody();
            TestSupport.assertEquals((String)("output body of: " + exchange), (Object)expected, (Object)actual);
        } else {
            actual = exchange.getOut().getMandatoryBody(expected.getClass());
        }
        TestSupport.assertEquals((String)("output body of: " + exchange), (Object)expected, (Object)actual);
        LOG.debug("Received response: " + exchange + " with out: " + exchange.getOut());
    }

    public static Object assertMessageHeader(Message message, String name, Object expected) {
        Object value = message.getHeader(name);
        TestSupport.assertEquals((String)("Header: " + name + " on Message: " + message), (Object)expected, (Object)value);
        return value;
    }

    public static Object assertExpression(Expression expression, Exchange exchange, Object expected) {
        Object value = expected != null ? expression.evaluate(exchange, expected.getClass()) : expression.evaluate(exchange, Object.class);
        LOG.debug("Evaluated expression: " + expression + " on exchange: " + exchange + " result: " + value);
        TestSupport.assertEquals((String)("Expression: " + expression + " on Exchange: " + exchange), (Object)expected, (Object)value);
        return value;
    }

    public static void assertPredicateMatches(Predicate predicate, Exchange exchange) {
        TestSupport.assertPredicate(predicate, exchange, true);
    }

    public static void assertPredicateDoesNotMatch(Predicate predicate, Exchange exchange) {
        try {
            PredicateAssertHelper.assertMatches((Predicate)predicate, (String)"Predicate should match: ", (Exchange)exchange);
        }
        catch (AssertionError e) {
            LOG.debug("Caught expected assertion error: " + e);
        }
        TestSupport.assertPredicate(predicate, exchange, false);
    }

    public static boolean assertPredicate(Predicate predicate, Exchange exchange, boolean expected) {
        if (expected) {
            PredicateAssertHelper.assertMatches((Predicate)predicate, (String)"Predicate failed: ", (Exchange)exchange);
        }
        boolean value = predicate.matches(exchange);
        LOG.debug("Evaluated predicate: " + predicate + " on exchange: " + exchange + " result: " + value);
        TestSupport.assertEquals((String)("Predicate: " + predicate + " on Exchange: " + exchange), (Object)expected, (Object)value);
        return value;
    }

    public static Endpoint resolveMandatoryEndpoint(CamelContext context, String uri) {
        Endpoint endpoint = context.getEndpoint(uri);
        TestSupport.assertNotNull((String)("No endpoint found for URI: " + uri), (Object)endpoint);
        return endpoint;
    }

    public static <T extends Endpoint> T resolveMandatoryEndpoint(CamelContext context, String uri, Class<T> endpointType) {
        Endpoint endpoint = context.getEndpoint(uri, endpointType);
        TestSupport.assertNotNull((String)("No endpoint found for URI: " + uri), (Object)endpoint);
        return (T)endpoint;
    }

    protected Exchange createExchangeWithBody(CamelContext camelContext, Object body) {
        DefaultExchange exchange = new DefaultExchange(camelContext);
        Message message = exchange.getIn();
        message.setHeader("testClass", (Object)((Object)((Object)this)).getClass().getName());
        message.setBody(body);
        return exchange;
    }

    public static <T> T assertOneElement(List<T> list) {
        TestSupport.assertEquals((String)("Size of list should be 1: " + list), (long)1L, (long)list.size());
        return list.get(0);
    }

    public static <T> List<T> assertListSize(List<T> list, int size) {
        return TestSupport.assertListSize("List", list, size);
    }

    public static <T> List<T> assertListSize(String message, List<T> list, int size) {
        TestSupport.assertEquals((String)(message + " should be of size: " + size + " but is: " + list), (long)size, (long)list.size());
        return list;
    }

    public static <T> Collection<T> assertCollectionSize(Collection<T> list, int size) {
        return TestSupport.assertCollectionSize("List", list, size);
    }

    public static <T> Collection<T> assertCollectionSize(String message, Collection<T> list, int size) {
        TestSupport.assertEquals((String)(message + " should be of size: " + size + " but is: " + list), (long)size, (long)list.size());
        return list;
    }

    public static List<Route> getRouteList(RouteBuilder builder) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)builder);
        context.start();
        List answer = context.getRoutes();
        context.stop();
        return answer;
    }

    public static void assertStringContains(String text, String containedText) {
        TestSupport.assertNotNull((String)"Text should not be null!", (Object)text);
        TestSupport.assertTrue((String)("Text: " + text + " does not contain: " + containedText), (boolean)text.contains(containedText));
    }

    @Deprecated
    public static Processor unwrap(Processor processor) {
        while (processor instanceof DelegateProcessor) {
            processor = ((DelegateProcessor)processor).getProcessor();
        }
        return processor;
    }

    @Deprecated
    public static Channel unwrapChannel(Processor processor) {
        while (true) {
            if (processor instanceof Channel) {
                return (Channel)processor;
            }
            if (!(processor instanceof DelegateProcessor)) break;
            processor = ((DelegateProcessor)processor).getProcessor();
        }
        return null;
    }

    public static boolean deleteDirectory(String file) {
        return TestSupport.deleteDirectory(new File(file));
    }

    public static boolean deleteDirectory(File file) {
        int tries = 0;
        int maxTries = 5;
        boolean exists = true;
        while (exists && tries < maxTries) {
            TestSupport.recursivelyDeleteDirectory(file);
            ++tries;
            exists = file.exists();
            if (!exists) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        return !exists;
    }

    private static void recursivelyDeleteDirectory(File file) {
        boolean success;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                TestSupport.recursivelyDeleteDirectory(child);
            }
        }
        if (!(success = file.delete())) {
            LOG.warn("Deletion of file: " + file.getAbsolutePath() + " failed");
        }
    }

    public static void createDirectory(String file) {
        File dir = new File(file);
        dir.mkdirs();
    }

    public static void assertDirectoryEquals(String expected, String actual) {
        TestSupport.assertDirectoryEquals(null, expected, actual);
    }

    public static void assertDirectoryEquals(String message, String expected, String actual) {
        String expectedPath = expected.replace('\\', '/');
        String actualPath = actual.replace('\\', '/');
        if (message != null) {
            TestSupport.assertEquals((String)message, (Object)expectedPath, (Object)actualPath);
        } else {
            TestSupport.assertEquals((Object)expectedPath, (Object)actualPath);
        }
    }

    public static void assertFileExists(String filename) {
        File file = new File(filename);
        TestSupport.assertTrue((String)("File " + filename + " should exist"), (boolean)file.exists());
    }

    public static void assertFileNotExists(String filename) {
        File file = new File(filename);
        TestSupport.assertFalse((String)("File " + filename + " should not exist"), (boolean)file.exists());
    }

    public static boolean isPlatform(String platform) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf(platform.toLowerCase(Locale.US)) > -1;
    }

    public static boolean isJavaVendor(String vendor) {
        String javaVendor = System.getProperty("java.vendor").toLowerCase(Locale.US);
        return javaVendor.indexOf(vendor.toLowerCase(Locale.US)) > -1;
    }

    @Deprecated
    public static boolean isJava15() {
        String javaVersion = System.getProperty("java.version").toLowerCase(Locale.US);
        return javaVersion.startsWith("1.5");
    }

    public static boolean isJava16() {
        String javaVersion = System.getProperty("java.version").toLowerCase(Locale.US);
        return javaVersion.startsWith("1.6");
    }

    public static boolean isJava17() {
        String javaVersion = System.getProperty("java.version").toLowerCase(Locale.US);
        return javaVersion.startsWith("1.7");
    }

    public static boolean isJava18() {
        String javaVersion = System.getProperty("java.version").toLowerCase(Locale.US);
        return javaVersion.startsWith("1.8");
    }

    public String getTestMethodName() {
        return this.testName.getMethodName();
    }
}

