/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util.srcgen;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.tooling.util.srcgen.Annotation;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.camel.tooling.util.srcgen.Javadoc;
import org.apache.camel.tooling.util.srcgen.Param;

public class Method {
    String name;
    GenericType returnType;
    String returnTypeLiteral;
    boolean isDefault;
    boolean isPublic;
    boolean isProtected;
    boolean isPrivate;
    boolean isStatic;
    boolean isConstructor;
    boolean isAbstract;
    String signature;
    String body;
    List<Param> parameters = new ArrayList<Param>();
    List<String> exceptions = new ArrayList<String>();
    List<Annotation> annotations = new ArrayList<Annotation>();
    Javadoc javadoc = new Javadoc();

    public Method setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public Method setPublic() {
        this.isPublic = true;
        this.isProtected = false;
        this.isPrivate = false;
        return this;
    }

    public Method setProtected() {
        this.isPublic = false;
        this.isProtected = true;
        this.isPrivate = false;
        return this;
    }

    public Method setPrivate() {
        this.isPublic = false;
        this.isProtected = false;
        this.isPrivate = true;
        return this;
    }

    public Method setStatic() {
        this.isStatic = true;
        this.isDefault = false;
        return this;
    }

    public Method setDefault() {
        this.isDefault = true;
        this.isStatic = false;
        return this;
    }

    public Method setAbstract() {
        this.isAbstract = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Method setName(String name) {
        this.name = name;
        return this;
    }

    public String getReturnTypeLiteral() {
        return this.returnTypeLiteral;
    }

    public GenericType getReturnType() {
        return this.returnType;
    }

    public Method setReturnType(Type returnType) {
        return this.setReturnType(new GenericType(returnType));
    }

    public Method setReturnType(GenericType returnType) {
        this.returnType = returnType;
        return this;
    }

    public Method setReturnType(String returnType) {
        this.returnType = null;
        this.returnTypeLiteral = returnType;
        return this;
    }

    public Method addParameter(String type, String name) {
        return this.addParameter(type, name, false);
    }

    public Method addParameter(String type, String name, boolean vararg) {
        this.parameters.add(new Param(type, name, vararg));
        return this;
    }

    public Method addParameter(Class<?> type, String name) {
        return this.addParameter(new GenericType(type), name);
    }

    public Method addParameter(Class<?> type, String name, boolean vararg) {
        return this.addParameter(new GenericType(type), name, vararg);
    }

    public Method addParameter(GenericType type, String name) {
        this.parameters.add(new Param(type, name));
        return this;
    }

    public Method addParameter(GenericType type, String name, boolean vararg) {
        this.parameters.add(new Param(type, name, vararg));
        return this;
    }

    public List<Param> getParameters() {
        return this.parameters;
    }

    public List<String> getParametersNames() {
        return this.parameters.stream().map(Param::getName).collect(Collectors.toList());
    }

    public String getBody() {
        return this.body;
    }

    public Method setBody(String body) {
        this.body = body;
        return this;
    }

    public Method setBodyF(String format, Object ... args) {
        this.body = String.format(format, args);
        return this;
    }

    public Method setBody(String ... statements) {
        this.body = Stream.of(statements).collect(Collectors.joining("\n"));
        return this;
    }

    public Method addThrows(Class<?> type) {
        return this.addThrows(new GenericType(type));
    }

    public Method addThrows(GenericType type) {
        return this.addThrows(type.toString());
    }

    public Method addThrows(String type) {
        this.exceptions.add(type);
        return this;
    }

    public Annotation addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        Annotation ann = new Annotation(clazz);
        this.annotations.add(ann);
        return ann;
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.stream().map(Annotation::getType).anyMatch(clazz::equals);
    }

    public Annotation getAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.stream().filter(a -> Objects.equals(a.getType(), clazz)).findAny().orElse(null);
    }

    public Javadoc getJavaDoc() {
        return this.javadoc;
    }

    public Method setConstructor(boolean cns) {
        this.isConstructor = cns;
        return this;
    }

    public boolean hasJavaDoc() {
        return this.javadoc.text != null;
    }

    public Method copy() {
        Method m = new Method();
        m.name = this.name;
        m.returnType = this.returnType;
        m.isDefault = this.isDefault;
        m.isPublic = this.isPublic;
        m.isProtected = this.isProtected;
        m.isPrivate = this.isPrivate;
        m.isStatic = this.isStatic;
        m.isConstructor = this.isConstructor;
        m.isAbstract = this.isAbstract;
        m.signature = this.signature;
        m.body = this.body;
        m.javadoc = this.javadoc;
        m.parameters = new ArrayList<Param>(this.parameters);
        m.exceptions = new ArrayList<String>(this.exceptions);
        m.annotations = new ArrayList<Annotation>(this.annotations);
        return m;
    }
}

