/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.undertow.UndertowClientCallback;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHelper;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.http.common.cookie.CookieHandler;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class UndertowProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowProducer.class);
    private UndertowClient client;
    private final UndertowEndpoint endpoint;
    private final OptionMap options;
    private DefaultByteBufferPool pool;
    private XnioSsl ssl;
    private XnioWorker worker;

    public UndertowProducer(UndertowEndpoint endpoint, OptionMap options) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.options = options;
    }

    public UndertowEndpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean process(Exchange camelExchange, AsyncCallback callback) {
        Map cookieHeaders;
        HttpString method;
        URI uri;
        try {
            String exchangeUri = UndertowHelper.createURL(camelExchange, this.getEndpoint());
            uri = UndertowHelper.createURI(camelExchange, exchangeUri, this.getEndpoint());
            method = UndertowHelper.createMethod(camelExchange, this.endpoint, camelExchange.getIn().getBody() != null);
        }
        catch (URISyntaxException e) {
            camelExchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        String pathAndQuery = URISupport.pathAndQueryOf((URI)uri);
        UndertowHttpBinding undertowHttpBinding = this.endpoint.getUndertowHttpBinding();
        CookieHandler cookieHandler = this.endpoint.getCookieHandler();
        if (cookieHandler != null) {
            try {
                cookieHeaders = cookieHandler.loadCookies(camelExchange, uri);
            }
            catch (IOException e) {
                camelExchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
        } else {
            cookieHeaders = Collections.emptyMap();
        }
        ClientRequest request = new ClientRequest();
        request.setMethod(method);
        request.setPath(pathAndQuery);
        HeaderMap requestHeaders = request.getRequestHeaders();
        Message message = camelExchange.getIn();
        String host = (String)message.getHeader("Host", String.class);
        requestHeaders.put(Headers.HOST, Optional.ofNullable(host).orElseGet(() -> uri.getAuthority()));
        Object body = undertowHttpBinding.toHttpRequest(request, camelExchange.getIn());
        TypeConverter tc = this.endpoint.getCamelContext().getTypeConverter();
        ByteBuffer bodyAsByte = (ByteBuffer)tc.tryConvertTo(ByteBuffer.class, body);
        if (body != null && bodyAsByte != null) {
            requestHeaders.put(Headers.CONTENT_LENGTH, (long)bodyAsByte.remaining());
        }
        for (Map.Entry entry : cookieHeaders.entrySet()) {
            requestHeaders.putAll(HttpString.tryFromString((String)((String)entry.getKey())), (Collection)entry.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing http {} method: {}", (Object)method, (Object)pathAndQuery);
        }
        UndertowClientCallback clientCallback = new UndertowClientCallback(camelExchange, callback, this.getEndpoint(), request, bodyAsByte);
        this.client.connect((ClientCallback)clientCallback, uri, this.worker, this.ssl, (ByteBufferPool)this.pool, this.options);
        return false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.pool = new DefaultByteBufferPool(true, 17408);
        Xnio xnio = Xnio.getInstance();
        this.worker = xnio.createWorker(this.options);
        SSLContext sslContext = this.getEndpoint().getSslContext();
        if (sslContext != null) {
            this.ssl = new UndertowXnioSsl(xnio, this.options, sslContext);
        }
        CamelContext camelContext = this.getEndpoint().getCamelContext();
        this.client = UndertowClient.getInstance((ClassLoader)camelContext.getApplicationContextClassLoader());
        LOG.debug("Created worker: {} with options: {}", (Object)this.worker, (Object)this.options);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.worker != null && !this.worker.isShutdown()) {
            LOG.debug("Shutting down worker: {}", (Object)this.worker);
            this.worker.shutdown();
        }
    }
}

