/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.undertow.DefaultUndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowEndpoint;

public class RestUndertowHttpBinding
extends DefaultUndertowHttpBinding {
    @Override
    public void populateCamelHeaders(HttpServerExchange httpExchange, Map<String, Object> headersMap, Exchange exchange) throws Exception {
        super.populateCamelHeaders(httpExchange, headersMap, exchange);
        String path = httpExchange.getRequestPath();
        if (path == null) {
            return;
        }
        UndertowEndpoint endpoint = (UndertowEndpoint)exchange.getFromEndpoint();
        String consumerPath = endpoint.getHttpURI().getPath();
        if (this.useRestMatching(consumerPath)) {
            String[] paths = path.split("/");
            String[] consumerPaths = consumerPath.split("/");
            for (int i = 0; i < consumerPaths.length && paths.length >= i; ++i) {
                String p1 = consumerPaths[i];
                if (!p1.startsWith("{") || !p1.endsWith("}")) continue;
                String key = p1.substring(1, p1.length() - 1);
                String value = paths[i];
                if (value == null) continue;
                headersMap.put(key, value);
            }
        }
    }

    private boolean useRestMatching(String path) {
        return path.indexOf(123) > -1;
    }
}

