/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.xml.jaxb;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.support.RouteBuilderLoaderSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.xml.jaxb.JaxbHelper;

@ManagedResource(description="Managed JAXB XML RoutesBuilderLoader")
@RoutesLoader(value="xml")
public class JaxbXmlRoutesBuilderLoader
extends RouteBuilderLoaderSupport {
    public static final String EXTENSION = "xml";

    public JaxbXmlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    public RouteBuilder doLoadRouteBuilder(final Resource resource) throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                try (InputStream is = resource.getInputStream();){
                    RouteTemplatesDefinition templates = JaxbHelper.loadRouteTemplatesDefinition((CamelContext)this.getCamelContext(), (InputStream)is);
                    if (templates != null) {
                        this.setRouteTemplateCollection(templates);
                    }
                }
                is = resource.getInputStream();
                var2_2 = null;
                try {
                    RestsDefinition rests = JaxbHelper.loadRestsDefinition((CamelContext)this.getCamelContext(), (InputStream)is);
                    if (rests != null) {
                        this.setRestCollection(rests);
                    }
                }
                catch (Throwable rests) {
                    var2_2 = rests;
                    throw rests;
                }
                finally {
                    if (is != null) {
                        if (var2_2 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable rests) {
                                var2_2.addSuppressed(rests);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
                is = resource.getInputStream();
                var2_2 = null;
                try {
                    RoutesDefinition routes = JaxbHelper.loadRoutesDefinition((CamelContext)this.getCamelContext(), (InputStream)is);
                    if (routes != null) {
                        CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                        for (RouteDefinition route : routes.getRoutes()) {
                            this.getRouteCollection().route(route);
                        }
                    }
                }
                catch (Throwable throwable) {
                    var2_2 = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (var2_2 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                var2_2.addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
        };
    }
}

