/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.TypeConvertible;
import org.apache.camel.converter.jaxp.DomConverter;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.xml.BytesSource;
import org.apache.camel.util.xml.StreamSourceConverter;
import org.apache.camel.util.xml.StringSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@DeferredContextBinding
public final class CamelXmlJaxpBulkConverterLoader
implements TypeConverterLoader,
BulkTypeConverters,
CamelContextAware {
    private CamelContext camelContext;
    private volatile DomConverter domConverter;
    private volatile StaxConverter staxConverter;
    private volatile XmlConverter xmlConverter;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public int size() {
        return 95;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addBulkTypeConverters((BulkTypeConverters)this);
        this.doRegistration(registry);
    }

    public <T> T convertTo(Class<?> from, Class<T> to, Exchange exchange, Object value) throws TypeConversionException {
        try {
            Object obj = this.doConvertTo(from, to, exchange, value);
            if (obj == Void.class) {
                return null;
            }
            return (T)obj;
        }
        catch (TypeConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeConversionException(value, to, (Throwable)e);
        }
    }

    private Object doConvertTo(Class<?> from, Class<?> to, Exchange exchange, Object value) throws Exception {
        if (to == byte[].class) {
            if (value instanceof NodeList) {
                return this.getDomConverter().toByteArray((NodeList)value, exchange);
            }
            if (value instanceof Source) {
                return this.getXmlConverter().toByteArray((Source)value, exchange);
            }
        } else if (to == InputStream.class) {
            if (value instanceof NodeList) {
                return this.getDomConverter().toInputStream((NodeList)value, exchange);
            }
            if (value instanceof XMLStreamReader) {
                return this.getStaxConverter().createInputStream((XMLStreamReader)value, exchange);
            }
            if (value instanceof DOMSource) {
                return this.getXmlConverter().toInputStream((DOMSource)value, exchange);
            }
            if (value instanceof Document) {
                return this.getXmlConverter().toInputStream((Document)value, exchange);
            }
            if (value instanceof StreamSource) {
                return this.getXmlConverter().toInputStream((StreamSource)value);
            }
        } else if (to == Reader.class) {
            if (value instanceof XMLStreamReader) {
                return this.getStaxConverter().createReader((XMLStreamReader)value, exchange);
            }
            if (value instanceof StreamSource) {
                return this.getXmlConverter().toReader((StreamSource)value);
            }
            if (value instanceof Source) {
                return this.getXmlConverter().toReaderFromSource((Source)value, exchange);
            }
        } else if (to == Serializable.class) {
            if (value instanceof StreamCache) {
                return StreamSourceConverter.convertToSerializable((StreamCache)value, exchange);
            }
        } else if (to == Boolean.class || to == Boolean.TYPE) {
            if (value instanceof NodeList) {
                return this.getXmlConverter().toBoolean((NodeList)value);
            }
        } else if (to == Integer.class || to == Integer.TYPE) {
            if (value instanceof NodeList) {
                return DomConverter.toInteger((NodeList)value);
            }
        } else if (to == Long.class || to == Long.TYPE) {
            if (value instanceof NodeList) {
                return DomConverter.toLong((NodeList)value);
            }
        } else if (to == String.class) {
            if (value instanceof NodeList) {
                return this.getDomConverter().toString((NodeList)value, exchange);
            }
            if (value instanceof Node) {
                return this.getDomConverter().toString((Node)value, exchange);
            }
            if (value instanceof Source) {
                return this.getXmlConverter().toString((Source)value, exchange);
            }
        } else if (to == List.class) {
            if (value instanceof NodeList) {
                return DomConverter.toList((NodeList)value);
            }
        } else if (to == QName.class) {
            if (value instanceof String) {
                return this.getXmlConverter().toQName((String)value);
            }
        } else if (to == XMLEventReader.class) {
            if (value instanceof InputStream) {
                return this.getStaxConverter().createXMLEventReader((InputStream)value, exchange);
            }
            if (value instanceof File) {
                return this.getStaxConverter().createXMLEventReader((File)value, exchange);
            }
            if (value instanceof Reader) {
                return this.getStaxConverter().createXMLEventReader((Reader)value);
            }
            if (value instanceof XMLStreamReader) {
                return this.getStaxConverter().createXMLEventReader((XMLStreamReader)value);
            }
            if (value instanceof Source) {
                return this.getStaxConverter().createXMLEventReader((Source)value);
            }
        } else if (to == XMLEventWriter.class) {
            if (value instanceof OutputStream) {
                return this.getStaxConverter().createXMLEventWriter((OutputStream)value, exchange);
            }
            if (value instanceof Writer) {
                return this.getStaxConverter().createXMLEventWriter((Writer)value);
            }
            if (value instanceof Result) {
                return this.getStaxConverter().createXMLEventWriter((Result)value);
            }
        } else if (to == XMLStreamReader.class) {
            if (value instanceof InputStream) {
                return this.getStaxConverter().createXMLStreamReader((InputStream)value, exchange);
            }
            if (value instanceof File) {
                return this.getStaxConverter().createXMLStreamReader((File)value, exchange);
            }
            if (value instanceof Reader) {
                return this.getStaxConverter().createXMLStreamReader((Reader)value);
            }
            if (value instanceof Source) {
                return this.getStaxConverter().createXMLStreamReader((Source)value);
            }
            if (value instanceof String) {
                return this.getStaxConverter().createXMLStreamReader((String)value);
            }
        } else if (to == XMLStreamWriter.class) {
            if (value instanceof OutputStream) {
                return this.getStaxConverter().createXMLStreamWriter((OutputStream)value, exchange);
            }
            if (value instanceof Writer) {
                return this.getStaxConverter().createXMLStreamWriter((Writer)value);
            }
            if (value instanceof Result) {
                return this.getStaxConverter().createXMLStreamWriter((Result)value);
            }
        } else if (to == Source.class) {
            if (value instanceof String) {
                return this.getXmlConverter().toSource((String)value);
            }
            if (value instanceof byte[]) {
                return this.getXmlConverter().toSource((byte[])value);
            }
            if (value instanceof Document) {
                return this.getXmlConverter().toSource((Document)value);
            }
            if (value instanceof StreamCache) {
                return this.getXmlConverter().toSource((StreamCache)value, exchange);
            }
        } else if (to == DOMSource.class) {
            if (value instanceof Document) {
                return this.getXmlConverter().toDOMSource((Document)value);
            }
            if (value instanceof Node) {
                return this.getXmlConverter().toDOMSource((Node)value);
            }
            if (value instanceof String) {
                return this.getXmlConverter().toDOMSource((String)value);
            }
            if (value instanceof byte[]) {
                return this.getXmlConverter().toDOMSource((byte[])value);
            }
            if (value instanceof StreamCache) {
                return this.getXmlConverter().toDOMSource((StreamCache)value, exchange);
            }
            if (value instanceof InputStream) {
                return this.getXmlConverter().toDOMSource((InputStream)value, exchange);
            }
            if (value instanceof File) {
                return this.getXmlConverter().toDOMSource((File)value, exchange);
            }
            if (value instanceof StreamSource) {
                return this.getXmlConverter().toDOMSourceFromStream((StreamSource)value, exchange);
            }
            if (value instanceof SAXSource) {
                return this.getXmlConverter().toDOMSourceFromSAX((SAXSource)value);
            }
            if (value instanceof StAXSource) {
                return this.getXmlConverter().toDOMSourceFromStAX((StAXSource)value);
            }
            if (value instanceof Source) {
                return this.getXmlConverter().toDOMSource((Source)value, exchange);
            }
        } else if (to == SAXSource.class) {
            if (value instanceof String) {
                return this.getXmlConverter().toSAXSource((String)value, exchange);
            }
            if (value instanceof InputStream) {
                return this.getXmlConverter().toSAXSource((InputStream)value, exchange);
            }
            if (value instanceof byte[]) {
                return this.getXmlConverter().toSAXSource((byte[])value, exchange);
            }
            if (value instanceof File) {
                return this.getXmlConverter().toSAXSource((File)value, exchange);
            }
            if (value instanceof StreamSource) {
                return this.getXmlConverter().toSAXSourceFromStream((StreamSource)value, exchange);
            }
            if (value instanceof DOMSource) {
                return this.getXmlConverter().toSAXSourceFromDOM((DOMSource)value, exchange);
            }
            if (value instanceof StAXSource) {
                return this.getXmlConverter().toSAXSourceFromStAX((StAXSource)value, exchange);
            }
            if (value instanceof Source) {
                return this.getXmlConverter().toSAXSource((Source)value, exchange);
            }
        } else if (to == StAXSource.class) {
            if (value instanceof String) {
                return this.getXmlConverter().toStAXSource((String)value, exchange);
            }
            if (value instanceof byte[]) {
                return this.getXmlConverter().toStAXSource((byte[])value, exchange);
            }
            if (value instanceof InputStream) {
                return this.getXmlConverter().toStAXSource((InputStream)value, exchange);
            }
            if (value instanceof File) {
                return this.getXmlConverter().toStAXSource((File)value, exchange);
            }
        } else if (to == StreamSource.class) {
            if (value instanceof String) {
                return this.getXmlConverter().toStreamSource((String)value);
            }
            if (value instanceof InputStream) {
                return this.getXmlConverter().toStreamSource((InputStream)value);
            }
            if (value instanceof Reader) {
                return this.getXmlConverter().toStreamSource((Reader)value);
            }
            if (value instanceof File) {
                return this.getXmlConverter().toStreamSource((File)value);
            }
            if (value instanceof byte[]) {
                return this.getXmlConverter().toStreamSource((byte[])value, exchange);
            }
            if (value instanceof ByteBuffer) {
                return this.getXmlConverter().toStreamSource((ByteBuffer)value, exchange);
            }
            if (value instanceof SAXSource) {
                return this.getXmlConverter().toStreamSourceFromSAX((SAXSource)value, exchange);
            }
            if (value instanceof DOMSource) {
                return this.getXmlConverter().toStreamSourceFromDOM((DOMSource)value, exchange);
            }
            if (value instanceof StAXSource) {
                return this.getXmlConverter().toStreamSourceFromStAX((StAXSource)value, exchange);
            }
            if (value instanceof Source) {
                return this.getXmlConverter().toStreamSource((Source)value, exchange);
            }
        } else if (to == StreamCache.class) {
            if (value instanceof BytesSource) {
                return StreamSourceConverter.convertToStreamCache((BytesSource)value);
            }
            if (value instanceof StreamSource) {
                return StreamSourceConverter.convertToStreamCache((StreamSource)value, exchange);
            }
            if (value instanceof SAXSource) {
                return StreamSourceConverter.convertToStreamCache((SAXSource)value, exchange);
            }
        } else if (to == BytesSource.class) {
            if (value instanceof byte[]) {
                return this.getXmlConverter().toBytesSource((byte[])value);
            }
        } else if (to == StringSource.class) {
            if (value instanceof String) {
                return this.getXmlConverter().toStringSource((String)value);
            }
        } else if (to == Document.class) {
            if (value instanceof Node) {
                return this.getXmlConverter().toDOMDocument((Node)value);
            }
            if (value instanceof byte[]) {
                return this.getXmlConverter().toDOMDocument((byte[])value, exchange);
            }
            if (value instanceof StreamCache) {
                return this.getXmlConverter().toDOMDocument((StreamCache)value, exchange);
            }
            if (value instanceof InputStream) {
                return this.getXmlConverter().toDOMDocument((InputStream)value, exchange);
            }
            if (value instanceof Reader) {
                return this.getXmlConverter().toDOMDocument((Reader)value, exchange);
            }
            if (value instanceof InputSource) {
                return this.getXmlConverter().toDOMDocument((InputSource)value, exchange);
            }
            if (value instanceof String) {
                return this.getXmlConverter().toDOMDocument((String)value, exchange);
            }
            if (value instanceof File) {
                return this.getXmlConverter().toDOMDocument((File)value, exchange);
            }
            if (value instanceof Source) {
                return this.getXmlConverter().toDOMDocument((Source)value);
            }
            if (value instanceof NodeList) {
                Document obj = this.getXmlConverter().toDOMDocumentFromSingleNodeList((NodeList)value);
                if (obj == null) {
                    return Void.class;
                }
                return obj;
            }
        } else if (to == Element.class) {
            if (value instanceof Source) {
                return this.getXmlConverter().toDOMElement((Source)value);
            }
            if (value instanceof Node) {
                return this.getXmlConverter().toDOMElement((Node)value);
            }
        } else if (to == Node.class) {
            if (value instanceof SAXSource) {
                return this.getXmlConverter().toDOMNodeFromSAX((SAXSource)value);
            }
            if (value instanceof StAXSource) {
                return this.getXmlConverter().toDOMNodeFromStAX((StAXSource)value);
            }
            if (value instanceof NodeList) {
                Node obj = this.getXmlConverter().toDOMNodeFromSingleNodeList((NodeList)value);
                if (obj == null) {
                    return Void.class;
                }
                return obj;
            }
            if (value instanceof Source) {
                Node obj = this.getXmlConverter().toDOMNode((Source)value);
                if (obj == null) {
                    return Void.class;
                }
                return obj;
            }
        } else if (to == InputSource.class) {
            if (value instanceof InputStream) {
                return this.getXmlConverter().toInputSource((InputStream)value, exchange);
            }
            if (value instanceof File) {
                return this.getXmlConverter().toInputSource((File)value, exchange);
            }
        }
        return null;
    }

    private void doRegistration(TypeConverterRegistry registry) {
        registry.addConverter(new TypeConvertible(NodeList.class, byte[].class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, byte[].class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(NodeList.class, InputStream.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(XMLStreamReader.class, InputStream.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(DOMSource.class, InputStream.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Document.class, InputStream.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StreamSource.class, InputStream.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(XMLStreamReader.class, Reader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StreamSource.class, Reader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, Reader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StreamCache.class, Serializable.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(NodeList.class, Boolean.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(NodeList.class, Integer.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(NodeList.class, Long.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(NodeList.class, String.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Node.class, String.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, String.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(NodeList.class, List.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, QName.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, XMLEventReader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(File.class, XMLEventReader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Reader.class, XMLEventReader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(XMLStreamReader.class, XMLEventReader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, XMLEventReader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(OutputStream.class, XMLEventWriter.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Writer.class, XMLEventWriter.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Result.class, XMLEventWriter.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, XMLStreamReader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(File.class, XMLStreamReader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Reader.class, XMLStreamReader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, XMLStreamReader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, XMLStreamReader.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(OutputStream.class, XMLStreamWriter.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Writer.class, XMLStreamWriter.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Result.class, XMLStreamWriter.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, Source.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(byte[].class, Source.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Document.class, Source.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StreamCache.class, Source.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Document.class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Node.class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(byte[].class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StreamCache.class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(File.class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StreamSource.class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(SAXSource.class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StAXSource.class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, DOMSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, SAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, SAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(byte[].class, SAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(File.class, SAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StreamSource.class, SAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(DOMSource.class, SAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StAXSource.class, SAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, SAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, StAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(byte[].class, StAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, StAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(File.class, StAXSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, StreamSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, StreamSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Reader.class, StreamSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(File.class, StreamSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(byte[].class, StreamSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(ByteBuffer.class, StreamSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(SAXSource.class, StreamSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(DOMSource.class, StreamSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StAXSource.class, StreamSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, StreamSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(BytesSource.class, StreamCache.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StreamSource.class, StreamCache.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(SAXSource.class, StreamCache.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(byte[].class, BytesSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, StringSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Node.class, Document.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(byte[].class, Document.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StreamCache.class, Document.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, Document.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Reader.class, Document.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputSource.class, Document.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, Document.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(File.class, Document.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, Document.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(NodeList.class, Document.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, Element.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Node.class, Element.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(SAXSource.class, Node.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(StAXSource.class, Node.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(NodeList.class, Node.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Source.class, Node.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, InputSource.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(File.class, InputSource.class), (TypeConverter)this);
    }

    public TypeConverter lookup(Class<?> to, Class<?> from) {
        if (to == byte[].class) {
            if (from == NodeList.class) {
                return this;
            }
            if (from == Source.class) {
                return this;
            }
        } else if (to == InputStream.class) {
            if (from == NodeList.class) {
                return this;
            }
            if (from == XMLStreamReader.class) {
                return this;
            }
            if (from == DOMSource.class) {
                return this;
            }
            if (from == Document.class) {
                return this;
            }
            if (from == StreamSource.class) {
                return this;
            }
        } else if (to == Reader.class) {
            if (from == XMLStreamReader.class) {
                return this;
            }
            if (from == StreamSource.class) {
                return this;
            }
            if (from == Source.class) {
                return this;
            }
        } else if (to == Serializable.class) {
            if (from == StreamCache.class) {
                return this;
            }
        } else if (to == Boolean.class || to == Boolean.TYPE) {
            if (from == NodeList.class) {
                return this;
            }
        } else if (to == Integer.class || to == Integer.TYPE) {
            if (from == NodeList.class) {
                return this;
            }
        } else if (to == Long.class || to == Long.TYPE) {
            if (from == NodeList.class) {
                return this;
            }
        } else if (to == String.class) {
            if (from == NodeList.class) {
                return this;
            }
            if (from == Node.class) {
                return this;
            }
            if (from == Source.class) {
                return this;
            }
        } else if (to == List.class) {
            if (from == NodeList.class) {
                return this;
            }
        } else if (to == QName.class) {
            if (from == String.class) {
                return this;
            }
        } else if (to == XMLEventReader.class) {
            if (from == InputStream.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == Reader.class) {
                return this;
            }
            if (from == XMLStreamReader.class) {
                return this;
            }
            if (from == Source.class) {
                return this;
            }
        } else if (to == XMLEventWriter.class) {
            if (from == OutputStream.class) {
                return this;
            }
            if (from == Writer.class) {
                return this;
            }
            if (from == Result.class) {
                return this;
            }
        } else if (to == XMLStreamReader.class) {
            if (from == InputStream.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == Reader.class) {
                return this;
            }
            if (from == Source.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == XMLStreamWriter.class) {
            if (from == OutputStream.class) {
                return this;
            }
            if (from == Writer.class) {
                return this;
            }
            if (from == Result.class) {
                return this;
            }
        } else if (to == Source.class) {
            if (from == String.class) {
                return this;
            }
            if (from == byte[].class) {
                return this;
            }
            if (from == Document.class) {
                return this;
            }
            if (from == StreamCache.class) {
                return this;
            }
        } else if (to == DOMSource.class) {
            if (from == Document.class) {
                return this;
            }
            if (from == Node.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
            if (from == byte[].class) {
                return this;
            }
            if (from == StreamCache.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == StreamSource.class) {
                return this;
            }
            if (from == SAXSource.class) {
                return this;
            }
            if (from == StAXSource.class) {
                return this;
            }
            if (from == Source.class) {
                return this;
            }
        } else if (to == SAXSource.class) {
            if (from == String.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == byte[].class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == StreamSource.class) {
                return this;
            }
            if (from == DOMSource.class) {
                return this;
            }
            if (from == StAXSource.class) {
                return this;
            }
            if (from == Source.class) {
                return this;
            }
        } else if (to == StAXSource.class) {
            if (from == String.class) {
                return this;
            }
            if (from == byte[].class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
        } else if (to == StreamSource.class) {
            if (from == String.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == Reader.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == byte[].class) {
                return this;
            }
            if (from == ByteBuffer.class) {
                return this;
            }
            if (from == SAXSource.class) {
                return this;
            }
            if (from == DOMSource.class) {
                return this;
            }
            if (from == StAXSource.class) {
                return this;
            }
            if (from == Source.class) {
                return this;
            }
        } else if (to == StreamCache.class) {
            if (from == BytesSource.class) {
                return this;
            }
            if (from == StreamSource.class) {
                return this;
            }
            if (from == SAXSource.class) {
                return this;
            }
        } else if (to == BytesSource.class) {
            if (from == byte[].class) {
                return this;
            }
        } else if (to == StringSource.class) {
            if (from == String.class) {
                return this;
            }
        } else if (to == Document.class) {
            if (from == Node.class) {
                return this;
            }
            if (from == byte[].class) {
                return this;
            }
            if (from == StreamCache.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == Reader.class) {
                return this;
            }
            if (from == InputSource.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == Source.class) {
                return this;
            }
            if (from == NodeList.class) {
                return this;
            }
        } else if (to == Element.class) {
            if (from == Source.class) {
                return this;
            }
            if (from == Node.class) {
                return this;
            }
        } else if (to == Node.class) {
            if (from == SAXSource.class) {
                return this;
            }
            if (from == StAXSource.class) {
                return this;
            }
            if (from == NodeList.class) {
                return this;
            }
            if (from == Source.class) {
                return this;
            }
        } else if (to == InputSource.class) {
            if (from == InputStream.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
        }
        return null;
    }

    private DomConverter getDomConverter() {
        if (this.domConverter == null) {
            this.domConverter = new DomConverter();
            CamelContextAware.trySetCamelContext((Object)this.domConverter, (CamelContext)this.camelContext);
        }
        return this.domConverter;
    }

    private StaxConverter getStaxConverter() {
        if (this.staxConverter == null) {
            this.staxConverter = new StaxConverter();
            CamelContextAware.trySetCamelContext((Object)this.staxConverter, (CamelContext)this.camelContext);
        }
        return this.staxConverter;
    }

    private XmlConverter getXmlConverter() {
        if (this.xmlConverter == null) {
            this.xmlConverter = new XmlConverter();
            CamelContextAware.trySetCamelContext((Object)this.xmlConverter, (CamelContext)this.camelContext);
        }
        return this.xmlConverter;
    }
}

