/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder.xml;

import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLConverterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(XMLConverterHelper.class);
    private static final ErrorHandler DOCUMENT_BUILDER_LOGGING_ERROR_HANDLER = new DocumentBuilderLoggingErrorHandler();
    private static final String DOCUMENT_BUILDER_FACTORY_FEATURE = "org.apache.camel.xmlconverter.documentBuilderFactory.feature";
    private static final String JDK_FALLBACK_TRANSFORMER_FACTORY = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private volatile DocumentBuilderFactory documentBuilderFactory;
    private volatile TransformerFactory transformerFactory;

    public XMLConverterHelper() {
    }

    public XMLConverterHelper(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.createTransformerFactory();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document toDOMDocument(Node node) throws ParserConfigurationException, TransformerException {
        ObjectHelper.notNull((Object)node, (String)"node");
        if (node instanceof Document) {
            return (Document)node;
        }
        if (node instanceof Element) {
            Element elem = (Element)node;
            if (elem.getOwnerDocument().getDocumentElement() == elem) {
                return elem.getOwnerDocument();
            }
            Document doc = this.createDocument();
            Document document = node.getOwnerDocument();
            synchronized (document) {
                doc.appendChild(doc.importNode(node, true));
            }
            return doc;
        }
        throw new TransformerException("Unable to convert DOM node to a Document: " + node);
    }

    public DOMSource toDOMSource(Node node) throws ParserConfigurationException, TransformerException {
        Document document = this.toDOMDocument(node);
        return new DOMSource(document);
    }

    public DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (ParserConfigurationException e) {
            LOG.warn("DocumentBuilderFactory doesn't support the feature {} with value {}, due to {}.", new Object[]{"http://javax.xml.XMLConstants/feature/secure-processing", true, e.getMessage()});
        }
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            LOG.warn("DocumentBuilderFactory doesn't support the feature {} with value {}, due to {}.", new Object[]{"http://apache.org/xml/features/disallow-doctype-decl", true, e.getMessage()});
        }
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        }
        catch (ParserConfigurationException e) {
            LOG.warn("DocumentBuilderFactory doesn't support the feature {} with value {}, due to {}.", new Object[]{"http://apache.org/xml/features/disallow-doctype-decl", true, e.getMessage(), e});
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException e) {
            LOG.warn("DocumentBuilderFactory doesn't support the feature {} with value {}, due to {}.", new Object[]{"http://xml.org/sax/features/external-general-entities", false, e.getMessage()});
        }
        try {
            Class smClass = ObjectHelper.loadClass((String)"org.apache.xerces.util.SecurityManager");
            if (smClass != null) {
                Object sm = smClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                factory.setAttribute("http://apache.org/xml/properties/security-manager", sm);
            }
        }
        catch (Exception e) {
            LOG.warn("DocumentBuilderFactory doesn't support the attribute {}, due to {}.", (Object)"http://apache.org/xml/properties/security-manager", (Object)e.getMessage());
        }
        this.setupFeatures(factory);
        return factory;
    }

    public TransformerFactory createTransformerFactory() {
        TransformerFactory factory;
        try {
            factory = TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError e) {
            TransformerFactoryConfigurationError cause = e;
            try {
                LOG.debug("Cannot create/load TransformerFactory due: {}. Will attempt to use JDK fallback TransformerFactory: {}", (Object)e.getMessage(), (Object)JDK_FALLBACK_TRANSFORMER_FACTORY);
                factory = TransformerFactory.newInstance(JDK_FALLBACK_TRANSFORMER_FACTORY, null);
            }
            catch (Exception t) {
                throw cause;
            }
        }
        LOG.debug("Created TransformerFactory: {}", (Object)factory);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            LOG.warn("TransformerFactory doesn't support the feature {} with value {}, due to {}.", new Object[]{"http://javax.xml.XMLConstants/feature/secure-processing", "true", e.getMessage(), e});
        }
        LOG.debug("Configuring TransformerFactory to not allow access to external DTD/Stylesheet");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        factory.setErrorListener(new XmlErrorListener());
        this.configureSaxonTransformerFactory(factory);
        return factory;
    }

    public void configureSaxonTransformerFactory(TransformerFactory factory) {
        ClassLoader loader;
        int[] version;
        Class<?> factoryClass = factory.getClass();
        if ((factoryClass.getName().startsWith("net.sf.saxon") || factoryClass.getName().startsWith("com.saxonica")) && null != (version = this.retrieveSaxonVersion(loader = factoryClass.getClassLoader())) && version[0] < 12) {
            Class<?> messageWarner = null;
            if (version[0] > 9 || version[0] == 9 && version[1] >= 3) {
                try {
                    messageWarner = loader.loadClass("net.sf.saxon.serialize.MessageWarner");
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Error loading Saxon's net.sf.saxon.serialize.MessageWarner class from the classpath! <xsl:message> output will not be redirected to the ErrorListener!");
                }
            } else {
                try {
                    messageWarner = loader.loadClass("net.sf.saxon.event.MessageWarner");
                }
                catch (ClassNotFoundException cnfe2) {
                    LOG.warn("Error loading Saxon's net.sf.saxon.event.MessageWarner class from the classpath! <xsl:message> output will not be redirected to the ErrorListener!");
                }
            }
            if (messageWarner != null) {
                factory.setAttribute("http://saxon.sf.net/feature/messageEmitterClass", messageWarner.getName());
            }
        }
    }

    private int[] retrieveSaxonVersion(ClassLoader loader) {
        try {
            Class<?> versionClass = loader.loadClass("net.sf.saxon.Version");
            Method method = versionClass.getDeclaredMethod("getStructuredVersionNumber", new Class[0]);
            Object result = method.invoke(null, new Object[0]);
            return (int[])result;
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Error loading Saxon's net.sf.saxon.Version class from the classpath!");
        }
        catch (InvocationTargetException e) {
            LOG.warn("Error retrieving Saxon version from net.sf.saxon.Version!");
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Method getStructuredVersionNumber not available on net.sf.saxon.Version!");
        }
        catch (IllegalAccessException e) {
            LOG.warn("Unable to access method getStructuredVersionNumber on net.sf.saxon.Version!");
        }
        return null;
    }

    public Document createDocument() throws ParserConfigurationException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.newDocument();
    }

    public DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        return this.createDocumentBuilder(this.getDocumentBuilderFactory());
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = this.createDocumentBuilderFactory();
        }
        return this.documentBuilderFactory;
    }

    public DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(DOCUMENT_BUILDER_LOGGING_ERROR_HANDLER);
        return builder;
    }

    protected void setupFeatures(DocumentBuilderFactory factory) {
        Properties properties = System.getProperties();
        ArrayList<CallSite> features = new ArrayList<CallSite>();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            String string = (String)prop.getKey();
            if (!string.startsWith(DOCUMENT_BUILDER_FACTORY_FEATURE)) continue;
            String uri = StringHelper.after((String)string, (String)":");
            boolean value = Boolean.parseBoolean((String)prop.getValue());
            try {
                factory.setFeature(uri, value);
                features.add((CallSite)((Object)("feature " + uri + " value " + value)));
            }
            catch (ParserConfigurationException e) {
                LOG.warn("DocumentBuilderFactory doesn't support the feature {} with value {}, due to {}.", new Object[]{uri, value, e.getMessage(), e});
            }
        }
        if (!features.isEmpty()) {
            StringBuilder featureString = new StringBuilder();
            for (String string : features) {
                if (!featureString.isEmpty()) {
                    featureString.append(", ");
                }
                featureString.append(string);
            }
            LOG.info("DocumentBuilderFactory has been set with features {{}}.", (Object)featureString);
        }
    }

    private static class XmlErrorListener
    implements ErrorListener {
        private XmlErrorListener() {
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            LOG.warn(e.getMessage(), (Throwable)e);
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            LOG.error(e.getMessage(), (Throwable)e);
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private static class DocumentBuilderLoggingErrorHandler
    implements ErrorHandler {
        private DocumentBuilderLoggingErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOG.warn(exception.getMessage(), (Throwable)exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            LOG.error(exception.getMessage(), (Throwable)exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOG.error(exception.getMessage(), (Throwable)exception);
        }
    }
}

