/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.component.xslt.XsltBuilder;
import org.apache.camel.component.xslt.XsltOutput;
import org.apache.camel.component.xslt.XsltUriResolver;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Metadata(label="bean", description="The XSLT Aggregation Strategy enables you to use XSL stylesheets to aggregate messages.", annotations={"interfaceName=org.apache.camel.AggregationStrategy"})
@Configurer(metadataOnly=true)
public class XsltAggregationStrategy
extends ServiceSupport
implements AggregationStrategy,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(XsltAggregationStrategy.class);
    private static final String DEFAULT_PROPERTY_NAME = "new-exchange";
    private volatile XsltBuilder xslt;
    private volatile URIResolver uriResolver;
    private CamelContext camelContext;
    @Metadata(description="The name of the XSL transformation file to use", required=true)
    private String xslFile;
    @Metadata(description="The exchange property name that contains the XML payloads as an input", defaultValue="new-exchange")
    private String propertyName;
    private TransformerFactory transformerFactory;
    @Metadata(label="advanced", description="To use a custom XSLT transformer factory, specified as a FQN class name")
    private String transformerFactoryClass;
    @Metadata(defaultValue="string", enums="string,bytes,DOM,file", description="Option to specify which output type to use. Possible values are: string, bytes, DOM, file. The first three options are all in memory based, where as file is streamed directly to a java.io.File. For file you must specify the filename in the IN header with the key XsltConstants.XSLT_FILE_NAME which is also CamelXsltFileName. Also any paths leading to the filename must be created beforehand, otherwise an exception is thrown at runtime.")
    private XsltOutput output = XsltOutput.string;

    public XsltAggregationStrategy(String xslFileLocation) {
        this.xslFile = xslFileLocation;
    }

    public String getXslFile() {
        return this.xslFile;
    }

    public void setXslFile(String xslFile) {
        this.xslFile = xslFile;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            return newExchange;
        }
        if (!this.isRunAllowed()) {
            throw new RejectedExecutionException();
        }
        try {
            oldExchange.setProperty(this.propertyName, newExchange.getIn().getBody(Document.class));
            this.xslt.process(oldExchange);
            return oldExchange;
        }
        catch (Exception e) {
            oldExchange.setException((Throwable)e);
            return oldExchange;
        }
    }

    public XsltOutput getOutput() {
        return this.output;
    }

    public void setOutput(XsltOutput output) {
        this.output = output;
    }

    public void setXslt(XsltBuilder xslt) {
        this.xslt = xslt;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public String getTransformerFactoryClass() {
        return this.transformerFactoryClass;
    }

    public void setTransformerFactoryClass(String transformerFactoryClass) {
        this.transformerFactoryClass = transformerFactoryClass;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    protected void configureOutput(XsltBuilder xslt, String output) throws Exception {
        if (ObjectHelper.isEmpty((String)output)) {
            return;
        }
        if ("string".equalsIgnoreCase(output)) {
            xslt.outputString();
        } else if ("bytes".equalsIgnoreCase(output)) {
            xslt.outputBytes();
        } else if ("DOM".equalsIgnoreCase(output)) {
            xslt.outputDOM();
        } else if ("file".equalsIgnoreCase(output)) {
            xslt.outputFile();
        } else {
            throw new IllegalArgumentException("Unknown output type: " + output);
        }
    }

    protected void loadResource(String resourceUri) throws TransformerException, IOException {
        LOG.trace("{} loading schema resource: {}", (Object)this, (Object)resourceUri);
        Source source = this.xslt.getUriResolver().resolve(resourceUri, null);
        if (source == null) {
            throw new IOException("Cannot load schema resource " + resourceUri);
        }
        this.xslt.setTransformerSource(source);
    }

    public static XsltAggregationStrategy create(String xslFile) {
        return new XsltAggregationStrategy(xslFile);
    }

    public XsltAggregationStrategy withPropertyName(String propertyName) {
        this.setPropertyName(propertyName);
        return this;
    }

    public XsltAggregationStrategy withOutput(XsltOutput output) {
        this.setOutput(output);
        return this;
    }

    public XsltAggregationStrategy withUriResolver(URIResolver resolver) {
        this.setUriResolver(resolver);
        return this;
    }

    public XsltAggregationStrategy withTransformerFactoryClass(String clazz) {
        this.setTransformerFactoryClass(clazz);
        return this;
    }

    protected XsltBuilder createXsltBuilder() {
        return (XsltBuilder)this.camelContext.getInjector().newInstance(XsltBuilder.class);
    }

    protected void doInit() throws Exception {
        super.doInit();
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        this.propertyName = ObjectHelper.isNotEmpty((String)this.propertyName) ? this.propertyName : DEFAULT_PROPERTY_NAME;
        this.xslt = this.createXsltBuilder();
        if (this.transformerFactory == null && this.transformerFactoryClass != null) {
            Class factoryClass = this.camelContext.getClassResolver().resolveMandatoryClass(this.transformerFactoryClass, XsltAggregationStrategy.class.getClassLoader());
            TransformerFactory factory = (TransformerFactory)this.camelContext.getInjector().newInstance(factoryClass);
            this.xslt.setTransformerFactory(factory);
        } else if (this.transformerFactory != null) {
            this.xslt.setTransformerFactory(this.transformerFactory);
        }
        if (this.uriResolver == null) {
            this.uriResolver = new XsltUriResolver(this.camelContext, this.xslFile);
        }
        this.xslt.setUriResolver(this.uriResolver);
        this.xslt.setFailOnNullBody(true);
        this.xslt.transformerCacheSize(0);
        this.configureOutput(this.xslt, this.output.name());
        if (ResourceHelper.isClasspathUri((String)this.xslFile)) {
            this.loadResource(this.xslFile);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!ResourceHelper.isClasspathUri((String)this.xslFile)) {
            this.loadResource(this.xslFile);
        }
    }

    protected void doStop() throws Exception {
    }
}

