/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.yaml;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.ModelToYAMLDumper;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.yaml.out.ModelWriter;

@JdkService(value="modelyaml-dumper")
public class LwModelToYAMLDumper
implements ModelToYAMLDumper {
    public String dumpModelAsYaml(CamelContext context, NamedNode definition) throws Exception {
        return this.dumpModelAsYaml(context, definition, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpModelAsYaml(final CamelContext context, NamedNode definition, final boolean resolvePlaceholders, boolean uriAsParameters) throws Exception {
        final Properties properties = new Properties();
        LinkedHashMap namespaces = new LinkedHashMap();
        HashMap locations = new HashMap();
        Consumer<RouteDefinition> extractor = route -> {
            Map parameters;
            LwModelToYAMLDumper.extractNamespaces(route, namespaces);
            if (context.isDebugging().booleanValue()) {
                LwModelToYAMLDumper.extractSourceLocations(route, locations);
            }
            LwModelToYAMLDumper.resolveEndpointDslUris(route);
            if (Boolean.TRUE.equals(route.isTemplate()) && (parameters = route.getTemplateParameters()) != null) {
                properties.putAll((Map<?, ?>)parameters);
            }
        };
        StringWriter buffer = new StringWriter();
        ModelWriter writer = new ModelWriter(buffer){

            @Override
            protected void doWriteOptionalIdentifiedDefinitionAttributes(OptionalIdentifiedDefinition<?> def) throws IOException {
                if (Boolean.TRUE.equals(def.getCustomId())) {
                    this.doWriteAttribute("customId", this.toString(def.getCustomId()));
                }
                this.doWriteAttribute("id", def.getId());
                if (context.isDebugging().booleanValue()) {
                    String loc = (def instanceof RouteDefinition ? ((RouteDefinition)def).getInput() : def).getLocation();
                    int line = (def instanceof RouteDefinition ? ((RouteDefinition)def).getInput() : def).getLineNumber();
                    if (line != -1) {
                        this.writer.addAttribute("sourceLineNumber", Integer.toString(line));
                        this.writer.addAttribute("sourceLocation", loc);
                    }
                }
            }

            @Override
            protected void doWriteValue(String value) throws IOException {
                if (value != null && !value.isEmpty()) {
                    super.doWriteValue(value);
                }
            }

            @Override
            protected void text(String name, String text) throws IOException {
                if (resolvePlaceholders) {
                    text = this.resolve(text, properties);
                }
                super.text(name, text);
            }

            @Override
            protected void attribute(String name, Object value) throws IOException {
                if (resolvePlaceholders && value != null) {
                    value = this.resolve(value.toString(), properties);
                }
                super.attribute(name, value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            String resolve(String value, Properties properties2) {
                context.getPropertiesComponent().setLocalProperties(properties2);
                try {
                    String string = context.resolvePropertyPlaceholders(value);
                    return string;
                }
                catch (Exception e) {
                    String string = value;
                    return string;
                }
                finally {
                    context.getPropertiesComponent().setLocalProperties(null);
                }
            }
        };
        if (definition instanceof RouteTemplatesDefinition) {
            RouteTemplatesDefinition templates = (RouteTemplatesDefinition)definition;
            templates.getRouteTemplates().forEach(template -> extractor.accept(template.getRoute()));
        } else if (definition instanceof RouteTemplateDefinition) {
            RouteTemplateDefinition template2 = (RouteTemplateDefinition)definition;
            extractor.accept(template2.getRoute());
        } else if (definition instanceof RoutesDefinition) {
            RoutesDefinition routes = (RoutesDefinition)definition;
            routes.getRoutes().forEach(extractor);
        } else if (definition instanceof RouteDefinition) {
            RouteDefinition route2 = (RouteDefinition)definition;
            extractor.accept(route2);
        }
        writer.setUriAsParameters(uriAsParameters);
        writer.setCamelContext(context);
        writer.start();
        try {
            writer.writeOptionalIdentifiedDefinitionRef((OptionalIdentifiedDefinition)definition);
        }
        finally {
            writer.stop();
        }
        return buffer.toString();
    }

    private static void extractNamespaces(RouteDefinition route, Map<String, String> namespaces) {
        Collection col = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), ExpressionNode.class);
        for (ExpressionNode en : col) {
            Map map;
            NamespaceAware na = LwModelToYAMLDumper.getNamespaceAwareFromExpression(en);
            if (na == null || (map = na.getNamespaces()) == null || map.isEmpty()) continue;
            namespaces.putAll(map);
        }
    }

    private static void extractSourceLocations(RouteDefinition route, Map<String, KeyValueHolder<Integer, String>> locations) {
        String id = route.getRouteId();
        String loc = route.getInput().getLocation();
        int line = route.getInput().getLineNumber();
        if (id != null && line != -1) {
            locations.put(id, (KeyValueHolder<Integer, String>)new KeyValueHolder((Object)line, (Object)loc));
        }
        for (OptionalIdentifiedDefinition def : ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), OptionalIdentifiedDefinition.class)) {
            id = def.getId();
            loc = def.getLocation();
            line = def.getLineNumber();
            if (id == null || line == -1) continue;
            locations.put(id, (KeyValueHolder<Integer, String>)new KeyValueHolder((Object)line, (Object)loc));
        }
    }

    private static void resolveEndpointDslUris(RouteDefinition route) {
        FromDefinition from = route.getInput();
        if (from != null && from.getEndpointConsumerBuilder() != null) {
            String uri = from.getEndpointConsumerBuilder().getRawUri();
            from.setUri(uri);
        }
        Collection col = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), SendDefinition.class);
        for (SendDefinition to : col) {
            if (to.getEndpointProducerBuilder() == null) continue;
            String uri = to.getEndpointProducerBuilder().getRawUri();
            to.setUri(uri);
        }
        Collection col2 = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), ToDynamicDefinition.class);
        for (ToDynamicDefinition to : col2) {
            if (to.getEndpointProducerBuilder() == null) continue;
            String uri = to.getEndpointProducerBuilder().getRawUri();
            to.setUri(uri);
        }
    }

    private static NamespaceAware getNamespaceAwareFromExpression(ExpressionNode expressionNode) {
        ExpressionDefinition ed = expressionNode.getExpression();
        NamespaceAware na = null;
        Expression exp = ed.getExpressionValue();
        if (exp instanceof NamespaceAware) {
            na = (NamespaceAware)exp;
        } else if (ed instanceof NamespaceAware) {
            na = (NamespaceAware)ed;
        }
        return na;
    }
}

