/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.utils.SimpleCondition;

public abstract class AbstractWriteResponseHandler
implements IAsyncCallback {
    private static Predicate<InetAddress> isAlive = new Predicate<InetAddress>(){

        public boolean apply(InetAddress endpoint) {
            return FailureDetector.instance.isAlive(endpoint);
        }
    };
    private final SimpleCondition condition = new SimpleCondition();
    protected final Table table;
    protected final long startTime;
    protected final Collection<InetAddress> naturalEndpoints;
    protected final ConsistencyLevel consistencyLevel;
    protected final Runnable callback;
    protected final Collection<InetAddress> pendingEndpoints;
    private final WriteType writeType;

    protected AbstractWriteResponseHandler(Table table, Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, Runnable callback, WriteType writeType) {
        this.table = table;
        this.pendingEndpoints = pendingEndpoints;
        this.startTime = System.currentTimeMillis();
        this.consistencyLevel = consistencyLevel;
        this.naturalEndpoints = naturalEndpoints;
        this.callback = callback;
        this.writeType = writeType;
    }

    public void get() throws WriteTimeoutException {
        boolean success;
        long timeout = DatabaseDescriptor.getWriteRpcTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            int blockedFor;
            int acks = this.ackCount();
            if (acks >= (blockedFor = this.totalBlockFor())) {
                acks = blockedFor - 1;
            }
            throw new WriteTimeoutException(this.writeType, this.consistencyLevel, acks, blockedFor);
        }
    }

    protected int totalBlockFor() {
        return this.consistencyLevel.blockFor(this.table) + this.pendingEndpoints.size();
    }

    protected abstract int ackCount();

    public abstract void response(MessageIn var1);

    public void assureSufficientLiveNodes() throws UnavailableException {
        this.consistencyLevel.assureSufficientLiveNodes(this.table, Iterables.filter((Iterable)Iterables.concat(this.naturalEndpoints, this.pendingEndpoints), isAlive));
    }

    protected void signal() {
        this.condition.signal();
        if (this.callback != null) {
            this.callback.run();
        }
    }
}

